/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.db;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.text.Collator;
import org.eclipse.dali.db.ConnectionListener;
import org.eclipse.dali.db.Database;
import org.eclipse.dali.db.NullConnection;
import org.eclipse.dali.db.RDBConnectionInfoWrapper;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;

public abstract class Connection
implements Comparable {
    static Connection createConnection(ConnectionInfo rdbConnectionInfo) {
        return rdbConnectionInfo == null ? NullConnection.instance() : new RDBConnectionInfoWrapper(rdbConnectionInfo);
    }

    Connection() {
    }

    public abstract void connect(String var1, String var2) throws Exception;

    public abstract void connect() throws Exception;

    public abstract void disconnect() throws SQLException;

    public abstract void saveConnectionInfo() throws FileNotFoundException, IOException;

    public abstract void dispose();

    abstract boolean wraps(ConnectionInfo var1);

    public abstract String getName();

    public abstract String getUserName();

    public abstract String getDatabaseProductVersion();

    public abstract String getDatabaseName();

    public abstract Database getDatabase();

    public boolean isConnected() {
        return this.getDatabase().isConnected();
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.getName());
    }

    public abstract void addConnectionListener(ConnectionListener var1);

    public abstract void removeConnectionListener(ConnectionListener var1);

    public int compareTo(Object o) {
        return Collator.getInstance().compare(this.getName(), ((Connection)o).getName());
    }
}

