/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.common.dialogs;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wtp.jsf.facesconfig.editor.common.CommonPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogs.TreeViewerSelectionDialog;
import org.eclipse.wtp.jsf.facesconfig.editor.common.utils.PathUtil;

public class ResourceOnClasspathDialog
extends TreeViewerSelectionDialog {
    private static final String STATUS_MESSAGE = CommonPlugin.getResourceString("Dialog.ResourceOnClasspathDialog.StatusMessage");
    private IJavaProject javaProject;
    private String[] suffixs;
    private ResourceOnClasspathFilter filter;

    public void setSuffixs(String[] suffixs) {
        this.suffixs = suffixs;
        this.filter.setSuffixs(this.suffixs);
    }

    public ResourceOnClasspathDialog(Shell parentShell, IJavaProject project) {
        super(parentShell, STATUS_MESSAGE);
        StandardJavaElementContentProvider contentProvider = new StandardJavaElementContentProvider();
        this.setContentProvider((ITreeContentProvider)contentProvider);
        this.setLabelProvider((ILabelProvider)new JavaElementLabelProvider());
        this.filter = new ResourceOnClasspathFilter(contentProvider);
        this.setFilter(this.filter);
        this.javaProject = project;
    }

    public Object[] getResult() {
        Object[] objects = super.getResult();
        if (objects == null || objects.length == 0) {
            return null;
        }
        IPath path = PathUtil.getPathOnClasspath(this.javaProject, objects[0]);
        String result = null;
        if (path.segmentCount() == 0) {
            return new Object[]{""};
        }
        path = path.removeFileExtension();
        result = path.toOSString();
        result = result.replace(File.separatorChar, '.');
        return new Object[]{result};
    }

    protected boolean isValidSelection(Object selection) {
        String extension = PathUtil.getPathOnClasspath(this.javaProject, selection).getFileExtension();
        return extension != null && Arrays.asList(this.suffixs).contains(extension);
    }

    protected Object findInputElement() {
        IWorkspace input = ResourcesPlugin.getWorkspace();
        if (input instanceof IWorkspace) {
            return JavaCore.create((IWorkspaceRoot)input.getRoot());
        }
        if (input instanceof IContainer) {
            IJavaElement element = JavaCore.create((IResource)((IContainer)input));
            if (element != null && element.exists()) {
                return element;
            }
            return input;
        }
        return JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }

    class ResourceOnClasspathFilter
    extends ViewerFilter {
        StandardJavaElementContentProvider _javaContentProvider;

        public ResourceOnClasspathFilter(StandardJavaElementContentProvider contentProvider) {
            this._javaContentProvider = contentProvider;
        }

        public void setSuffixs(String[] newSuffixs) {
            ResourceOnClasspathDialog.this.suffixs = newSuffixs;
        }

        public void setJavaContentProvider(StandardJavaElementContentProvider contentProvider) {
            this._javaContentProvider = contentProvider;
        }

        public void setJavaProject(IJavaProject project) {
            ResourceOnClasspathDialog.this.javaProject = project;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IJavaProject) {
                String currentProjectName = ((IJavaProject)element).getProject().getFullPath().toString().trim();
                String projectName = ResourceOnClasspathDialog.this.javaProject.getProject().getFullPath().toString().trim();
                return projectName.equalsIgnoreCase(currentProjectName);
            }
            if (element instanceof IResource) {
                if (ResourceOnClasspathDialog.this.javaProject != null && !ResourceOnClasspathDialog.this.javaProject.isOnClasspath((IResource)element)) {
                    return false;
                }
                return element instanceof IFile && Arrays.asList(ResourceOnClasspathDialog.this.suffixs).contains(((IFile)element).getFileExtension());
            }
            if (element instanceof JarEntryFile) {
                String ext = ((JarEntryFile)element).getFullPath().getFileExtension();
                return ext != null && Arrays.asList(ResourceOnClasspathDialog.this.suffixs).contains(ext);
            }
            if (!(element instanceof IJavaElement)) {
                return false;
            }
            if (ResourceOnClasspathDialog.this.javaProject != null && !ResourceOnClasspathDialog.this.javaProject.isOnClasspath((IJavaElement)element)) {
                return false;
            }
            IJavaElement javaElement = (IJavaElement)element;
            Object[] children = null;
            switch (javaElement.getElementType()) {
                case 3: {
                    children = this._javaContentProvider.getChildren((Object)javaElement);
                    break;
                }
                case 12: {
                    return true;
                }
                case 4: {
                    children = this._javaContentProvider.getChildren((Object)javaElement);
                    break;
                }
                case 6: {
                    return Arrays.asList(ResourceOnClasspathDialog.this.suffixs).contains("class");
                }
                case 5: {
                    String ext = javaElement.getPath().getFileExtension();
                    return ext != null && Arrays.asList(ResourceOnClasspathDialog.this.suffixs).contains(ext);
                }
                default: {
                    return false;
                }
            }
            int i = 0;
            while (i < children.length) {
                if (this.select(viewer, javaElement, children[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

