/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.commands;

import org.eclipse.gef.commands.Command;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.sectionparts.ISSESectionPart;
import org.w3c.dom.Node;

public abstract class BaseSectionPartCommand
extends Command {
    private IDOMNode node;
    private IStructuredModel sseModel;
    private ISSESectionPart sectionPart;
    boolean hasException = false;

    public BaseSectionPartCommand(String label, ISSESectionPart sectionPart) {
        super(label);
        this.sectionPart = sectionPart;
        if (this.sectionPart.getModel() instanceof IStructuredModel) {
            this.sseModel = (IStructuredModel)this.sectionPart.getModel();
        } else if (this.sectionPart.getModel() instanceof IDOMNode) {
            this.node = (IDOMNode)this.sectionPart.getModel();
            this.sseModel = this.node.getModel();
        }
    }

    public BaseSectionPartCommand(String label, IStructuredModel model) {
        super(label);
        this.sseModel = model;
    }

    public ISSESectionPart getSectionPart() {
        return this.sectionPart;
    }

    public IDOMNode getModel() {
        return this.node;
    }

    private IStructuredModel getSSEModel() {
        return this.sseModel;
    }

    public IDOMDocument getDocument() {
        return (IDOMDocument)this.node.getOwnerDocument();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void execute() {
        boolean ok = this.prePreExecute();
        if (!ok) return;
        try {
            try {
                this.preExecute();
                this.doExecute();
                this.postExecute();
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.postPostExecute();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.postPostExecute();
            return;
        }
    }

    protected void handleException(Exception ex) {
        ex.printStackTrace();
        this.hasException = true;
    }

    protected boolean prePreExecute() {
        if (this.getSSEModel() != null) {
            this.getSSEModel().beginRecording((Object)this, this.getLabel());
        }
        this.getSSEModel().aboutToChangeModel();
        return true;
    }

    protected void preExecute() {
    }

    protected abstract void doExecute();

    protected void postExecute() {
    }

    protected void postPostExecute() {
        this.getSSEModel().changedModel();
        this.getSSEModel().endRecording((Object)this);
        this.setSelection();
    }

    protected void setSelection() {
    }

    public void formatNode(Node node) {
    }

    public void redo() {
        this.getSSEModel().getUndoManager().redo();
    }

    public void undo() {
        this.getSSEModel().getUndoManager().undo();
    }
}

