/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.ClassButtonDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogFieldGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IDialogFieldApplyListener;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.LayoutUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StatusInfo;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.Attribute;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.AttributeRecorder;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.StructuredModelUtil;

public class EditAttributeGeneralGroup
extends DialogFieldGroup {
    private AttributeRecorder attributeRecorder;
    private StringDialogField attributeNameField;
    private ClassButtonDialogField attributeClassField;
    private StringDialogField defaultValueField;
    private StringDialogField suggestedValueField;
    private IProject currentProject;
    private static EditorResources resource = EditorResources.getInstance();

    public EditAttributeGeneralGroup(AttributeRecorder attributeRecorder) {
        this.attributeRecorder = attributeRecorder;
    }

    public void initialize() {
        this.attributeNameField = new StringDialogField();
        this.attributeNameField.setLabelText(resource.getString("ComponentsPage.AttributesSection.Wizard.Page.General.AttributeName"));
        this.attributeNameField.setText(this.attributeRecorder.getAttributeName());
        this.attributeNameField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        this.attributeNameField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                EditAttributeGeneralGroup.this.attributeRecorder.setAttributeName(EditAttributeGeneralGroup.this.attributeNameField.getText());
            }
        });
        this.attributeClassField = new ClassButtonDialogField(this.getProject());
        this.attributeClassField.setLabelText(resource.getString("ComponentsPage.AttributesSection.Wizard.Page.General.AttributeClass"));
        this.attributeClassField.setText(this.attributeRecorder.getAttributeClass());
        this.attributeClassField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        this.attributeClassField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                EditAttributeGeneralGroup.this.attributeRecorder.setAttributeClass(EditAttributeGeneralGroup.this.attributeClassField.getText());
            }
        });
        this.attributeClassField.setAutoOpenResource(false);
        this.defaultValueField = new StringDialogField();
        this.defaultValueField.setLabelText(resource.getString("ComponentsPage.AttributesSection.Wizard.Page.General.DefaultValue"));
        this.defaultValueField.setText(this.attributeRecorder.getDefaultValue());
        this.defaultValueField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        this.defaultValueField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                EditAttributeGeneralGroup.this.attributeRecorder.setDefaultValue(EditAttributeGeneralGroup.this.defaultValueField.getText());
            }
        });
        this.suggestedValueField = new StringDialogField();
        this.suggestedValueField.setLabelText(resource.getString("ComponentsPage.AttributesSection.Wizard.Page.General.SuggestedValue"));
        this.suggestedValueField.setText(this.attributeRecorder.getSuggestedValue());
        this.suggestedValueField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        this.suggestedValueField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                EditAttributeGeneralGroup.this.attributeRecorder.setSuggestedValue(EditAttributeGeneralGroup.this.suggestedValueField.getText());
            }
        });
    }

    protected IProject getProject() {
        IDOMNode node;
        Attribute attribute;
        if (this.currentProject == null && (attribute = this.attributeRecorder.getAttribute()) != null && (node = attribute.getNode()) != null) {
            this.currentProject = StructuredModelUtil.getProjectFor((IStructuredModel)node.getModel());
        }
        return this.currentProject;
    }

    public void setProject(IProject project) {
        this.currentProject = project;
        this.attributeClassField.setProject(project);
    }

    public void refreshData() {
    }

    public void layoutDialogFields(FormToolkit toolkit, Composite parent) {
        GridData data = new GridData(1808);
        parent.setLayoutData((Object)data);
        int numberOfColumns = 4;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        parent.setLayout((Layout)gl);
        this.attributeNameField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        this.attributeClassField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        this.defaultValueField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        this.defaultValueField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        this.suggestedValueField.doFillIntoGrid(toolkit, parent, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.attributeClassField.getTextControl(toolkit, parent));
    }

    public IStatus[] validateDialogFields() {
        StatusInfo nameStatus = new StatusInfo();
        StatusInfo classStatus = new StatusInfo();
        IStatus[] status = new IStatus[]{nameStatus, classStatus};
        if (this.attributeNameField.getText().length() == 0) {
            nameStatus.setError(resource.getString("ComponentsPage.AttributesSection.Wizard.Page.EditAttributeGeneralGroup.Error.NameEmpty"));
        }
        if (this.attributeClassField.getText().length() == 0) {
            classStatus.setError(resource.getString("ComponentsPage.AttributesSection.Wizard.Page.EditAttributeGeneralGroup.Error.ClassEmpty"));
        }
        return status;
    }
}

