/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sectionparts;

import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedBean;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.ISSESection;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.ManagedBeanInitializationSection;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.StructuredModelUtil;
import org.w3c.dom.Element;

public class BeanListEntriesAdapter
implements INodeAdapter {
    private ISSESection section;
    public static final String[] valueTags = new String[]{"value", "null-value"};
    static /* synthetic */ Class class$0;

    public BeanListEntriesAdapter(ISSESection section) {
        this.section = section;
    }

    public void hookIntoModel(Object model) {
        ((IDOMNode)model).addAdapter((INodeAdapter)this);
        ManagedBean bean = new ManagedBean((IDOMNode)model);
        IDOMNode nodeMapEntries = (IDOMNode)bean.getElement().getChildNode("list-entries");
        if (nodeMapEntries != null) {
            this.hookIntoListEntries(nodeMapEntries);
        }
    }

    public void unhookFromModel(Object model) {
        ((IDOMNode)model).removeAdapter((INodeAdapter)this);
        ManagedBean bean = new ManagedBean((IDOMNode)model);
        IDOMNode nodeMapEntries = (IDOMNode)bean.getElement().getChildNode("list-entries");
        if (nodeMapEntries != null) {
            this.unhookFromListEntries(nodeMapEntries);
        }
    }

    public void hookIntoListEntries(IDOMNode listEntries) {
        List listValues;
        if (listEntries == null) {
            return;
        }
        listEntries.addAdapter((INodeAdapter)this);
        NodeWrapUtil listEntriesWrap = new NodeWrapUtil(listEntries);
        IDOMNode valueClass = (IDOMNode)listEntriesWrap.getChildNode("value-class");
        if (valueClass != null) {
            valueClass.addAdapter((INodeAdapter)this);
        }
        if ((listValues = listEntriesWrap.getChildNodes(valueTags)) != null) {
            Iterator iter = listValues.iterator();
            while (iter.hasNext()) {
                this.hookIntoListEntry((IDOMNode)iter.next());
            }
        }
    }

    private void hookIntoListEntry(IDOMNode listEntry) {
        NodeWrapUtil listEntryWrap = new NodeWrapUtil(listEntry);
        IDOMNode valueNode = (IDOMNode)listEntryWrap.getChildNode("value");
        if (valueNode != null) {
            valueNode.addAdapter((INodeAdapter)this);
        }
    }

    private void unhookFromListEntries(IDOMNode listEntries) {
        List listValues;
        if (listEntries == null) {
            return;
        }
        listEntries.removeAdapter((INodeAdapter)this);
        NodeWrapUtil listEntriesWrap = new NodeWrapUtil(listEntries);
        IDOMNode valueClass = (IDOMNode)listEntriesWrap.getChildNode("value-class");
        if (valueClass != null) {
            valueClass.removeAdapter((INodeAdapter)this);
        }
        if ((listValues = listEntriesWrap.getChildNodes(valueTags)) != null) {
            Iterator iter = listValues.iterator();
            while (iter.hasNext()) {
                this.unhookFromListEntry((IDOMNode)iter.next());
            }
        }
    }

    private void unhookFromListEntry(IDOMNode listEntry) {
        listEntry.removeAdapter((INodeAdapter)this);
        NodeWrapUtil listEntryWrap = new NodeWrapUtil(listEntry);
        IDOMNode valueNode = (IDOMNode)listEntryWrap.getChildNode("value");
        if (valueNode != null) {
            valueNode.removeAdapter((INodeAdapter)this);
        }
    }

    public boolean isAdapterForType(Object type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wtp.jsf.facesconfig.editor.sectionparts.BeanListEntriesAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return type == clazz;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (eventType == 5 || eventType == 4) {
            if (notifier instanceof IDOMNode) {
                if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("list-entries")) {
                    this.processListEntriesChanged((IDOMNode)notifier);
                } else if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("value-class")) {
                    this.processValueClassChanged((IDOMNode)notifier);
                } else if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("value")) {
                    this.processValueChanged((IDOMNode)notifier);
                }
            }
        } else if (eventType == 3) {
            if (changedFeature instanceof IDOMNode) {
                if (((IDOMNode)changedFeature).getNodeName().equalsIgnoreCase("list-entries")) {
                    this.processRemoveListEntries((IDOMNode)notifier, (IDOMNode)changedFeature);
                } else if (((IDOMNode)changedFeature).getNodeName().equalsIgnoreCase("value-class")) {
                    this.processRemoveValueClass((IDOMNode)notifier, (IDOMNode)changedFeature);
                } else if (((IDOMNode)changedFeature).getNodeName().equalsIgnoreCase("value")) {
                    this.processRemoveValue((IDOMNode)notifier, (IDOMNode)changedFeature);
                } else if (((IDOMNode)changedFeature).getNodeName().equalsIgnoreCase("null-value")) {
                    this.processRemoveNullValue((IDOMNode)notifier, (IDOMNode)changedFeature);
                }
            }
        } else if (eventType == 2 && newValue instanceof IDOMNode) {
            if (((IDOMNode)newValue).getNodeName().equalsIgnoreCase("list-entries")) {
                this.processAddListEntries((IDOMNode)newValue);
            } else if (((IDOMNode)newValue).getNodeName().equalsIgnoreCase("value-class")) {
                this.processAddValueClass((IDOMNode)newValue);
            } else if (((IDOMNode)newValue).getNodeName().equalsIgnoreCase("value")) {
                this.processAddValue((IDOMNode)newValue);
            } else if (((IDOMNode)newValue).getNodeName().equalsIgnoreCase("null-value")) {
                this.processAddNullValue((IDOMNode)newValue);
            }
        }
    }

    private void processAddListEntries(IDOMNode node) {
        List listValues;
        if (!node.getParentNode().getNodeName().equalsIgnoreCase("managed-bean")) {
            return;
        }
        NodeWrapUtil managedBeanWrap = new NodeWrapUtil((IDOMNode)node.getParentNode());
        if (managedBeanWrap.getChildNodes("list-entries").size() > 1) {
            return;
        }
        node.addAdapter((INodeAdapter)this);
        NodeWrapUtil listEntriesWrap = new NodeWrapUtil(node);
        IDOMNode valueclassNode = (IDOMNode)listEntriesWrap.getChildNode("value-class");
        if (valueclassNode != null) {
            this.processAddValueClass(valueclassNode);
        }
        if ((listValues = listEntriesWrap.getChildNodes(valueTags)) != null) {
            Iterator iter = listValues.iterator();
            while (iter.hasNext()) {
                IDOMNode listValue = (IDOMNode)iter.next();
                if (listValue.getNodeName().equalsIgnoreCase("value")) {
                    this.processAddValue(listValue);
                    continue;
                }
                this.processAddNullValue(listValue);
            }
        }
    }

    private void processListEntriesChanged(IDOMNode node) {
    }

    private void processRemoveListEntries(IDOMNode parentNode, IDOMNode node) {
        if (parentNode.getNodeName().equalsIgnoreCase("managed-bean")) {
            node.removeAdapter((INodeAdapter)this);
            ((ManagedBeanInitializationSection)this.section).clearListEntries();
        }
    }

    private void processAddValueClass(IDOMNode node) {
        if (!node.getParentNode().getParentNode().getNodeName().equalsIgnoreCase("managed-bean")) {
            return;
        }
        node.addAdapter((INodeAdapter)this);
        ((ManagedBeanInitializationSection)this.section).updateListValueClass(StructuredModelUtil.getTextElementValue((Element)node));
    }

    private void processValueClassChanged(IDOMNode node) {
        if (!node.getParentNode().getParentNode().getNodeName().equalsIgnoreCase("managed-bean")) {
            return;
        }
        ((ManagedBeanInitializationSection)this.section).updateListValueClass(StructuredModelUtil.getTextElementValue((Element)node));
    }

    private void processRemoveValueClass(IDOMNode parentNode, IDOMNode node) {
        if (!parentNode.getParentNode().getNodeName().equalsIgnoreCase("managed-bean")) {
            return;
        }
        ((ManagedBeanInitializationSection)this.section).updateListValueClass("");
    }

    private void processListEntriesValueChanged(IDOMNode node) {
        NodeWrapUtil listEntriesWrap = new NodeWrapUtil(node);
        List listValues = listEntriesWrap.getChildNodes(valueTags);
        ((ManagedBeanInitializationSection)this.section).clearListEntriesValues();
        if (listValues != null) {
            Iterator iter = listValues.iterator();
            while (iter.hasNext()) {
                IDOMNode listValue = (IDOMNode)iter.next();
                ((ManagedBeanInitializationSection)this.section).addListEntry(listValue);
            }
        }
    }

    private void processAddValue(IDOMNode node) {
        if (!node.getParentNode().getParentNode().getNodeName().equalsIgnoreCase("managed-bean")) {
            return;
        }
        node.addAdapter((INodeAdapter)this);
        this.processListEntriesValueChanged((IDOMNode)node.getParentNode());
        ((ManagedBeanInitializationSection)this.section).updateListEntry(node);
    }

    private void processValueChanged(IDOMNode node) {
        if (!node.getParentNode().getParentNode().getNodeName().equalsIgnoreCase("managed-bean")) {
            return;
        }
        ((ManagedBeanInitializationSection)this.section).updateListEntry(node);
    }

    private void processRemoveValue(IDOMNode parentNode, IDOMNode node) {
        if (!parentNode.getParentNode().getNodeName().equalsIgnoreCase("managed-bean")) {
            return;
        }
        node.removeAdapter((INodeAdapter)this);
        ((ManagedBeanInitializationSection)this.section).removeListEntry(node);
    }

    private void processAddNullValue(IDOMNode node) {
        if (!node.getParentNode().getParentNode().getNodeName().equalsIgnoreCase("managed-bean")) {
            return;
        }
        node.addAdapter((INodeAdapter)this);
        this.processListEntriesValueChanged((IDOMNode)node.getParentNode());
        ((ManagedBeanInitializationSection)this.section).updateListEntry(node);
    }

    private void processRemoveNullValue(IDOMNode parentNode, IDOMNode node) {
        if (!parentNode.getParentNode().getNodeName().equalsIgnoreCase("managed-bean")) {
            return;
        }
        node.removeAdapter((INodeAdapter)this);
        ((ManagedBeanInitializationSection)this.section).removeListEntry(node);
    }
}

