/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sections;

import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.sse.ui.internal.view.events.INodeSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.NodeSelectionChangedEvent;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.AddElementCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.providers.ApplicationContentLabelProvider;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.ApplicationResources;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.OthersPageBaseSection;

public class ApplicationSection
extends OthersPageBaseSection {
    protected static ApplicationResources applicationResource = ApplicationResources.getInstance();
    private String childTagName;
    protected INodeSelectionListener fNodeSelectionListener;

    public ApplicationSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, IFormPage editor, String childTagName) {
        super(parent, managedForm, toolkit, applicationResource.getHelpContextID(childTagName), applicationResource.getHelpToolTip(childTagName), "application", childTagName);
        this.page = editor;
        this.childTagName = childTagName;
        this.setText(applicationResource.getSectionText(this.childTagName));
        this.setDescription(applicationResource.getSectionDescription(this.childTagName));
    }

    protected void addButtonSelected(SelectionEvent e) {
        AddElementCommand addCommand = new AddElementCommand(applicationResource.getAddCommandLabel(this.childTagName), this.getSectionPart(), "application", this.childTagName);
        addCommand.execute();
    }

    public INodeSelectionListener getNodeSelectionListener() {
        if (this.fNodeSelectionListener == null) {
            this.fNodeSelectionListener = new SSENodeSelectionListener();
        }
        return this.fNodeSelectionListener;
    }

    protected void setContentLabelProvider() {
        ApplicationContentLabelProvider provider = new ApplicationContentLabelProvider(this.childTagName);
        this.setContentProvider((IContentProvider)provider);
        this.setLabelProvider(provider);
    }

    class SSENodeSelectionListener
    implements INodeSelectionListener {
        SSENodeSelectionListener() {
        }

        public void nodeSelectionChanged(NodeSelectionChangedEvent event) {
        }
    }
}

