/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sections;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.FacesConfigEditor;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.AbstractOverviewSection;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.FacesConfigUtil;
import org.w3c.dom.DocumentType;

public class OverviewGeneralSection
extends AbstractOverviewSection {
    private static final String PUBLIC_ID = "-//Sun Microsystems, Inc.//DTD";
    private static final String VERSION_PREFIX = "JavaServer Faces Config";
    private static EditorResources resource = EditorResources.getInstance();
    private Text versionText;

    public OverviewGeneralSection(IManagedForm managedForm, FormToolkit toolkit, FormEditor editor) {
        super(editor, managedForm, toolkit, 194, resource.getString("OverviewPage.GeneralSection.Help.HelpContextID"), resource.getString("OverviewPage.GeneralSection.Help.HelpToolTip"));
        this.setText(resource.getString("OverviewPage.GeneralSection.name"));
        this.setDescription(resource.getString("OverviewPage.GeneralSection.description"));
    }

    public Composite createClient(Composite container, FormToolkit toolkit) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        IEditorInput editorInput = ((FacesConfigEditor)this.editor).getSourceEditorInput();
        toolkit.createLabel(container, resource.getString("OverviewPage.GeneralSection.label.name"));
        Text typeText = toolkit.createText(container, editorInput.getName());
        typeText.setEditable(false);
        GridData data = new GridData(768);
        typeText.setLayoutData((Object)data);
        toolkit.createLabel(container, resource.getString("OverviewPage.GeneralSection.label.version"));
        this.versionText = toolkit.createText(container, "");
        this.versionText.setLayoutData((Object)data);
        this.versionText.setEditable(false);
        data = new GridData(768);
        this.versionText.setLayoutData((Object)data);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        Label sep = toolkit.createSeparator(container, 256);
        sep.setLayoutData((Object)gd);
        toolkit.paintBordersFor(container);
        EditorPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)container, resource.getString("OverviewPage.GeneralSection.Help.HelpContextID"));
        return container;
    }

    public void refreshAll() {
        if (this.getInput() == null || !(this.getInput() instanceof IDOMModel)) {
            return;
        }
        String version = FacesConfigUtil.getFacesConfigVersion((IStructuredModel)((IDOMModel)this.getInput()));
        if (version == null) {
            IDOMDocument document = ((IDOMModel)this.getInput()).getDocument();
            DocumentType doctype = document.getDoctype();
            if (doctype != null) {
                String pid = doctype.getPublicId();
                version = pid.substring(PUBLIC_ID.length() + 1);
                version = version.substring(version.indexOf(VERSION_PREFIX) + VERSION_PREFIX.length() + 1, version.indexOf("//"));
            }
            if (version == null) {
                version = "";
            }
        }
        this.versionText.setText(version);
    }
}

