/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.sections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.view.events.INodeSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.NodeSelectionChangedEvent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.commands.AddValidatorCommand;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfig;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfigDocumentWrap;
import org.eclipse.wtp.jsf.facesconfig.editor.pages.ComponentsPage;
import org.eclipse.wtp.jsf.facesconfig.editor.pages.ISSEFormPage;
import org.eclipse.wtp.jsf.facesconfig.editor.providers.ValidatorsContentProvider;
import org.eclipse.wtp.jsf.facesconfig.editor.providers.ValidatorsLabelProvider;
import org.eclipse.wtp.jsf.facesconfig.editor.sections.AbstractSSESection;
import org.w3c.dom.Document;

public class ValidatorsSection
extends AbstractSSESection
implements ISelectionProvider,
ISelectionChangedListener {
    private static EditorResources resource = EditorResources.getInstance();
    private TableViewer tableViewer;
    private Button addButton;
    private Button removeButton;
    protected List selectionChangedListeners = new ArrayList();
    private IFormPage page;
    protected INodeSelectionListener fNodeSelectionListener;

    public ValidatorsSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, IFormPage editor) {
        super(parent, managedForm, toolkit, resource.getString("ComponentsPage.ValidatorsSection.HelpContextID"), resource.getString("ComponentsPage.ValidatorsSection.HelpToolTip"));
        this.setText(resource.getString("ComponentsPage.ValidatorsSection.Name"));
        this.setDescription(resource.getString("ComponentsPage.ValidatorsSection.Description"));
        this.page = editor;
    }

    public ValidatorsSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, int style, String helpContextId, String helpTooltip) {
        super(parent, managedForm, toolkit, style, helpContextId, helpTooltip);
    }

    public ValidatorsSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit, String helpContextId, String helpTooltip) {
        super(parent, managedForm, toolkit, helpContextId, helpTooltip);
    }

    public ValidatorsSection(Composite parent, IManagedForm managedForm, FormToolkit toolkit) {
        super(parent, managedForm, toolkit);
    }

    protected void createContents(Composite container, FormToolkit toolkit) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        this.createViewer(container, toolkit);
        this.createOperationSection(container, toolkit);
    }

    private void createOperationSection(Composite parent, FormToolkit toolkit) {
        Composite operationContainer = toolkit.createComposite(parent);
        GridData gd = new GridData(1040);
        operationContainer.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        operationContainer.setLayout((Layout)layout);
        this.addButton = toolkit.createButton(operationContainer, resource.getString("ComponentsPage.ValidatorsSection.Button.Add.Name"), 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.addButton.setLayoutData((Object)gd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ValidatorsSection.this.addButtonSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ValidatorsSection.this.addButtonSelected(e);
            }
        });
        this.removeButton = toolkit.createButton(operationContainer, resource.getString("ComponentsPage.ValidatorsSection.Button.Remove.Name"), 8);
        this.removeButton.setEnabled(true);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.removeButton.setLayoutData((Object)gd);
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ValidatorsSection.this.removeButtonSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ValidatorsSection.this.removeButtonSelected(e);
            }
        });
    }

    private void addButtonSelected(SelectionEvent e) {
        AddValidatorCommand addCommand = new AddValidatorCommand(resource.getString("ComponentsPage.ValidatorsSection.CommandLabel.AddValidator"), this.getSectionPart());
        addCommand.execute();
    }

    private void removeButtonSelected(SelectionEvent e) {
        GroupRequest deleteReq = new GroupRequest((Object)"delete");
        Command cmd = this.getSectionPart().getCommand((Request)deleteReq);
        if (cmd != null) {
            cmd.execute();
        }
    }

    private void createViewer(Composite parent, FormToolkit toolkit) {
        Composite tableContainer = toolkit.createComposite(parent);
        toolkit.paintBordersFor(tableContainer);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        tableContainer.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        tableContainer.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(tableContainer, 772);
        gd = new GridData(1808);
        this.tableViewer.getControl().setLayoutData((Object)gd);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ValidatorsLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ValidatorsContentProvider());
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        EditorPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)tableContainer, resource.getString("ComponentsPage.ValidatorsSection.HelpContextID"));
    }

    private void update() {
        IDOMModel model = (IDOMModel)((ISSEFormPage)this.getPage()).getModel();
        if (model != null) {
            IDOMDocument documentNode = model.getDocument();
            this.tableViewer.setInput((Object)documentNode);
        }
    }

    private void setViewInput(IStructuredModel model) {
        IDOMDocument document = ((IDOMModel)model).getDocument();
        FacesConfigDocumentWrap documentWrap = new FacesConfigDocumentWrap((Document)document);
        FacesConfig facesConfig = documentWrap.getFacesConfig();
        if (facesConfig != null) {
            this.tableViewer.setInput((Object)facesConfig.getNode());
            this.tableViewer.refresh();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.tableViewer.setSelection(selection);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Iterator listeners = this.selectionChangedListeners.iterator();
        while (listeners.hasNext()) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners.next();
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
        this.updateButtons();
    }

    public void clearAll() {
    }

    public void refreshTableViewer(final IDOMNode node, final boolean needRefreshAll) {
        this.getManagedForm().getForm().getDisplay().syncExec(new Runnable(){

            public void run() {
                if (needRefreshAll) {
                    ValidatorsSection.this.tableViewer.refresh();
                    if (node != null) {
                        ValidatorsSection.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)node));
                    } else {
                        Object selectedItem = ValidatorsSection.this.tableViewer.getElementAt(0);
                        if (selectedItem != null) {
                            ValidatorsSection.this.tableViewer.reveal(selectedItem);
                            ValidatorsSection.this.tableViewer.setSelection((ISelection)new StructuredSelection(selectedItem));
                        }
                    }
                } else if (node != null) {
                    ValidatorsSection.this.tableViewer.refresh((Object)node, true);
                }
            }
        });
        this.updateButtons();
    }

    public void refreshAll() {
        if (this.getInput() instanceof IStructuredModel) {
            this.setViewInput((IStructuredModel)this.getInput());
        }
        this.updateButtons();
    }

    public INodeSelectionListener getNodeSelectionListener() {
        if (this.fNodeSelectionListener == null) {
            this.fNodeSelectionListener = new SSENodeSelectionListener();
        }
        return this.fNodeSelectionListener;
    }

    public IWorkbenchPartSite getSite() {
        return this.page.getSite();
    }

    public IFormPage getPage() {
        return this.page;
    }

    private void updateButtons() {
        IStructuredSelection ssel = (IStructuredSelection)this.tableViewer.getSelection();
        this.removeButton.setEnabled(!ssel.isEmpty());
    }

    public void expansionStateChanged(boolean expanded) {
        if (expanded) {
            this.tableViewer.setSelection(this.tableViewer.getSelection());
        } else {
            this.tableViewer.setSelection(null);
        }
        super.expansionStateChanged(expanded);
    }

    public void expansionStateChanging(boolean expanding) {
        if (!expanding) {
            GridData gd = new GridData(768);
            this.getSection().setLayoutData((Object)gd);
        } else {
            ((ComponentsPage)this.page).closeOtherSections(this);
            GridData gd = new GridData(1808);
            this.getSection().setLayoutData((Object)gd);
        }
        super.expansionStateChanging(expanding);
    }

    private IDOMNode getComponentNode(IDOMNode xmlNode) {
        IDOMNode componentNode = null;
        if (xmlNode != null) {
            componentNode = xmlNode.getNodeName().equalsIgnoreCase("validator") ? xmlNode : this.getComponentNode((IDOMNode)xmlNode.getParentNode());
        }
        return componentNode;
    }

    class SSENodeSelectionListener
    implements INodeSelectionListener {
        SSENodeSelectionListener() {
        }

        public void nodeSelectionChanged(NodeSelectionChangedEvent event) {
            IDOMNode componentNode;
            if (event.getSource().equals(ValidatorsSection.this.tableViewer)) {
                return;
            }
            List selectedNodes = event.getSelectedNodes();
            if (selectedNodes != null && selectedNodes.size() > 0 && selectedNodes.get(0) instanceof IDOMNode && (componentNode = ValidatorsSection.this.getComponentNode((IDOMNode)selectedNodes.get(0))) != null && ValidatorsSection.this.tableViewer.getSelection() != null && !ValidatorsSection.this.tableViewer.getSelection().isEmpty() && ((StructuredSelection)ValidatorsSection.this.tableViewer.getSelection()).getFirstElement() != componentNode) {
                StructuredSelection selection = new StructuredSelection((Object)componentNode);
                ValidatorsSection.this.tableViewer.setSelection((ISelection)selection, true);
            }
        }
    }
}

