/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.webservice.wscommon.DescriptionType;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.FacesConfigEditor;
import org.eclipse.wtp.jsf.facesconfig.editor.common.logging.Logger;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.DisplayNameType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.FromActionType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.FromOutcomeType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.FromViewIdType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.IconType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.NavigationCaseType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.NavigationRuleType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.RedirectType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.navigationrule.ToViewIdType;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfig;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfigDocumentWrap;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedBean;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NavigationCase;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NavigationRule;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NodeWrapUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.ConfigurationManager;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.FacesConfigOrderHelper;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.JSPDomAdapter;
import org.w3c.dom.Document;

public class FacesConfigUtil {
    private static ConfigurationManager facesConfigManager;
    private static final Logger log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wtp.jsf.facesconfig.editor.utils.FacesConfigUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = EditorPlugin.getLogger(clazz);
    }

    private FacesConfigUtil() {
    }

    public static String getFacesConfigVersion(IStructuredModel sseModel) {
        FacesConfig facesConfig = FacesConfigUtil.getFacesConfig(sseModel);
        return ((IDOMElement)facesConfig.getElement().getNode()).getAttribute("version");
    }

    public static FacesConfig getFacesConfig(IStructuredModel sseModel) {
        if (sseModel == null) {
            return null;
        }
        FacesConfigDocumentWrap documentWrap = new FacesConfigDocumentWrap((Document)((IDOMModel)sseModel).getDocument());
        return documentWrap.getFacesConfig();
    }

    public static List getActionListInJSPFile(String jspFileName) {
        ArrayList actions = new ArrayList();
        JSPDomAdapter jspAdapter = new JSPDomAdapter();
        String physicalJspPath = jspFileName;
        if (physicalJspPath != null && physicalJspPath.length() > 0) {
            Path jspPath = new Path(physicalJspPath);
            IFile jspFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)jspPath);
            if (jspFile != null && jspFile.exists() && jspAdapter.initialize(jspFile)) {
                List linkActions;
                String prefix = jspAdapter.getTagLibPrefix(JSPDomAdapter.JSF_HTML_TAGLIB);
                List buttonActions = jspAdapter.getElementsByTagNameNS(prefix, "commandButton");
                if (buttonActions != null) {
                    actions.addAll(buttonActions);
                }
                if ((linkActions = jspAdapter.getElementsByTagNameNS(prefix, "commandLink")) != null) {
                    actions.addAll(linkActions);
                }
            }
        }
        jspAdapter.releaseModel();
        return actions;
    }

    public static boolean isExsitedBean(IProject project, String beanName) {
        List[] beanlist = FacesConfigUtil.getConfigurationManager(project).getManagedBeans();
        if (beanlist != null) {
            int x = 0;
            while (x < beanlist.length) {
                List beans = beanlist[x];
                Iterator i = beans.iterator();
                while (i.hasNext()) {
                    ManagedBean mbti;
                    String name;
                    Object o = i.next();
                    if (!(o instanceof ManagedBean) || !(name = (mbti = (ManagedBean)o).getManagedBeanName().trim()).equals(beanName)) continue;
                    return true;
                }
                ++x;
            }
        }
        return false;
    }

    public static String getUniqueName(ConfigurationManager manager, int xName, String beanName, String newName) {
        if (manager == null) {
            return null;
        }
        List[] beanlist = manager.getManagedBeans();
        int x = 0;
        while (x < beanlist.length) {
            List beans = beanlist[x];
            Iterator i = beans.iterator();
            while (i.hasNext()) {
                ManagedBean mbti;
                String name;
                Object o = i.next();
                if (!(o instanceof ManagedBean) || !(name = (mbti = (ManagedBean)o).getManagedBeanName().trim()).equals(newName)) continue;
                newName = String.valueOf(beanName) + ++xName;
                return FacesConfigUtil.getUniqueName(manager, xName, beanName, newName);
            }
            ++x;
        }
        return newName;
    }

    public static ConfigurationManager getConfigurationManager(IProject project) {
        if (facesConfigManager == null) {
            facesConfigManager = new ConfigurationManager(project);
        }
        facesConfigManager.loadConfiguration(project);
        facesConfigManager.deriveManagedBeans();
        return facesConfigManager;
    }

    public static void addXMLNavigationRuleFromEMFModel(IStructuredModel model, NavigationRuleType emfNavigationRule) {
        if (model == null || emfNavigationRule == null) {
            return;
        }
        FacesConfigDocumentWrap documentWrap = new FacesConfigDocumentWrap((Document)((IDOMModel)model).getDocument());
        NavigationRule xmlNavigationRule = documentWrap.getFacesConfig().createNavigationRule();
        Iterator iter = emfNavigationRule.getDisplayName().iterator();
        while (iter.hasNext()) {
            DisplayNameType displayName = (DisplayNameType)iter.next();
            xmlNavigationRule.getElement().createChildNode("display-name", false, displayName.getValue(), FacesConfigOrderHelper.getInstance());
        }
        iter = emfNavigationRule.getDescription().iterator();
        while (iter.hasNext()) {
            DescriptionType description = (DescriptionType)iter.next();
            xmlNavigationRule.getElement().createChildNode("description", false, description.getValue(), FacesConfigOrderHelper.getInstance());
        }
        iter = emfNavigationRule.getIcon().iterator();
        while (iter.hasNext()) {
            IconType icon = (IconType)iter.next();
            NodeWrapUtil iconWrap = new NodeWrapUtil(xmlNavigationRule.getElement().createChildNode("icon", true, null, FacesConfigOrderHelper.getInstance()));
            if (icon.getLargeIcon() != null) {
                iconWrap.createChildNode("large-icon", false, icon.getLargeIcon().getValue(), FacesConfigOrderHelper.getInstance());
            }
            if (icon.getSmallIcon() == null) continue;
            iconWrap.createChildNode("small-icon", false, icon.getSmallIcon().getValue(), FacesConfigOrderHelper.getInstance());
        }
        FromViewIdType fromViewId = emfNavigationRule.getFromViewId();
        if (fromViewId != null) {
            xmlNavigationRule.getElement().createChildNode("from-view-id", false, fromViewId.getValue(), FacesConfigOrderHelper.getInstance());
        }
        iter = emfNavigationRule.getNavigationCase().iterator();
        while (iter.hasNext()) {
            NavigationCaseType navigationCase = (NavigationCaseType)iter.next();
            IDOMNode navigationCaseNode = xmlNavigationRule.getElement().createChildNode("navigation-case", true, null, FacesConfigOrderHelper.getInstance());
            FacesConfigUtil.addNavigationCaseFromEMFModel(navigationCaseNode, navigationCase);
        }
    }

    private static void addNavigationCaseFromEMFModel(IDOMNode xmlNavigationCase, NavigationCaseType emfNavigationCase) {
        RedirectType redirect;
        ToViewIdType toViewId;
        FromOutcomeType fromOutcome;
        if (xmlNavigationCase == null || emfNavigationCase == null) {
            return;
        }
        NodeWrapUtil xmlNavigationCaseWrap = new NodeWrapUtil(xmlNavigationCase);
        Iterator iter = emfNavigationCase.getDisplayName().iterator();
        while (iter.hasNext()) {
            DisplayNameType displayName = (DisplayNameType)iter.next();
            xmlNavigationCaseWrap.createChildNode("display-name", false, displayName.getValue(), FacesConfigOrderHelper.getInstance());
        }
        iter = emfNavigationCase.getDescription().iterator();
        while (iter.hasNext()) {
            DescriptionType description = (DescriptionType)iter.next();
            xmlNavigationCaseWrap.createChildNode("description", false, description.getValue(), FacesConfigOrderHelper.getInstance());
        }
        iter = emfNavigationCase.getIcon().iterator();
        while (iter.hasNext()) {
            IconType icon = (IconType)iter.next();
            NodeWrapUtil iconWrap = new NodeWrapUtil(xmlNavigationCaseWrap.createChildNode("icon", true, null, FacesConfigOrderHelper.getInstance()));
            if (icon.getLargeIcon() != null) {
                iconWrap.createChildNode("large-icon", false, icon.getLargeIcon().getValue(), FacesConfigOrderHelper.getInstance());
            }
            if (icon.getSmallIcon() == null) continue;
            iconWrap.createChildNode("small-icon", false, icon.getSmallIcon().getValue(), FacesConfigOrderHelper.getInstance());
        }
        FromActionType fromAction = emfNavigationCase.getFromAction();
        if (fromAction != null) {
            xmlNavigationCaseWrap.createChildNode("from-action", false, fromAction.getValue(), FacesConfigOrderHelper.getInstance());
        }
        if ((fromOutcome = emfNavigationCase.getFromOutcome()) != null) {
            xmlNavigationCaseWrap.createChildNode("from-outcome", false, fromOutcome.getValue(), FacesConfigOrderHelper.getInstance());
        }
        if ((toViewId = emfNavigationCase.getToViewId()) != null) {
            xmlNavigationCaseWrap.createChildNode("to-view-id", false, toViewId.getValue(), FacesConfigOrderHelper.getInstance());
        }
        if ((redirect = emfNavigationCase.getRedirect()) != null) {
            xmlNavigationCaseWrap.createChildNode("redirect", true, null, FacesConfigOrderHelper.getInstance());
        }
    }

    private static boolean facesConfigContains(IFile facesConfigFile, String jspFileName) {
        if (!facesConfigFile.exists()) {
            log.info("FacesConfigUtil.FacesConfigFileNotExist", facesConfigFile.getName());
            return false;
        }
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        try {
            model = modelManager.getModelForRead(facesConfigFile);
        }
        catch (IOException e) {
            log.error("FacesConfigUtil.GetFacesConfigModelError", (Throwable)e);
            return false;
        }
        catch (CoreException e) {
            log.error("FacesConfigUtil.GetFacesConfigModelError", (Throwable)e);
            return false;
        }
        if (model == null) {
            return false;
        }
        IDOMDocument documentNode = ((IDOMModel)model).getDocument();
        FacesConfigDocumentWrap documentWrap = new FacesConfigDocumentWrap((Document)documentNode);
        FacesConfig facesConfig = documentWrap.getFacesConfig();
        List navigationList = facesConfig.getNavigationList();
        int i = 0;
        int n = navigationList.size();
        while (i < n) {
            NavigationRule navigationRole = (NavigationRule)navigationList.get(i);
            if (FacesConfigUtil.navigationRuleContains(navigationRole, jspFileName)) {
                model.releaseFromRead();
                return true;
            }
            ++i;
        }
        model.releaseFromRead();
        return false;
    }

    private static boolean navigationRuleContains(NavigationRule navigationRule, String jspFileName) {
        if (navigationRule == null) {
            return false;
        }
        String fromViewIDString = navigationRule.getFromViewId();
        if (fromViewIDString != null && fromViewIDString.indexOf(jspFileName) >= 0) {
            return true;
        }
        List navigationCaseList = navigationRule.getNavigationCaseList();
        int i = 0;
        int n = navigationCaseList.size();
        while (i < n) {
            NavigationCase navigationCase = (NavigationCase)navigationCaseList.get(i);
            if (FacesConfigUtil.navigationCaseContains(navigationCase, jspFileName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean navigationCaseContains(NavigationCase navigationCase, String jspFileName) {
        if (navigationCase == null) {
            return false;
        }
        String toViewIDString = navigationCase.getToViewId();
        return toViewIDString != null && toViewIDString.indexOf(jspFileName) >= 0;
    }

    private static void openFacesConfigFile(IFile facesConfigFile) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            FacesConfigEditor editor = (FacesConfigEditor)IDE.openEditor((IWorkbenchPage)page, (IFile)facesConfigFile, (String)"org.eclipse.wtp.jsf.facesconfig.editor.FacesConfigEditor", (boolean)false);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.wtp.jsf.facesconfig.editor.pageflow.PageflowEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            editor.setActiveEditorPage(clazz.getName());
        }
        catch (PartInitException e) {
            log.error("FacesConfigUtil.OpenFacesEditorError", (Throwable)e);
        }
    }
}

