/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.resolver;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.symbol.IMethodSymbol;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.resolver.AbstractSymbolContextResolver;

final class SymbolContextResolver
extends AbstractSymbolContextResolver {
    private final IStructuredDocumentContext _context;
    private IWorkspaceContextResolver _wkspResolver;

    SymbolContextResolver(IStructuredDocumentContext context) {
        this._context = context;
    }

    public ISymbol getVariable(String name) {
        DesignTimeApplicationManager manager;
        IFile file = this.getFile();
        if (file != null && (manager = DesignTimeApplicationManager.getInstance(file.getProject())) != null) {
            DTFacesContext facesContext = manager.getFacesContext(file);
            return manager.getVariableResolver().resolveVariable(facesContext, name, (IAdaptable)file);
        }
        return null;
    }

    public ISymbol[] getAllVariables() {
        DTFacesContext facesContext;
        DesignTimeApplicationManager manager;
        IFile file = this.getFile();
        if (file != null && (manager = DesignTimeApplicationManager.getInstance(file.getProject())) != null && (facesContext = manager.getFacesContext(file)) != null) {
            return manager.getVariableResolver().getAllVariables(facesContext, (IAdaptable)file);
        }
        return ISymbol.EMPTY_SYMBOL_ARRAY;
    }

    public ISymbol getProperty(ISymbol symbol, Object propertyName) {
        DesignTimeApplicationManager manager;
        IFile file = this.getFile();
        if (file != null && (manager = DesignTimeApplicationManager.getInstance(file.getProject())) != null) {
            return manager.getPropertyResolver().getProperty(symbol, propertyName);
        }
        return null;
    }

    public ISymbol[] getProperties(ISymbol symbol) {
        DesignTimeApplicationManager manager;
        IFile file = this.getFile();
        if (file != null && (manager = DesignTimeApplicationManager.getInstance(file.getProject())) != null) {
            return manager.getPropertyResolver().getAllProperties(symbol);
        }
        return ISymbol.EMPTY_SYMBOL_ARRAY;
    }

    public IMethodSymbol getMethod(IObjectSymbol base, Object methodName) {
        DesignTimeApplicationManager manager;
        IFile file = this.getFile();
        if (file != null && (manager = DesignTimeApplicationManager.getInstance(file.getProject())) != null) {
            return manager.getMethodResolver().getMethod(base, methodName);
        }
        return null;
    }

    public ISymbol[] getMethods(IObjectSymbol base) {
        DesignTimeApplicationManager manager;
        IFile file = this.getFile();
        if (file != null && (manager = DesignTimeApplicationManager.getInstance(file.getProject())) != null) {
            return manager.getMethodResolver().getMethods(base);
        }
        return new IMethodSymbol[0];
    }

    public boolean canResolveContext(IModelContext modelContext) {
        return modelContext.getAdapter(IStructuredDocumentContext.class) != null;
    }

    protected final IWorkspaceContextResolver getWorkspaceResolver() {
        if (this._wkspResolver == null) {
            this._wkspResolver = this.getWorkspaceResolver(this._context);
        }
        return this._wkspResolver;
    }

    private IWorkspaceContextResolver getWorkspaceResolver(IStructuredDocumentContext context) {
        return IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context);
    }

    protected final IFile getFile() {
        return this.getFile(this.getWorkspaceResolver());
    }

    private IFile getFile(IWorkspaceContextResolver resolver) {
        IResource curRes;
        if (resolver != null && (curRes = resolver.getResource()) instanceof IFile) {
            return (IFile)curRes;
        }
        return null;
    }

    public boolean hasSameResolution(IModelContext modelContext) {
        if (this.canResolveContext(modelContext)) {
            return this.getFile().equals((Object)this.getFile(this.getWorkspaceResolver((IStructuredDocumentContext)modelContext)));
        }
        return false;
    }
}

