/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.AddSourceFolderWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class CreateLinkedSourceFolderAction
extends BuildpathModifierAction {
    public CreateLinkedSourceFolderAction(IWorkbenchSite site) {
        this(site, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
    }

    public CreateLinkedSourceFolderAction(IRunnableContext context, ISetSelectionTarget selectionTarget) {
        this(null, selectionTarget, context);
    }

    private CreateLinkedSourceFolderAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget, IRunnableContext context) {
        super(site, selectionTarget, 5);
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Link_label);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Link_tooltip);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_ADD_LINKED_SOURCE_TO_BUILDPATH);
        this.setDescription(NewWizardMessages.PackageExplorerActionGroup_FormText_createLinkedFolder);
    }

    public String getDetailedDescription() {
        return NewWizardMessages.PackageExplorerActionGroup_FormText_createLinkedFolder;
    }

    public void run() {
        Shell shell = this.getShell();
        try {
            IJavaScriptProject javaProject = (IJavaScriptProject)this.getSelectedElements().get(0);
            CPListElement newEntrie = new CPListElement(javaProject, 3);
            CPListElement[] existing = CPListElement.createFromExisting(javaProject);
            boolean isProjectSrcFolder = CPListElement.isProjectSourceFolder(existing, javaProject);
            AddSourceFolderWizard wizard = new AddSourceFolderWizard(existing, newEntrie, this.getOutputLocation(javaProject), true, false, false, isProjectSrcFolder, isProjectSrcFolder);
            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)javaProject));
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            PixelConverter converter = new PixelConverter(JFaceResources.getDialogFont());
            dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
            dialog.create();
            int res = dialog.open();
            if (res == 0) {
                BuildpathDelta delta = new BuildpathDelta(this.getToolTipText());
                ArrayList newEntries = wizard.getExistingEntries();
                delta.setNewEntries(newEntries.toArray(new CPListElement[newEntries.size()]));
                IResource resource = wizard.getCreatedElement().getCorrespondingResource();
                delta.addCreatedResource(resource);
                delta.setDefaultOutputLocation(wizard.getOutputLocation());
                this.informListeners(delta);
                this.selectAndReveal((ISelection)new StructuredSelection((Object)wizard.getCreatedElement()));
            }
            this.notifyResult(res == 0);
        }
        catch (CoreException e) {
            String title = NewWizardMessages.AbstractOpenWizardAction_createerror_title;
            String message = NewWizardMessages.AbstractOpenWizardAction_createerror_message;
            ExceptionHandler.handle(e, shell, title, message);
        }
    }

    private IPath getOutputLocation(IJavaScriptProject javaProject) {
        try {
            return javaProject.getOutputLocation();
        }
        catch (CoreException coreException) {
            IProject project = javaProject.getProject();
            IPath projPath = project.getFullPath();
            return projPath.append(PreferenceConstants.getPreferenceStore().getString("org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersBinName"));
        }
    }

    protected boolean canHandle(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        return selection.getFirstElement() instanceof IJavaScriptProject;
    }
}

