/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.ui.navigator.JavaNavigatorContentProvider;

public class ScriptExplorerContentProvider
extends JavaNavigatorContentProvider {
    private WorkbenchContentProvider fResourceProvider = new WorkbenchContentProvider();
    private RefreshListener fRefreshListener = new RefreshListener();

    public ScriptExplorerContentProvider(boolean provideMembers) {
        super(provideMembers);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fRefreshListener, 1);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fRefreshListener);
        super.dispose();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IResource) {
            switch (((IResource)parentElement).getType()) {
                case 1: 
                case 4: {
                    return ScriptExplorerContentProvider.concatenate(super.getChildren(parentElement), this.fResourceProvider.getChildren(parentElement));
                }
                case 2: {
                    return this.fResourceProvider.getChildren(parentElement);
                }
            }
        }
        return super.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return this.fResourceProvider.getParent(element);
        }
        return super.getParent(element);
    }

    class RefreshListener
    implements IResourceDeltaVisitor,
    IResourceChangeListener {
        private List refreshQueue = new ArrayList();

        RefreshListener() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void resourceChanged(IResourceChangeEvent event) {
            if (!ScriptExplorerContentProvider.this.getProvideMembers()) return;
            try {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)ScriptExplorerContentProvider.this.fRefreshListener);
                    if (!this.refreshQueue.isEmpty()) {
                        ArrayList runnables = new ArrayList();
                        ScriptExplorerContentProvider.this.postRefresh(this.refreshQueue, false, runnables);
                        ScriptExplorerContentProvider.this.executeRunnables(runnables);
                    }
                }
                catch (CoreException coreException) {}
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.refreshQueue.clear();
                throw throwable;
            }
            {
                Object var3_5 = null;
                this.refreshQueue.clear();
                return;
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource;
            if ((delta.getFlags() & 0x100) != 0 && (resource = delta.getResource()).getType() == 1 && JavaScriptCore.isJavaScriptLikeFileName((String)resource.getName())) {
                this.refreshQueue.add(resource);
            }
            return true;
        }
    }
}

