/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.ui.text.SmartBackspaceManager;
import org.eclipse.wst.jsdt.internal.ui.text.comment.CommentFormattingContext;
import org.eclipse.wst.jsdt.ui.text.JavaScriptSourceViewerConfiguration;

public class JavaSourceViewer
extends ProjectionViewer
implements IPropertyChangeListener {
    public static final int SHOW_OUTLINE = 51;
    public static final int OPEN_STRUCTURE = 52;
    public static final int SHOW_HIERARCHY = 53;
    private IInformationPresenter fOutlinePresenter;
    private IInformationPresenter fStructurePresenter;
    private IInformationPresenter fHierarchyPresenter;
    private Color fForegroundColor;
    private Color fBackgroundColor;
    private Color fSelectionForegroundColor;
    private Color fSelectionBackgroundColor;
    private IPreferenceStore fPreferenceStore;
    private boolean fIsConfigured;
    private SmartBackspaceManager fBackspaceManager;
    private boolean fIsSetVisibleDocumentDelayed = false;

    public JavaSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, IPreferenceStore store) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        this.setPreferenceStore(store);
    }

    public IFormattingContext createFormattingContext() {
        CommentFormattingContext context = new CommentFormattingContext();
        HashMap map = new HashMap(JavaScriptCore.getOptions());
        context.setProperty("formatting.context.preferences", map);
        return context;
    }

    public void doOperation(int operation) {
        if (this.getTextWidget() == null) {
            return;
        }
        switch (operation) {
            case 51: {
                if (this.fOutlinePresenter != null) {
                    this.fOutlinePresenter.showInformation();
                }
                return;
            }
            case 52: {
                if (this.fStructurePresenter != null) {
                    this.fStructurePresenter.showInformation();
                }
                return;
            }
            case 53: {
                if (this.fHierarchyPresenter != null) {
                    this.fHierarchyPresenter.showInformation();
                }
                return;
            }
        }
        super.doOperation(operation);
    }

    public boolean canDoOperation(int operation) {
        if (operation == 51) {
            return this.fOutlinePresenter != null;
        }
        if (operation == 52) {
            return this.fStructurePresenter != null;
        }
        if (operation == 53) {
            return this.fHierarchyPresenter != null;
        }
        return super.canDoOperation(operation);
    }

    public void configure(SourceViewerConfiguration configuration) {
        StyledText textWidget = this.getTextWidget();
        if (textWidget != null && !textWidget.isDisposed()) {
            Color backgroundColor;
            Color foregroundColor = textWidget.getForeground();
            if (foregroundColor != null && foregroundColor.isDisposed()) {
                textWidget.setForeground(null);
            }
            if ((backgroundColor = textWidget.getBackground()) != null && backgroundColor.isDisposed()) {
                textWidget.setBackground(null);
            }
        }
        super.configure(configuration);
        if (configuration instanceof JavaScriptSourceViewerConfiguration) {
            JavaScriptSourceViewerConfiguration javaSVCconfiguration = (JavaScriptSourceViewerConfiguration)configuration;
            this.fOutlinePresenter = javaSVCconfiguration.getOutlinePresenter((ISourceViewer)this, false);
            if (this.fOutlinePresenter != null) {
                this.fOutlinePresenter.install((ITextViewer)this);
            }
            this.fStructurePresenter = javaSVCconfiguration.getOutlinePresenter((ISourceViewer)this, true);
            if (this.fStructurePresenter != null) {
                this.fStructurePresenter.install((ITextViewer)this);
            }
            this.fHierarchyPresenter = javaSVCconfiguration.getHierarchyPresenter((ISourceViewer)this, true);
            if (this.fHierarchyPresenter != null) {
                this.fHierarchyPresenter.install((ITextViewer)this);
            }
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
            this.initializeViewerColors();
        }
        this.fIsConfigured = true;
    }

    protected void initializeViewerColors() {
        if (this.fPreferenceStore != null) {
            StyledText styledText = this.getTextWidget();
            Color color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Foreground", styledText.getDisplay());
            styledText.setForeground(color);
            if (this.fForegroundColor != null) {
                this.fForegroundColor.dispose();
            }
            this.fForegroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            styledText.setBackground(color);
            if (this.fBackgroundColor != null) {
                this.fBackgroundColor.dispose();
            }
            this.fBackgroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.SelectionForeground", styledText.getDisplay());
            styledText.setSelectionForeground(color);
            if (this.fSelectionForegroundColor != null) {
                this.fSelectionForegroundColor.dispose();
            }
            this.fSelectionForegroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.SelectionBackground", styledText.getDisplay());
            styledText.setSelectionBackground(color);
            if (this.fSelectionBackgroundColor != null) {
                this.fSelectionBackgroundColor.dispose();
            }
            this.fSelectionBackgroundColor = color;
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    public void unconfigure() {
        if (this.fOutlinePresenter != null) {
            this.fOutlinePresenter.uninstall();
            this.fOutlinePresenter = null;
        }
        if (this.fStructurePresenter != null) {
            this.fStructurePresenter.uninstall();
            this.fStructurePresenter = null;
        }
        if (this.fHierarchyPresenter != null) {
            this.fHierarchyPresenter.uninstall();
            this.fHierarchyPresenter = null;
        }
        if (this.fForegroundColor != null) {
            this.fForegroundColor.dispose();
            this.fForegroundColor = null;
        }
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
            this.fBackgroundColor = null;
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        super.unconfigure();
        this.fIsConfigured = false;
    }

    public Point rememberSelection() {
        return super.rememberSelection();
    }

    public void restoreSelection() {
        super.restoreSelection();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("AbstractTextEditor.Color.Foreground".equals(property) || "AbstractTextEditor.Color.Foreground.SystemDefault".equals(property) || "AbstractTextEditor.Color.Background".equals(property) || "AbstractTextEditor.Color.Background.SystemDefault".equals(property) || "AbstractTextEditor.Color.SelectionForeground".equals(property) || "AbstractTextEditor.Color.SelectionForeground.SystemDefault".equals(property) || "AbstractTextEditor.Color.SelectionBackground".equals(property) || "AbstractTextEditor.Color.SelectionBackground.SystemDefault".equals(property)) {
            this.initializeViewerColors();
        }
    }

    public void setPreferenceStore(IPreferenceStore store) {
        if (this.fIsConfigured && this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.fPreferenceStore = store;
        if (this.fIsConfigured && this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
            this.initializeViewerColors();
        }
    }

    public void resetVisibleRegion() {
        super.resetVisibleRegion();
        if (this.fPreferenceStore != null && this.fPreferenceStore.getBoolean("editor_folding_enabled") && !this.isProjectionMode()) {
            this.enableProjection();
        }
    }

    protected void createControl(Composite parent, int styles) {
        if ((styles & 0x4000000) == 0 && (styles & 0x2000000) == 0) {
            styles |= 0x2000000;
        }
        super.createControl(parent, styles);
        this.fBackspaceManager = new SmartBackspaceManager();
        this.fBackspaceManager.install((ITextViewer)this);
        StyledText text = this.getTextWidget();
        text.addBidiSegmentListener(new BidiSegmentListener(){

            public void lineGetSegments(BidiSegmentEvent event) {
                if (JavaSourceViewer.this.redraws()) {
                    event.segments = JavaSourceViewer.this.getBidiLineSegments(event.lineOffset, event.lineText);
                }
            }
        });
    }

    public SmartBackspaceManager getBackspaceManager() {
        return this.fBackspaceManager;
    }

    protected void handleDispose() {
        if (this.fBackspaceManager != null) {
            this.fBackspaceManager.uninstall();
            this.fBackspaceManager = null;
        }
        super.handleDispose();
    }

    public void prependTextPresentationListener(ITextPresentationListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fTextPresentationListeners == null) {
            this.fTextPresentationListeners = new ArrayList();
        }
        this.fTextPresentationListeners.remove(listener);
        this.fTextPresentationListeners.add(0, listener);
    }

    void setReconciler(IReconciler reconciler) {
        this.fReconciler = reconciler;
    }

    IReconciler getReconciler() {
        return this.fReconciler;
    }

    protected int[] getBidiLineSegments(int widgetLineOffset, String line) {
        if (line != null && line.length() > 0) {
            int lineOffset = this.widgetOffset2ModelOffset(widgetLineOffset);
            try {
                return JavaSourceViewer.getBidiLineSegments(this.getDocument(), lineOffset);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return null;
    }

    protected static int[] getBidiLineSegments(IDocument document, int lineOffset) throws BadLocationException {
        if (document == null) {
            return null;
        }
        IRegion line = document.getLineInformationOfOffset(lineOffset);
        ITypedRegion[] linePartitioning = TextUtilities.computePartitioning((IDocument)document, (String)"___java_partitioning", (int)lineOffset, (int)line.getLength(), (boolean)false);
        ArrayList<ITypedRegion> segmentation = new ArrayList<ITypedRegion>();
        int i = 0;
        while (i < linePartitioning.length) {
            if ("__java_string".equals(linePartitioning[i].getType())) {
                segmentation.add(linePartitioning[i]);
            }
            ++i;
        }
        if (segmentation.size() == 0) {
            return null;
        }
        int size = segmentation.size();
        int[] segments = new int[size * 2 + 1];
        int j = 0;
        int i2 = 0;
        while (i2 < size) {
            int offset;
            ITypedRegion segment = (ITypedRegion)segmentation.get(i2);
            if (i2 == 0) {
                segments[j++] = 0;
            }
            if ((offset = segment.getOffset() - lineOffset) > segments[j - 1]) {
                segments[j++] = offset;
            }
            if (offset + segment.getLength() >= line.getLength()) break;
            segments[j++] = offset + segment.getLength();
            ++i2;
        }
        if (j < segments.length) {
            int[] result = new int[j];
            System.arraycopy(segments, 0, result, 0, j);
            segments = result;
        }
        return segments;
    }

    void prepareDelayedProjection() {
        Assert.isTrue((!this.fIsSetVisibleDocumentDelayed ? 1 : 0) != 0);
        this.fIsSetVisibleDocumentDelayed = true;
    }

    protected void setVisibleDocument(IDocument document) {
        if (this.fIsSetVisibleDocumentDelayed) {
            this.fIsSetVisibleDocumentDelayed = false;
            IDocument previous = this.getVisibleDocument();
            this.enableProjection();
            IDocument current = this.getVisibleDocument();
            if (current != null && current != previous) {
                return;
            }
        }
        super.setVisibleDocument(document);
    }

    protected StyleRange modelStyleRange2WidgetStyleRange(StyleRange range) {
        IRegion region = this.modelRange2WidgetRange((IRegion)new Region(range.start, range.length));
        if (region != null) {
            range.start = region.getOffset();
            range.length = region.getLength();
            return range;
        }
        return null;
    }
}

