/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test;

import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.common.Filter;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.jst.ws.internal.consumption.common.FolderResourceFilter;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.common.LabelsAndIds;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestExtension;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestRegistry;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.jst.ws.internal.ui.dialog.DialogUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.selection.BooleanSelection;
import org.eclipse.wst.command.internal.env.core.selection.SelectionList;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;

public class ClientTestWidget
extends SimpleWidgetDataContributor {
    private String pluginId_ = "org.eclipse.jst.ws.consumption.ui";
    private String INFOPOP_PWSM_PAGE = "PWSM0001";
    private Button testCheckbox_;
    private String INFOPOP_PWSM_CHECKBOX_TEST = "PWSM0002";
    private Combo testTypeCombo_;
    private String INFOPOP_PWSM_COMBOBOX_TEST = "PWSM0003";
    private Combo runtimesCombo;
    private String INFOPOP_PWSM_COMBOBOX_SERVER = "PWSM0004";
    private Combo serverInstanceTypeCombo_;
    private String INFOPOP_PWSM_COMBOBOX_SERVER_INSTANCE = "PWSM0005";
    private Text jspFolderText_;
    private String INFOPOP_PWSM_TEXT_JSP_FOLDER = "PWSM0008";
    private Button sampleFolderBrowseButton_;
    private String INFOPOP_PWSM_BUTTON_JSP_FOLDER_BROWSE = "PWSM0009";
    private Text projectCombo_;
    private String INFOPOP_PWSM_COMBO_PROJECT = "PWSM0010";
    private Tree methodsTree_;
    private Button selectAllMethodsButton_;
    private String INFOPOP_PWSM_BUTTON_SELECT_ALL = "PWSM0006";
    private Button deselectAllMethodsButton_;
    private String INFOPOP_PWSM_BUTTON_DESELECT_ALL = "PWSM0007";
    private Text sampleFolderText_;
    private String INFOPOP_PWSM_TEXT_SAMPLE_FOLDER = "PWSM0014";
    private Button runTestCheckbox_;
    private String INFOPOP_PWSM_CHECKBOX_LAUNCH = "PWSM0015";
    private Text earCombo_;
    private String INFOPOP_PWSM_EAR_COMBO = "PWSM0016";
    private Composite comboGroup_;
    private SelectionList testFacilities_;
    private FolderResourceFilter folderFilter_ = new FolderResourceFilter();
    private IStructuredSelection initialSelection_;
    private boolean isTestWidget = false;
    private boolean isPopup = false;
    private boolean isWebProject = false;
    private LabelsAndIds runtimes_;
    private LabelsAndIds serverInstances_;
    private IPath webContentPath_;
    private IResource webContent_;
    private boolean canRunTestClient_;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        this.isTestWidget = true;
        UIUtils uiUtils = new UIUtils(this.pluginId_);
        parent.setToolTipText(ConsumptionUIMessages.TOOLTIP_PWSM_PAGE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(this.pluginId_) + "." + this.INFOPOP_PWSM_PAGE);
        this.testCheckbox_ = uiUtils.createCheckbox(parent, ConsumptionUIMessages.BUTTON_TEST, ConsumptionUIMessages.TOOLTIP_PWSM_CHECKBOX_TEST, this.INFOPOP_PWSM_CHECKBOX_TEST);
        this.testCheckbox_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ClientTestWidget.this.handleTestButton();
            }
        });
        this.comboGroup_ = uiUtils.createComposite(parent, 3, 5, 0);
        this.testTypeCombo_ = uiUtils.createCombo(this.comboGroup_, ConsumptionUIMessages.LABEL_TEST_TYPES, ConsumptionUIMessages.TOOLTIP_PWSM_COMBOBOX_TEST, this.INFOPOP_PWSM_COMBOBOX_TEST, 2060);
        this.testTypeCombo_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClientTestWidget.this.handleTestFacilitySelection();
            }
        });
        new Label(this.comboGroup_, 0);
        this.projectCombo_ = uiUtils.createText(this.comboGroup_, ConsumptionUIMessages.LABEL_JSP_PROJECT_NAME, ConsumptionUIMessages.TOOLTIP_PWSM_COMBO_PROJECT, this.INFOPOP_PWSM_COMBO_PROJECT, 2060);
        new Label(this.comboGroup_, 0);
        this.earCombo_ = uiUtils.createText(this.comboGroup_, ConsumptionUIMessages.LABEL_EAR_PROJECTS, ConsumptionUIMessages.TOOLTIP_PWSM_EAR_PROJECT, this.INFOPOP_PWSM_EAR_COMBO, 2060);
        new Label(this.comboGroup_, 0);
        this.sampleFolderText_ = uiUtils.createText(this.comboGroup_, ConsumptionUIMessages.LABEL_FOLDER_NAME, ConsumptionUIMessages.TOOLTIP_PWSM_TEXT_SAMPLE_FOLDER, this.INFOPOP_PWSM_TEXT_SAMPLE_FOLDER, 2052);
        this.sampleFolderText_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ClientTestWidget.this.handleFolderText();
            }
        });
        this.sampleFolderBrowseButton_ = uiUtils.createPushButton(this.comboGroup_, ConsumptionUIMessages.BUTTON_BROWSE, ConsumptionUIMessages.TOOLTIP_PWSM_BUTTON_JSP_FOLDER_BROWSE, this.INFOPOP_PWSM_BUTTON_JSP_FOLDER_BROWSE);
        this.sampleFolderBrowseButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ClientTestWidget.this.handleSampleBrowse();
            }
        });
        this.jspFolderText_ = uiUtils.createText(this.comboGroup_, ConsumptionUIMessages.LABEL_JSP_FOLDER_NAME, ConsumptionUIMessages.TOOLTIP_PWSM_TEXT_JSP_FOLDER, this.INFOPOP_PWSM_TEXT_JSP_FOLDER, 2060);
        new Label(this.comboGroup_, 0);
        Group methodsGroup = uiUtils.createGroup(parent, ConsumptionUIMessages.LABEL_METHODS, ConsumptionUIMessages.TOOLTIP_PWSM_TREE_METHODS, null);
        methodsGroup.setLayoutData((Object)uiUtils.createFillAll());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        methodsGroup.setLayout((Layout)layout);
        this.methodsTree_ = uiUtils.createTree((Composite)methodsGroup, ConsumptionUIMessages.TOOLTIP_PWSM_TREE_METHODS, null, 2850);
        Composite selectButtons = uiUtils.createComposite((Composite)methodsGroup, 2);
        this.selectAllMethodsButton_ = uiUtils.createPushButton(selectButtons, ConsumptionUIMessages.BUTTON_SELECT_ALL, ConsumptionUIMessages.TOOLTIP_PWSM_BUTTON_SELECT_ALL, this.INFOPOP_PWSM_BUTTON_SELECT_ALL);
        this.selectAllMethodsButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ClientTestWidget.this.handleSelectAll(true);
            }
        });
        this.deselectAllMethodsButton_ = uiUtils.createPushButton(selectButtons, ConsumptionUIMessages.BUTTON_DESELECT_ALL, ConsumptionUIMessages.TOOLTIP_PWSM_BUTTON_DESELECT_ALL, this.INFOPOP_PWSM_BUTTON_DESELECT_ALL);
        this.deselectAllMethodsButton_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ClientTestWidget.this.handleSelectAll(false);
            }
        });
        this.runTestCheckbox_ = uiUtils.createCheckbox(parent, ConsumptionUIMessages.BUTTON_RUN_TEST, ConsumptionUIMessages.TOOLTIP_PWSM_CHECKBOX_LAUNCH, this.INFOPOP_PWSM_CHECKBOX_LAUNCH);
        this.runTestCheckbox_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ClientTestWidget.this.handleRunTestCheckBox();
            }
        });
        return this;
    }

    private void handleRunTestCheckBox() {
        boolean enabled = this.runTestCheckbox_.getSelection();
        this.runtimesCombo.setEnabled(enabled);
        this.serverInstanceTypeCombo_.setEnabled(enabled);
    }

    private void handleFolderText() {
        if (this.webContentPath_ == null) {
            return;
        }
        String folder = this.sampleFolderText_.getText();
        this.jspFolderText_.setText(String.valueOf(this.webContentPath_.toString()) + '/' + folder);
    }

    private void handleSampleBrowse() {
        IResource resource;
        IPath selectedPath = null;
        IResource initialResource = null;
        try {
            initialResource = ResourceUtils.getResourceFromSelection((Object)this.initialSelection_);
        }
        catch (CoreException coreException) {}
        if (initialResource == null) {
            initialResource = this.webContent_;
        }
        if ((resource = DialogUtils.browseResources((Shell)this.comboGroup_.getShell(), (IResource)this.webContent_, (IResource)initialResource, (Filter)this.folderFilter_)) != null) {
            selectedPath = resource.getFullPath();
            int webModuleSegments = selectedPath.matchingFirstSegments(this.webContentPath_);
            if (webModuleSegments < this.webContentPath_.segmentCount()) {
                this.sampleFolderText_.setText("");
                this.handleFolderText();
            } else {
                this.sampleFolderText_.setText(selectedPath.removeFirstSegments(webModuleSegments).toString());
                this.handleFolderText();
            }
        }
    }

    private void handleTestButton() {
        boolean enabled = this.testCheckbox_.getSelection();
        this.testTypeCombo_.setEnabled(enabled);
        if (enabled && this.testFacilities_ != null) {
            this.handleTestFacilitySelection();
            return;
        }
        this.sampleFolderText_.setEnabled(enabled);
        this.methodsTree_.setEnabled(enabled);
        if (this.canRunTestClient_) {
            this.runTestCheckbox_.setEnabled(enabled);
        }
        this.selectAllMethodsButton_.setEnabled(enabled);
        this.deselectAllMethodsButton_.setEnabled(enabled);
        this.sampleFolderBrowseButton_.setEnabled(enabled);
    }

    private void handleTestFacilitySelection() {
        String clientTestID = this.getTestFacility().getSelection();
        WebServiceTestExtension testExtension = (WebServiceTestExtension)WebServiceTestRegistry.getInstance().getWebServiceExtensionsByName(clientTestID);
        boolean hasCodeGen = testExtension.isCodeGenNeeded();
        this.sampleFolderText_.setEnabled(hasCodeGen);
        this.sampleFolderBrowseButton_.setEnabled(hasCodeGen && this.webContent_ != null);
        boolean hasMethods = testExtension.areMethodsNeeded();
        this.methodsTree_.setEnabled(hasMethods);
        this.selectAllMethodsButton_.setEnabled(hasMethods);
        this.deselectAllMethodsButton_.setEnabled(hasMethods);
        if (this.canRunTestClient_) {
            this.runTestCheckbox_.setEnabled(testExtension.isServerNeeded());
        }
    }

    private void handleSelectAll(boolean value) {
        TreeItem[] items = this.methodsTree_.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setChecked(value);
            ++i;
        }
    }

    private void handleServerChange() {
        int selection = this.runtimesCombo.getSelectionIndex();
        this.serverInstances_.clear();
        this.serverInstanceTypeCombo_.removeAll();
        IServer[] servers = ServerCore.getServers();
        int j = 0;
        while (j < servers.length) {
            String id = this.runtimes_.getId(selection);
            if (id.equals(servers[j].getRuntime().getId())) {
                this.serverInstances_.add(servers[j].getId(), servers[j].getName());
                this.serverInstanceTypeCombo_.add(servers[j].getName());
            }
            ++j;
        }
        this.serverInstanceTypeCombo_.select(0);
    }

    public void setTestService(Boolean testService) {
        this.testCheckbox_.setSelection(testService.booleanValue());
        this.handleTestButton();
    }

    public Boolean getTestService() {
        return new Boolean(this.testCheckbox_.getSelection());
    }

    public void setTestFacility(SelectionList testFacilities) {
        this.testFacilities_ = testFacilities;
        this.testTypeCombo_.setItems(testFacilities.getList());
        this.testTypeCombo_.select(testFacilities.getIndex());
        this.handleTestFacilitySelection();
    }

    public SelectionList getTestFacility() {
        this.testFacilities_.setIndex(this.testTypeCombo_.getSelectionIndex());
        return this.testFacilities_;
    }

    public String getTestID() {
        return this.testTypeCombo_.getText();
    }

    private String extractProjectName(String project) {
        int index = project.indexOf("/");
        if (index != -1) {
            project = project.substring(0, index);
        }
        return project;
    }

    public void initServersTypes() {
        String id;
        if (this.runtimes_ == null) {
            this.runtimes_ = new LabelsAndIds();
        }
        IServer[] servers = ServerCore.getServers();
        IRuntime[] runtimes = ServerCore.getRuntimes();
        ServerCore.getServerTypes();
        String projectName = this.projectCombo_.getText();
        Set projectFacets = FacetUtils.getFacetsForProject((String)projectName);
        int i = 0;
        while (i < runtimes.length) {
            boolean showServer = false;
            if (runtimes[i].isStub()) {
                int l = 0;
                while (l < servers.length) {
                    if (servers[l].getRuntime() != null && runtimes[i].getId().equals(servers[l].getRuntime().getId())) {
                        showServer = true;
                    }
                    ++l;
                }
            } else {
                showServer = true;
            }
            if (showServer && this.canRunTestClient_) {
                if (this.isWebProject) {
                    org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = FacetUtil.getRuntime((IRuntime)runtimes[i]);
                    if (FacetUtils.doesRuntimeSupportFacets((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime, (Set)projectFacets)) {
                        this.runtimes_.add(runtimes[i].getId(), runtimes[i].getName());
                        this.runtimesCombo.add(runtimes[i].getName());
                    }
                } else {
                    this.runtimes_.add(runtimes[i].getId(), runtimes[i].getName());
                    this.runtimesCombo.add(runtimes[i].getName());
                }
            }
            ++i;
        }
        this.runtimesCombo.select(0);
        if (this.serverInstances_ == null) {
            this.serverInstances_ = new LabelsAndIds();
        }
        if ((id = this.runtimes_.getId(0)) != null) {
            int k = 0;
            while (k < servers.length) {
                if (servers[k].getRuntime() != null && id.equals(servers[k].getRuntime().getId()) && this.canRunTestClient_) {
                    this.serverInstances_.add(servers[k].getId(), servers[k].getName());
                    this.serverInstanceTypeCombo_.add(servers[k].getName());
                }
                ++k;
            }
            this.serverInstanceTypeCombo_.select(0);
        }
        this.serverInstanceTypeCombo_.setEnabled(this.canRunTestClient_ && this.runTestCheckbox_.getSelection());
        this.runtimesCombo.setEnabled(this.canRunTestClient_ && this.runTestCheckbox_.getSelection());
    }

    public void setSampleProject(String clientProject) {
        this.projectCombo_.setText(this.extractProjectName(clientProject));
    }

    public void setSampleProjectEAR(String clientProjectEAR) {
        this.earCombo_.setText(this.extractProjectName(clientProjectEAR));
    }

    public String getFolder() {
        return this.sampleFolderText_.getText();
    }

    public void setFolder(String folder) {
        this.sampleFolderText_.setText(folder);
    }

    public boolean getIsTestWidget() {
        return this.isTestWidget;
    }

    public void setJspFolder(String folder) {
        this.webContentPath_ = new Path(folder).removeLastSegments(1);
        this.webContent_ = ResourceUtils.findResource((IPath)this.webContentPath_);
        this.sampleFolderBrowseButton_.setEnabled(this.webContent_ != null);
        this.jspFolderText_.setText(folder);
    }

    public String getJspFolder() {
        return this.jspFolderText_.getText();
    }

    public void setLaunchedServiceTestName(String launchedServiceTestName) {
    }

    public boolean getRunTestClient() {
        return this.runTestCheckbox_.getSelection();
    }

    public void setRunTestClient(boolean value) {
        this.runTestCheckbox_.setSelection(value);
    }

    public void setIsWebProject(boolean value) {
        this.isWebProject = value;
    }

    public void setCanRunTestClient(boolean canRunTestClient) {
        this.canRunTestClient_ = canRunTestClient;
        if (!this.canRunTestClient_) {
            this.runTestCheckbox_.setSelection(false);
            this.runTestCheckbox_.setEnabled(false);
        }
    }

    public void setPopup(boolean popup) {
        this.isPopup = popup;
        if (this.isPopup) {
            UIUtils uiUtils = new UIUtils(this.pluginId_);
            this.runtimesCombo = uiUtils.createCombo(this.comboGroup_, ConsumptionUIMessages.LABEL_SERVERS_LIST, ConsumptionUIMessages.TOOLTIP_PWSM_COMBOBOX_SERVER, this.INFOPOP_PWSM_COMBOBOX_SERVER, 2060);
            this.runtimesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ClientTestWidget.this.handleServerChange();
                }
            });
            new Label(this.comboGroup_, 0);
            this.serverInstanceTypeCombo_ = uiUtils.createCombo(this.comboGroup_, ConsumptionUIMessages.LABEL_SERVERS_INSTANCES, ConsumptionUIMessages.TOOLTIP_PWSM_COMBOBOX_SERVER_INSTANCE, this.INFOPOP_PWSM_COMBOBOX_SERVER_INSTANCE, 2060);
            new Label(this.comboGroup_, 0);
            this.initServersTypes();
        }
    }

    public boolean getCanRunTestClient() {
        return this.canRunTestClient_;
    }

    public String getServerInstanceId() {
        int instanceLabel = this.serverInstanceTypeCombo_.getSelectionIndex();
        if (instanceLabel == -1) {
            return null;
        }
        return this.serverInstances_.getId(instanceLabel);
    }

    public String getExistingServerId() {
        int typeLabel = this.runtimesCombo.getSelectionIndex();
        if (typeLabel == -1) {
            return null;
        }
        return this.runtimes_.getId(typeLabel);
    }

    public BooleanSelection[] getMethods() {
        TreeItem[] items = this.methodsTree_.getItems();
        BooleanSelection[] methods = new BooleanSelection[items.length];
        int index = 0;
        while (index < items.length) {
            methods[index] = new BooleanSelection(items[index].getText(), items[index].getChecked());
            ++index;
        }
        return methods;
    }

    public void setMethods(BooleanSelection[] methods) {
        this.methodsTree_.removeAll();
        int index = 0;
        while (index < methods.length) {
            if (methods[index] != null) {
                TreeItem item = new TreeItem(this.methodsTree_, 0);
                item.setText(methods[index].getValue());
                item.setChecked(methods[index].isSelected());
            }
            ++index;
        }
    }

    public void setInitialSelection(IStructuredSelection selection) {
        this.initialSelection_ = selection;
    }

    public IStatus getStatus() {
        if (!this.canRunTestClient_) {
            return StatusUtils.warningStatus((String)ConsumptionUIMessages.MSG_SERVER_NOT_FOUND_WARNING);
        }
        return Status.OK_STATUS;
    }
}

