/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.ServerPublishInfo;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.XMLMemento;

public class PublishInfo {
    protected static PublishInfo instance;
    protected static final String PUBLISH_DIR = "publish";
    protected Map<String, String> serverIdToPath = new HashMap<String, String>();
    protected Map<String, ServerPublishInfo> serverIdToPublishInfo = new HashMap<String, ServerPublishInfo>();

    private PublishInfo() {
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PublishInfo getInstance() {
        if (instance != null) return instance;
        String string = PUBLISH_DIR;
        synchronized (PUBLISH_DIR) {
            instance = new PublishInfo();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerPublishInfo getServerPublishInfo(IServer server) {
        String serverId = server.getId();
        if (this.serverIdToPath.containsKey(serverId)) {
            if (this.serverIdToPublishInfo.containsKey(serverId)) {
                return this.serverIdToPublishInfo.get(serverId);
            }
            String partialPath = this.serverIdToPath.get(serverId);
            partialPath = String.valueOf(partialPath.substring(0, partialPath.length() - 3)) + "dat";
            IPath path = ServerPlugin.getInstance().getStateLocation().append(PUBLISH_DIR).append(partialPath);
            ServerPublishInfo spi = new ServerPublishInfo(path);
            this.serverIdToPublishInfo.put(serverId, spi);
            return spi;
        }
        IPath path = ServerPlugin.getInstance().getStateLocation().append(PUBLISH_DIR);
        File file = new File(path.toOSString());
        if (!file.exists()) {
            file.mkdir();
        }
        file = null;
        int i = 0;
        String partialPath = null;
        ServerPublishInfo spi = null;
        String string = PUBLISH_DIR;
        synchronized (PUBLISH_DIR) {
            while (file == null || file.exists()) {
                partialPath = PUBLISH_DIR + i + ".dat";
                path = ServerPlugin.getInstance().getStateLocation().append(PUBLISH_DIR).append(partialPath);
                if (this.serverIdToPath.get(partialPath) == null) {
                    file = new File(path.toOSString());
                }
                ++i;
            }
            spi = new ServerPublishInfo(path);
            this.serverIdToPath.put(serverId, partialPath);
            this.serverIdToPublishInfo.put(serverId, spi);
            this.save();
            // ** MonitorExit[var8_11] (shouldn't be in output)
            return spi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServerPublishInfo(IServer server) {
        IPath path = ServerPlugin.getInstance().getStateLocation().append(PUBLISH_DIR);
        File file = new File(path.toOSString());
        if (!file.exists()) {
            return;
        }
        String serverId = server.getId();
        String path2 = this.serverIdToPath.get(serverId);
        String string = PUBLISH_DIR;
        synchronized (PUBLISH_DIR) {
            this.serverIdToPath.remove(serverId);
            this.serverIdToPublishInfo.remove(serverId);
            this.save();
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (path2 != null) {
                path.append(path2).toFile().delete();
                path2 = String.valueOf(path2.substring(0, path2.length() - 3)) + "xml";
                path.append(path2).toFile().delete();
                path2 = String.valueOf(path2.substring(0, path2.length() - 3)) + "dat";
                path.append(path2).toFile().delete();
            }
            return;
        }
    }

    protected void load() {
        Trace.trace(5, "Loading publish info");
        String filename = ServerPlugin.getInstance().getStateLocation().append("publish.xml").toOSString();
        try {
            IMemento memento = XMLMemento.loadMemento(filename);
            IMemento[] serverChild = memento.getChildren("server");
            int size = serverChild.length;
            this.serverIdToPath = new HashMap<String, String>(size + 2);
            int i = 0;
            while (i < size) {
                String id = serverChild[i].getString("id");
                String partialPath = serverChild[i].getString("path");
                this.serverIdToPath.put(id, partialPath);
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(2, "Could not load global publish info", e);
        }
    }

    protected void save() {
        String filename = ServerPlugin.getInstance().getStateLocation().append("publish.xml").toOSString();
        try {
            XMLMemento memento = XMLMemento.createWriteRoot("publish-info");
            for (String serverId : this.serverIdToPath.keySet()) {
                String partialPath = this.serverIdToPath.get(serverId);
                IMemento server = memento.createChild("server");
                server.putString("id", serverId);
                server.putString("path", partialPath);
            }
            memento.saveToFile(filename);
        }
        catch (Exception e) {
            Trace.trace(3, "Could not save global publish info", e);
        }
    }
}

