/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.spelling;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.spelling.ISpellingEngine;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.eclipse.wst.jsdt.core.IProblemRequestor;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.CoreSpellingProblem;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.JavaSpellingEngine;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.JavaSpellingProblem;

public class JavaSpellingReconcileStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    protected ISpellingEngine spellingEngine = new JavaSpellingEngine();
    public static final int SPELLING_PROBLEM_ID = Integer.MIN_VALUE;
    private ITextEditor fEditor;
    private IProblemRequestor fRequestor;
    private IDocument fDocument;
    private IProgressMonitor fProgressMonitor;
    private ISpellingProblemCollector fSpellingProblemCollector;
    private SpellingContext fSpellingContext;

    public JavaSpellingReconcileStrategy(ISourceViewer viewer, ITextEditor editor) {
        Assert.isNotNull((Object)viewer);
        this.fSpellingContext = new SpellingContext();
        this.fEditor = editor;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reconcile(IRegion region) {
        if (this.fRequestor == null) return;
        if (!this.isSpellingEnabled()) return;
        if (this.getAnnotationModel() == null) return;
        if (this.fSpellingProblemCollector == null) {
            return;
        }
        try {
            this.fSpellingProblemCollector.beginCollecting();
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    JavaSpellingReconcileStrategy.this.spellingEngine.check(JavaSpellingReconcileStrategy.this.fDocument, new IRegion[]{new Region(0, JavaSpellingReconcileStrategy.this.fDocument.getLength())}, JavaSpellingReconcileStrategy.this.fSpellingContext, JavaSpellingReconcileStrategy.this.fSpellingProblemCollector, JavaSpellingReconcileStrategy.this.fProgressMonitor);
                }

                public void handleException(Throwable x) {
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fSpellingProblemCollector.endCollecting();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.fSpellingProblemCollector.endCollecting();
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
        this.fSpellingProblemCollector = this.createSpellingProblemCollector();
        this.updateProblemRequester();
    }

    private boolean isSpellingEnabled() {
        return EditorsUI.getPreferenceStore().getBoolean("spellingEnabled");
    }

    protected ISpellingProblemCollector createSpellingProblemCollector() {
        return new SpellingProblemCollector();
    }

    private void updateProblemRequester() {
        IAnnotationModel model = this.getAnnotationModel();
        this.fRequestor = model instanceof IProblemRequestor ? (IProblemRequestor)model : null;
    }

    protected IAnnotationModel getAnnotationModel() {
        IDocumentProvider documentProvider = this.fEditor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        return documentProvider.getAnnotationModel((Object)this.fEditor.getEditorInput());
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(subRegion);
    }

    public void initialReconcile() {
        this.reconcile((IRegion)new Region(0, this.fDocument.getLength()));
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    private class SpellingProblemCollector
    implements ISpellingProblemCollector {
        private SpellingProblemCollector() {
        }

        public void accept(SpellingProblem problem) {
            IProblemRequestor requestor = JavaSpellingReconcileStrategy.this.fRequestor;
            if (requestor != null) {
                try {
                    IEditorInput editorInput;
                    int line = JavaSpellingReconcileStrategy.this.fDocument.getLineOfOffset(problem.getOffset()) + 1;
                    String word = JavaSpellingReconcileStrategy.this.fDocument.get(problem.getOffset(), problem.getLength());
                    boolean dictionaryMatch = false;
                    boolean sentenceStart = false;
                    if (problem instanceof JavaSpellingProblem) {
                        dictionaryMatch = ((JavaSpellingProblem)problem).isDictionaryMatch();
                        sentenceStart = ((JavaSpellingProblem)problem).isSentenceStart();
                    }
                    if ((editorInput = JavaSpellingReconcileStrategy.this.fEditor.getEditorInput()) != null) {
                        CoreSpellingProblem iProblem = new CoreSpellingProblem(problem.getOffset(), problem.getOffset() + problem.getLength() - 1, line, problem.getMessage(), word, dictionaryMatch, sentenceStart, JavaSpellingReconcileStrategy.this.fDocument, editorInput.getName());
                        requestor.acceptProblem((IProblem)iProblem);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        public void beginCollecting() {
            if (JavaSpellingReconcileStrategy.this.fRequestor != null) {
                JavaSpellingReconcileStrategy.this.fRequestor.beginReporting();
            }
        }

        public void endCollecting() {
            if (JavaSpellingReconcileStrategy.this.fRequestor != null) {
                JavaSpellingReconcileStrategy.this.fRequestor.endReporting();
            }
        }
    }
}

