/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;

public abstract class AbstractFix
implements IFix {
    private final String fName;
    private final IJavaScriptUnit fCompilationUnit;
    private final IFixRewriteOperation[] fFixRewrites;
    private final JavaScriptUnit fUnit;
    private IStatus fStatus;

    protected AbstractFix(String name, JavaScriptUnit compilationUnit, IFixRewriteOperation[] fixRewriteOperations) {
        this.fName = name;
        this.fCompilationUnit = (IJavaScriptUnit)compilationUnit.getJavaElement();
        this.fFixRewrites = fixRewriteOperations;
        this.fUnit = compilationUnit;
        this.fStatus = StatusInfo.OK_STATUS;
    }

    public String getDescription() {
        return this.fName;
    }

    public IJavaScriptUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public TextChange createChange() throws CoreException {
        if (this.fFixRewrites == null || this.fFixRewrites.length == 0) {
            return null;
        }
        CompilationUnitRewrite cuRewrite = new CompilationUnitRewrite(this.getCompilationUnit(), this.fUnit);
        ArrayList groups = new ArrayList();
        int i = 0;
        while (i < this.fFixRewrites.length) {
            this.fFixRewrites[i].rewriteAST(cuRewrite, groups);
            ++i;
        }
        CompilationUnitChange result = cuRewrite.createChange(this.getDescription(), true, null);
        if (result == null) {
            return null;
        }
        Iterator iter = groups.iterator();
        while (iter.hasNext()) {
            TextEditGroup group = (TextEditGroup)iter.next();
            result.addTextEditGroup(group);
        }
        return result;
    }

    public String getAdditionalInfo() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.fFixRewrites.length) {
            AbstractFixRewriteOperation fro;
            String info;
            IFixRewriteOperation frw = this.fFixRewrites[i];
            if (frw instanceof AbstractFixRewriteOperation && (info = (fro = (AbstractFixRewriteOperation)frw).getAdditionalInfo()) != null) {
                sb.append(info);
            }
            ++i;
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    public void setStatus(IStatus status) {
        this.fStatus = status;
    }

    public static abstract class AbstractFixRewriteOperation
    implements IFixRewriteOperation {
        protected Type importType(ITypeBinding toImport, ASTNode accessor, ImportRewrite imports, JavaScriptUnit compilationUnit) {
            ContextSensitiveImportRewriteContext importContext = new ContextSensitiveImportRewriteContext(compilationUnit, accessor.getStartPosition(), imports);
            return imports.addImport(toImport, compilationUnit.getAST(), (ImportRewrite.ImportRewriteContext)importContext);
        }

        protected TextEditGroup createTextEditGroup(String label) {
            if (label.length() > 0) {
                return new CategorizedTextEditGroup(label, new GroupCategorySet(new GroupCategory(label, label, label)));
            }
            return new TextEditGroup(label);
        }

        public String getAdditionalInfo() {
            return null;
        }
    }
}

