/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.search.MethodDeclarationMatch;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.delegates.DelegateMethodCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodOccurenceCollector;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameMethodProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class RenameNonVirtualMethodProcessor
extends RenameMethodProcessor {
    RenameNonVirtualMethodProcessor(IFunction method, TextChangeManager manager, GroupCategorySet categorySet) {
        super(method, manager, categorySet);
    }

    public RenameNonVirtualMethodProcessor(IFunction method) {
        super(method);
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameNonVirtualMethodAvailable(this.getMethod());
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext checkContext) throws CoreException {
        RefactoringStatus refactoringStatus;
        RefactoringStatus result;
        block7: {
            pm.beginTask("", 3);
            result = new RefactoringStatus();
            result.merge(super.doCheckFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 1), checkContext));
            if (!result.hasFatalError()) break block7;
            RefactoringStatus refactoringStatus2 = result;
            Object var12_6 = null;
            pm.done();
            return refactoringStatus2;
        }
        try {
            IFunction method = this.getMethod();
            IType declaring = method.getDeclaringType();
            String name = this.getNewElementName();
            if (declaring != null) {
                IFunction[] hierarchyMethods = RenameNonVirtualMethodProcessor.hierarchyDeclaresMethodName((IProgressMonitor)new SubProgressMonitor(pm, 1), declaring.newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(pm, 1)), method, name);
                int i = 0;
                while (i < hierarchyMethods.length) {
                    String message;
                    IFunction hierarchyMethod = hierarchyMethods[i];
                    RefactoringStatusContext context = JavaStatusContext.create((IMember)hierarchyMethod);
                    if (Checks.compareParamTypes(method.getParameterTypes(), hierarchyMethod.getParameterTypes())) {
                        message = Messages.format(RefactoringCoreMessages.RenamePrivateMethodRefactoring_hierarchy_defines, new String[]{JavaModelUtil.getFullyQualifiedName(declaring), name});
                        result.addError(message, context);
                    } else {
                        message = Messages.format(RefactoringCoreMessages.RenamePrivateMethodRefactoring_hierarchy_defines2, new String[]{JavaModelUtil.getFullyQualifiedName(declaring), name});
                        result.addWarning(message, context);
                    }
                    ++i;
                }
            }
            refactoringStatus = result;
            Object var12_7 = null;
        }
        catch (Throwable throwable) {
            Object var12_8 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    protected SearchResultGroup[] getOccurrences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        pm.beginTask("", 2);
        SearchPattern pattern = this.createReferenceSearchPattern();
        SearchResultGroup[] groups = RefactoringSearchEngine.search(pattern, this.createRefactoringScope(), new MethodOccurenceCollector(this.getMethod().getElementName()), (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
        int i = 0;
        while (i < groups.length) {
            SearchResultGroup group = groups[i];
            IJavaScriptUnit cu = group.getCompilationUnit();
            if (cu.equals(this.getDeclaringCU())) {
                IResource resource = group.getResource();
                int start = this.getMethod().getNameRange().getOffset();
                int length = this.getMethod().getNameRange().getLength();
                MethodDeclarationMatch declarationMatch = new MethodDeclarationMatch((IJavaScriptElement)this.getMethod(), 0, start, length, SearchEngine.getDefaultSearchParticipant(), resource);
                group.add((SearchMatch)declarationMatch);
                break;
            }
            ++i;
        }
        return groups;
    }

    void addOccurrences(TextChangeManager manager, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        pm.beginTask("", 1);
        this.addDeclarationUpdate(manager);
        if (this.getUpdateReferences()) {
            this.addReferenceUpdates(manager, pm, status);
        }
        pm.worked(1);
    }

    private IJavaScriptUnit getDeclaringCU() {
        return this.getMethod().getJavaScriptUnit();
    }

    SearchPattern createOccurrenceSearchPattern(IProgressMonitor pm) {
        pm.beginTask("", 1);
        SearchPattern pattern = SearchPattern.createPattern((IJavaScriptElement)this.getMethod(), (int)3, (int)24);
        pm.done();
        return pattern;
    }

    private SearchPattern createReferenceSearchPattern() {
        return SearchPattern.createPattern((IJavaScriptElement)this.getMethod(), (int)2, (int)24);
    }

    final void addDeclarationUpdate(TextChangeManager manager) throws CoreException {
        if (this.getDelegateUpdating()) {
            CompilationUnitRewrite rewrite = new CompilationUnitRewrite(this.getDeclaringCU());
            rewrite.setResolveBindings(true);
            FunctionDeclaration methodDeclaration = ASTNodeSearchUtil.getMethodDeclarationNode(this.getMethod(), rewrite.getRoot());
            DelegateMethodCreator creator = new DelegateMethodCreator();
            creator.setDeclaration((BodyDeclaration)methodDeclaration);
            creator.setDeclareDeprecated(this.getDeprecateDelegates());
            creator.setSourceRewrite(rewrite);
            creator.setCopy(true);
            creator.setNewElementName(this.getNewElementName());
            creator.prepareDelegate();
            creator.createEdit();
            CompilationUnitChange cuChange = rewrite.createChange();
            if (cuChange != null) {
                cuChange.setKeepPreviewEdits(true);
                manager.manage(this.getDeclaringCU(), (TextChange)cuChange);
            }
        }
        String editName = RefactoringCoreMessages.RenameMethodRefactoring_update_declaration;
        ISourceRange nameRange = this.getMethod().getNameRange();
        ReplaceEdit replaceEdit = new ReplaceEdit(nameRange.getOffset(), nameRange.getLength(), this.getNewElementName());
        this.addTextEdit(manager.get(this.getDeclaringCU()), editName, replaceEdit);
    }

    private void addReferenceUpdates(TextChangeManager manager, IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        SearchResultGroup[] grouped = this.getReferences(pm, status);
        int i = 0;
        while (i < grouped.length) {
            SearchResultGroup group = grouped[i];
            SearchMatch[] results = group.getSearchResults();
            IJavaScriptUnit cu = group.getCompilationUnit();
            TextChange change = manager.get(cu);
            int j = 0;
            while (j < results.length) {
                String editName = RefactoringCoreMessages.RenamePrivateMethodRefactoring_update;
                ReplaceEdit replaceEdit = this.createReplaceEdit(results[j], cu);
                this.addTextEdit(change, editName, replaceEdit);
                ++j;
            }
            ++i;
        }
    }

    private SearchResultGroup[] getReferences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        pm.beginTask("", 2);
        SearchPattern pattern = this.createReferenceSearchPattern();
        return RefactoringSearchEngine.search(pattern, this.createRefactoringScope(), new MethodOccurenceCollector(this.getMethod().getElementName()), (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
    }

    public String getDelegateUpdatingTitle(boolean plural) {
        if (plural) {
            return RefactoringCoreMessages.DelegateMethodCreator_keep_original_renamed_plural;
        }
        return RefactoringCoreMessages.DelegateMethodCreator_keep_original_renamed_singular;
    }
}

