/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.util.ConvertUtility;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.Logger;

public class ConvertAction
implements IObjectActionDelegate,
IActionDelegate {
    IWorkbenchPart fPart;
    Object[] fTarget;
    private static final String FACET_NATURE = "org.eclipse.wst.common.project.facet.core.nature";
    private static final String FACET_PROPERTY_PAGE = "org.eclipse.wst.common.project.facet.ui.FacetsPropertyPage";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private void doInstall(IProject project, boolean openProperties, IProgressMonitor monitor) {
        boolean configured = false;
        monitor.beginTask(Messages.converter_ConfiguringForJavaScript, 5);
        ConvertUtility convertor = new ConvertUtility(project);
        try {
            boolean hadBasicNature = ConvertUtility.hasNature((IProject)project);
            convertor.configure((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            convertor.addBrowserSupport(!hadBasicNature, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!hadBasicNature) {
                JavaProject jp = (JavaProject)JavaScriptCore.create((IProject)project);
                IIncludePathEntry[] oldEntries = null;
                try {
                    oldEntries = jp.getRawIncludepath();
                    ArrayList<IIncludePathEntry> entries = new ArrayList<IIncludePathEntry>();
                    int i = 0;
                    while (i < oldEntries.length) {
                        if (oldEntries[i].getContentKind() != 1 || oldEntries[i].getEntryKind() != 3) {
                            entries.add(oldEntries[i]);
                        }
                        ++i;
                    }
                    oldEntries = entries.toArray(new IIncludePathEntry[entries.size()]);
                }
                catch (JavaScriptModelException ex1) {
                    Logger.log(204, null, ex1);
                    oldEntries = new IIncludePathEntry[]{};
                }
                IIncludePathEntry[] sourcePaths = convertor.getDefaultSourcePaths(project);
                IIncludePathEntry[] newEntries = new IIncludePathEntry[oldEntries.length + sourcePaths.length];
                System.arraycopy(sourcePaths, 0, newEntries, 0, sourcePaths.length);
                System.arraycopy(oldEntries, 0, newEntries, sourcePaths.length, oldEntries.length);
                try {
                    jp.setRawIncludepath(newEntries, project.getFullPath(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (JavaScriptModelException ex1) {
                    Logger.log(204, null, ex1);
                }
            }
            configured = true;
        }
        catch (CoreException ex) {
            Logger.logException(ex);
        }
        if (configured && openProperties) {
            this.showPropertiesOn(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        monitor.done();
    }

    private void doUninstall(IProject project, IProgressMonitor monitor) {
    }

    void enableForFacets(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            boolean hasNature = project.hasNature(FACET_NATURE);
            if (!hasNature) {
                ArrayList<String> natures = new ArrayList<String>(Arrays.asList(description.getNatureIds()));
                natures.add(FACET_NATURE);
                description.setNatureIds(natures.toArray(new String[natures.size()]));
            }
            if (!hasNature) {
                project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }

    private void install(final IProject project, final boolean openProperties) {
        IProgressService service = null;
        if (this.fPart != null) {
            IWorkbenchPartSite iWorkbenchPartSite = this.fPart.getSite();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.progress.IProgressService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            service = (IProgressService)iWorkbenchPartSite.getService((Class)clazz);
        }
        if (service == null) {
            this.doInstall(project, openProperties, (IProgressMonitor)new NullProgressMonitor());
        } else {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ConvertAction.this.doInstall(project, openProperties, monitor);
                }
            };
            try {
                service.run(false, false, runnable);
            }
            catch (InvocationTargetException e) {
                Logger.logException(e);
            }
            catch (InterruptedException e) {
                Logger.logException(e);
            }
        }
    }

    public void run(IAction action) {
        if (this.fTarget == null) {
            return;
        }
        int i = 0;
        while (i < this.fTarget.length) {
            if (this.fTarget[i] instanceof IResource) {
                IProject project = ((IResource)this.fTarget[i]).getProject();
                if (!ConvertUtility.hasNature((IProject)project)) {
                    this.install(project, i == this.fTarget.length - 1);
                } else {
                    IJavaScriptProject jp = JavaScriptCore.create((IProject)project);
                    IIncludePathEntry[] rawClasspath = null;
                    try {
                        rawClasspath = jp.getRawIncludepath();
                    }
                    catch (JavaScriptModelException ex1) {
                        Logger.log(204, null, ex1);
                    }
                    boolean browserFound = false;
                    int k = 0;
                    while (rawClasspath != null && !browserFound && k < rawClasspath.length) {
                        if (rawClasspath[k].getPath().equals((Object)ConvertUtility.BROWSER_LIBRARY_PATH)) {
                            browserFound = true;
                        }
                        ++k;
                    }
                    if (!browserFound) {
                        this.install(project, false);
                    }
                }
            }
            ++i;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fTarget = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).toArray() : null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fPart = targetPart;
    }

    private void showPropertiesOn(final IProject project, final IProgressMonitor monitor) {
        Shell finalShell;
        IWorkbenchWindow activeWorkbenchWindow;
        Shell shell;
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.propertyPages").getExtensions();
        final ArrayList<String> pageIds = new ArrayList<String>(8);
        pageIds.add(FACET_PROPERTY_PAGE);
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].getNamespaceIdentifier().startsWith("org.eclipse.wst.jsdt.")) {
                IConfigurationElement[] configurationElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configurationElements.length) {
                    if ("page".equals(configurationElements[j].getName())) {
                        pageIds.add(configurationElements[j].getAttribute("id"));
                    }
                    ++j;
                }
            }
            ++i;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.widgets.Shell");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((shell = (Shell)this.fPart.getAdapter((Class)clazz)) == null && (activeWorkbenchWindow = JavaScriptPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow()) != null) {
            shell = activeWorkbenchWindow.getShell();
        }
        if ((finalShell = shell) != null) {
            finalShell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)finalShell, (IAdaptable)project, (String)"org.eclipse.wst.jsdt.ui.propertyPages.BuildPathsPropertyPage", (String[])pageIds.toArray(new String[pageIds.size()]), null);
                    if (dialog.open() == 1) {
                        ConvertAction.this.doUninstall(project, monitor);
                    }
                }
            });
        }
    }
}

