/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.provider;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.EjbMethodElementComparator;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.internal.impl.EjbFactoryImpl;
import org.eclipse.jst.j2ee.internal.ejb.provider.EJBNameComparator;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.common.frameworks.internal.ui.DisplayUtility;

public abstract class AbstractMethodsContentProvider
extends AdapterFactoryContentProvider {
    protected static EStructuralFeature ME_EJB_SF = EjbFactoryImpl.getPackage().getMethodElement_EnterpriseBean();
    protected static EStructuralFeature JAR_ASSEMBLY_SF = EjbFactoryImpl.getPackage().getEJBJar_AssemblyDescriptor();
    private static final EStructuralFeature ECORE_BEAN_NAME = EcorePackage.eINSTANCE.getENamedElement_Name();
    protected Comparator meComparator;
    protected boolean isRoot = true;

    public AbstractMethodsContentProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public AbstractMethodsContentProvider(AdapterFactory adapterFactory, boolean root) {
        super(adapterFactory);
        this.isRoot = root;
    }

    protected Comparator getEnterpriseBeanComparator() {
        return EJBNameComparator.singleton();
    }

    protected Comparator getMethodElementComparator() {
        if (this.meComparator == null) {
            this.meComparator = new EjbMethodElementComparator();
        }
        return this.meComparator;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof EJBMethodItem) {
            return this.getMethodElements((EJBMethodItem)parentElement);
        }
        return new Object[0];
    }

    protected Object[] getMethodElements(EJBMethodItem ejbItem) {
        EObject refObject = ejbItem.refObject;
        if (refObject == null) {
            return new Object[0];
        }
        List elements = this.getMethodElements(refObject, ejbItem.ejb);
        Object[] result = elements.toArray();
        if (result.length == 1) {
            return result;
        }
        Arrays.sort(result, this.getMethodElementComparator());
        return result;
    }

    protected abstract List getMethodElements(EObject var1, EnterpriseBean var2);

    protected Object[] getEnterpriseBeans(EObject parentElement, List someMethodElements) {
        if (someMethodElements.isEmpty()) {
            return new Object[0];
        }
        HashSet<EnterpriseBean> ejbs = new HashSet<EnterpriseBean>();
        EnterpriseBean ejb = null;
        MethodElement me = null;
        int i = 0;
        while (i < someMethodElements.size()) {
            me = (MethodElement)someMethodElements.get(i);
            ejb = me.getEnterpriseBean();
            if (ejb != null) {
                ejbs.add(ejb);
            }
            ++i;
        }
        Object[] result = ejbs.toArray();
        if (result.length != 1) {
            Arrays.sort(result, this.getEnterpriseBeanComparator());
        }
        ejb = null;
        int i2 = 0;
        while (i2 < result.length) {
            ejb = (EnterpriseBean)result[i2];
            result[i2] = new EJBMethodItem(parentElement, ejb);
            ++i2;
        }
        return result;
    }

    protected AssemblyDescriptor getAssemblyDescriptor(EnterpriseBean ejb) {
        if (ejb == null) {
            return null;
        }
        return ejb.getEjbJar().getAssemblyDescriptor();
    }

    public boolean hasChildren(Object element) {
        return element instanceof EJBMethodItem;
    }

    protected TreeViewer getTreeViewer() {
        return (TreeViewer)this.viewer;
    }

    protected void refreshTreeViewer(Object obj) {
        if (this.viewer != null) {
            DisplayUtility.asyncExec((Runnable)this.createRefreshTreeRunnable(obj));
        }
    }

    protected void refreshTreeViewer() {
        if (this.viewer != null) {
            DisplayUtility.asyncExec((Runnable)this.createRefreshTreeRunnable(null));
        }
    }

    protected void refreshTreeViewer(MethodElement me) {
        this.refreshTreeViewer(me.eContainer());
    }

    protected void refreshTreeViewer(List aList) {
        if (aList.isEmpty()) {
            return;
        }
        this.refreshTreeViewer((MethodElement)aList.get(0));
    }

    protected void addToTreeViewer(final MethodElement me) {
        if (this.viewer == null) {
            return;
        }
        DisplayUtility.asyncExec((Runnable)new Runnable(){

            public void run() {
                EJBMethodItem item = AbstractMethodsContentProvider.this.findMethodItem(me);
                if (item != null) {
                    DisplayUtility.asyncExec((Runnable)AbstractMethodsContentProvider.this.createAddItemTreeRunnable(item, me));
                } else {
                    AbstractMethodsContentProvider.this.refreshTreeViewer(me.eContainer());
                }
            }
        });
    }

    protected void removeFromTreeViewer(final EObject parent, final MethodElement me) {
        if (this.viewer == null) {
            return;
        }
        DisplayUtility.asyncExec((Runnable)new Runnable(){

            public void run() {
                EnterpriseBean ejb = me.getEnterpriseBean();
                EJBMethodItem item = AbstractMethodsContentProvider.this.findMethodItem(ejb, parent);
                if (item != null) {
                    AbstractMethodsContentProvider.this.refreshTreeViewer(item);
                } else {
                    AbstractMethodsContentProvider.this.refreshTreeViewer((Object)null);
                }
            }
        });
    }

    protected EJBMethodItem findMethodItem(MethodElement me) {
        return this.findMethodItem(me.getEnterpriseBean(), me.eContainer());
    }

    protected EJBMethodItem findMethodItem(EnterpriseBean ejb, EObject parentMethod) {
        TreeItem[] items = this.getTreeViewer().getTree().getItems();
        return this.findMethodItem(ejb, parentMethod, items);
    }

    protected EJBMethodItem findMethodItem(EnterpriseBean ejb, EObject parentMethod, TreeItem[] items) {
        TreeItem item = null;
        Object data = null;
        EJBMethodItem methodItem = null;
        EJBMethodItem found = null;
        int i = 0;
        while (i < items.length) {
            item = items[i];
            data = item.getData();
            if (data instanceof EJBMethodItem) {
                methodItem = (EJBMethodItem)data;
                if (methodItem.ejb == ejb && methodItem.refObject == parentMethod) {
                    return methodItem;
                }
            }
            if ((found = this.findMethodItem(ejb, parentMethod, item.getItems())) != null) {
                return found;
            }
            ++i;
        }
        return null;
    }

    public void notifyChanged(Notification notifier) {
        if (notifier.getEventType() == 9) {
            return;
        }
        if (notifier.getOldValue() instanceof CMPAttribute && notifier.getNewValue() == null) {
            return;
        }
        if (notifier.getFeature() == ME_EJB_SF) {
            this.refreshTreeViewer((MethodElement)notifier.getNotifier());
            return;
        }
        if (notifier.getFeature() == ECORE_BEAN_NAME) {
            this.refreshTreeViewer();
            return;
        }
        if (this.getMethodElementsReference() == notifier.getFeature()) {
            if (notifier.getEventType() == 3) {
                this.addToTreeViewer((MethodElement)notifier.getNewValue());
            } else if (notifier.getEventType() == 4) {
                this.removeFromTreeViewer((EObject)notifier.getNotifier(), (MethodElement)notifier.getOldValue());
            }
            return;
        }
        if (notifier.getFeature() == JAR_ASSEMBLY_SF && this.isRoot) {
            this.updateTreeInput(notifier.getNewValue());
        } else if (notifier.getFeature() == this.getMethodElementsContainerReference()) {
            super.notifyChanged(notifier);
        }
    }

    protected void updateTreeInput(final Object target) {
        DisplayUtility.asyncExec((Runnable)new Runnable(){

            public void run() {
                AbstractMethodsContentProvider.this.getTreeViewer().setInput(target);
                AbstractMethodsContentProvider.this.getTreeViewer().refresh(target);
            }
        });
    }

    private Runnable createAddItemTreeRunnable(final Object parent, final MethodElement me) {
        return new Runnable(){

            public void run() {
                AbstractMethodsContentProvider.this.getTreeViewer().add(parent, (Object)me);
            }
        };
    }

    private Runnable createRefreshTreeRunnable(final Object target) {
        return new Runnable(){

            public void run() {
                if (target != null) {
                    AbstractMethodsContentProvider.this.getTreeViewer().refresh(target);
                } else {
                    AbstractMethodsContentProvider.this.getTreeViewer().refresh();
                }
            }
        };
    }

    protected abstract EStructuralFeature getMethodElementsReference();

    protected abstract EStructuralFeature getMethodElementsContainerReference();

    public class EJBMethodItem {
        public EObject refObject;
        public EnterpriseBean ejb;

        public EJBMethodItem(EObject aRefObject, EnterpriseBean anEJB) {
            this.refObject = aRefObject;
            this.ejb = anEJB;
        }
    }
}

