/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.handlers;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.handlers.AbstractStructuredSelectHandler;
import org.w3c.dom.Node;

public class StructuredSelectNextXMLHandler
extends AbstractStructuredSelectHandler {
    protected IndexedRegion getCursorIndexedRegion(IDocument document, ITextSelection textSelection) {
        int offset = textSelection.getOffset() + textSelection.getLength() - 1;
        if (offset < 0) {
            offset = 0;
        }
        IndexedRegion indexedRegion = null;
        indexedRegion = this.getIndexedRegion(document, offset);
        return indexedRegion;
    }

    protected Region getNewSelectionRegion(IndexedRegion indexedRegion, ITextSelection textSelection) {
        Region newRegion = null;
        if (indexedRegion instanceof Node) {
            Node cursorNode = (Node)indexedRegion;
            if (cursorNode.getNodeType() == 3 && cursorNode.getNodeValue().trim().length() == 0 && (cursorNode = cursorNode.getParentNode()) instanceof IndexedRegion) {
                indexedRegion = (IndexedRegion)cursorNode;
            }
            Region cursorNodeRegion = new Region(indexedRegion.getStartOffset(), indexedRegion.getEndOffset() - indexedRegion.getStartOffset());
            int currentOffset = textSelection.getOffset();
            int currentEndOffset = currentOffset + textSelection.getLength();
            newRegion = cursorNodeRegion.getOffset() >= currentOffset && cursorNodeRegion.getOffset() <= currentEndOffset && cursorNodeRegion.getOffset() + cursorNodeRegion.getLength() >= currentOffset && cursorNodeRegion.getOffset() + cursorNodeRegion.getLength() <= currentEndOffset ? this.getNewSelectionRegion2(indexedRegion, textSelection) : cursorNodeRegion;
        }
        return newRegion;
    }

    private Region getNewSelectionRegion2(IndexedRegion indexedRegion, ITextSelection textSelection) {
        Region newRegion = null;
        if (indexedRegion instanceof Node) {
            Node node = (Node)indexedRegion;
            Node newNode = node.getNextSibling();
            if (newNode == null) {
                newNode = node.getParentNode();
                if (newNode instanceof IndexedRegion) {
                    IndexedRegion newIndexedRegion = (IndexedRegion)newNode;
                    newRegion = new Region(newIndexedRegion.getStartOffset(), newIndexedRegion.getEndOffset() - newIndexedRegion.getStartOffset());
                }
            } else if (newNode instanceof IndexedRegion) {
                IndexedRegion newIndexedRegion = (IndexedRegion)newNode;
                newRegion = new Region(textSelection.getOffset(), newIndexedRegion.getEndOffset() - textSelection.getOffset());
                if (newNode.getNodeType() == 3) {
                    newRegion = this.getNewSelectionRegion2(newIndexedRegion, (ITextSelection)new TextSelection(newRegion.getOffset(), newRegion.getLength()));
                }
            }
        }
        return newRegion;
    }
}

