/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class RemoveReferenceComponentOperation
extends AbstractDataModelOperation {
    public RemoveReferenceComponentOperation() {
    }

    public RemoveReferenceComponentOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.removeReferencedComponents(monitor);
        return OK_STATUS;
    }

    protected void removeReferencedComponents(IProgressMonitor monitor) {
        IVirtualComponent sourceComp = (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
        if (sourceComp == null || !sourceComp.getProject().isAccessible() || sourceComp.isBinary()) {
            return;
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("REQUESTED_REFERENCE_TYPE", "DISPLAYABLE_REFERENCES_ALL");
        IVirtualReference[] existingReferencesArray = sourceComp.getReferences(options);
        if (existingReferencesArray == null || existingReferencesArray.length == 0) {
            return;
        }
        ArrayList<IVirtualReference> existingReferences = new ArrayList<IVirtualReference>();
        int i = 0;
        while (i < existingReferencesArray.length) {
            existingReferences.add(existingReferencesArray[i]);
            ++i;
        }
        Path path = null;
        if (this.model.isPropertySet("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH")) {
            String deployPath = this.model.getStringProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH");
            path = new Path(deployPath);
        }
        List modList = (List)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        ArrayList<IProject> targetprojectList = new ArrayList<IProject>();
        int i2 = 0;
        while (i2 < modList.size() && !existingReferences.isEmpty()) {
            IVirtualReference ref;
            IVirtualComponent comp = (IVirtualComponent)modList.get(i2);
            if (comp != null && (ref = this.findMatchingReference(existingReferences, comp, (IPath)path)) != null) {
                this.removeRefereneceInComponent(sourceComp, ref);
                existingReferences.remove(ref);
                ref = this.findMatchingReference(existingReferences, comp);
                if (ref == null) {
                    IProject targetProject = comp.getProject();
                    targetprojectList.add(targetProject);
                }
            }
            ++i2;
        }
        try {
            ProjectUtilities.removeReferenceProjects((IProject)sourceComp.getProject(), targetprojectList);
        }
        catch (CoreException e) {
            ModulecorePlugin.logError(e);
        }
    }

    private IVirtualReference findMatchingReference(List existingReferences, IVirtualComponent comp, IPath path) {
        int i = 0;
        while (i < existingReferences.size()) {
            IVirtualReference ref = (IVirtualReference)existingReferences.get(i);
            IVirtualComponent c = ref.getReferencedComponent();
            if (c != null && c.getName().equals(comp.getName())) {
                if (path == null) {
                    return ref;
                }
                if (path.equals((Object)ref.getRuntimePath())) {
                    return ref;
                }
            }
            ++i;
        }
        return null;
    }

    private IVirtualReference findMatchingReference(List existingReferences, IVirtualComponent comp) {
        return this.findMatchingReference(existingReferences, comp, null);
    }

    protected void removeRefereneceInComponent(IVirtualComponent component, IVirtualReference reference) {
        ((VirtualComponent)component.getComponent()).removeReference(reference);
    }
}

