/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JpaPlatformFactory;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.JptCoreMessages;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.utility.internal.iterables.TransformationIterable;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaPlatformRegistry {
    private final HashMap<String, IConfigurationElement> jpaPlatformConfigurationElements = this.buildJpaPlatformConfigurationElements();
    private static final JpaPlatformRegistry INSTANCE = new JpaPlatformRegistry();
    private static final String EXTENSION_ID = "jpaPlatforms";
    private static final String PLATFORM_ELEMENT_NAME = "jpaPlatform";
    private static final String ID_ATTRIBUTE_NAME = "id";
    private static final String LABEL_ATTRIBUTE_NAME = "label";
    private static final String FACTORY_CLASS_ATTRIBUTE_NAME = "factoryClass";
    private static final String JPA_FACET_VERSION_ATTRIBUTE_NAME = "jpaFacetVersion";
    private static final String DEFAULT_ATTRIBUTE_NAME = "default";

    public static JpaPlatformRegistry instance() {
        return INSTANCE;
    }

    private JpaPlatformRegistry() {
    }

    private HashMap<String, IConfigurationElement> buildJpaPlatformConfigurationElements() {
        HashMap<String, IConfigurationElement> configElements = new HashMap<String, IConfigurationElement>();
        for (IConfigurationElement configElement : this.getConfigElements()) {
            this.addConfigElementTo(configElement, configElements);
        }
        return configElements;
    }

    private Iterable<IConfigurationElement> getConfigElements() {
        return new CompositeIterable((Iterable)new TransformationIterable<IExtension, Iterable<IConfigurationElement>>(this.getExtensions()){

            protected Iterable<IConfigurationElement> transform(IExtension extension) {
                return CollectionTools.iterable((Object[])extension.getConfigurationElements());
            }
        });
    }

    private Iterable<IExtension> getExtensions() {
        return CollectionTools.iterable((Object[])this.getExtensionPoint().getExtensions());
    }

    private IExtensionPoint getExtensionPoint() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jpt.core", EXTENSION_ID);
    }

    private void addConfigElementTo(IConfigurationElement configElement, HashMap<String, IConfigurationElement> configElements) {
        if (!configElement.getName().equals(PLATFORM_ELEMENT_NAME)) {
            return;
        }
        if (!this.configElementIsValid(configElement)) {
            return;
        }
        String id = configElement.getAttribute(ID_ATTRIBUTE_NAME);
        IConfigurationElement prev = configElements.put(id, configElement);
        if (prev != null) {
            configElements.put(id, prev);
            this.logDuplicatePlatform(prev, configElement, id);
        }
    }

    private boolean configElementIsValid(IConfigurationElement configElement) {
        boolean valid = true;
        if (configElement.getAttribute(ID_ATTRIBUTE_NAME) == null) {
            this.logMissingAttribute(configElement, ID_ATTRIBUTE_NAME);
            valid = false;
        }
        if (configElement.getAttribute(LABEL_ATTRIBUTE_NAME) == null) {
            this.logMissingAttribute(configElement, LABEL_ATTRIBUTE_NAME);
            valid = false;
        }
        if (configElement.getAttribute(FACTORY_CLASS_ATTRIBUTE_NAME) == null) {
            this.logMissingAttribute(configElement, FACTORY_CLASS_ATTRIBUTE_NAME);
            valid = false;
        }
        return valid;
    }

    public Iterable<String> getJpaPlatformIds() {
        return this.jpaPlatformConfigurationElements.keySet();
    }

    public boolean containsPlatform(String platformId) {
        return this.jpaPlatformConfigurationElements.containsKey(platformId);
    }

    public String getJpaPlatformLabel(String id) {
        return this.jpaPlatformConfigurationElements.get(id).getAttribute(LABEL_ATTRIBUTE_NAME);
    }

    public boolean platformSupportsJpaFacetVersion(String platformId, String jpaFacetVersion) {
        IConfigurationElement configElement = this.jpaPlatformConfigurationElements.get(platformId);
        return this.configElementSupportsJpaFacetVersion(configElement, jpaFacetVersion);
    }

    boolean configElementSupportsJpaFacetVersion(IConfigurationElement configElement, String jpaFacetVersion) {
        String ver = configElement.getAttribute(JPA_FACET_VERSION_ATTRIBUTE_NAME);
        return ver == null || ver.equals(jpaFacetVersion);
    }

    public Iterable<String> getJpaPlatformIdsForJpaFacetVersion(String jpaFacetVersion) {
        return new TransformationIterable<IConfigurationElement, String>(this.getConfigurationElementsForJpaFacetVersion(jpaFacetVersion)){

            protected String transform(IConfigurationElement configElement) {
                return configElement.getAttribute(JpaPlatformRegistry.ID_ATTRIBUTE_NAME);
            }
        };
    }

    private Iterable<IConfigurationElement> getConfigurationElementsForJpaFacetVersion(final String jpaFacetVersion) {
        return new FilteringIterable<IConfigurationElement>(this.jpaPlatformConfigurationElements.values()){

            protected boolean accept(IConfigurationElement configElement) {
                return JpaPlatformRegistry.this.configElementSupportsJpaFacetVersion(configElement, jpaFacetVersion);
            }
        };
    }

    public String getDefaultJpaPlatformId(String jpaFacetVersion) {
        for (Map.Entry<String, IConfigurationElement> entry : this.jpaPlatformConfigurationElements.entrySet()) {
            String defaultFlag = entry.getValue().getAttribute(DEFAULT_ATTRIBUTE_NAME);
            String platformId = entry.getKey();
            if (defaultFlag == null || !defaultFlag.equals("true") || !this.platformSupportsJpaFacetVersion(platformId, jpaFacetVersion)) continue;
            return platformId;
        }
        return null;
    }

    public JpaPlatform getJpaPlatform(IProject project) {
        JpaPlatformFactory platformFactory;
        String id = JptCorePlugin.getJpaPlatformId(project);
        IConfigurationElement configElement = this.jpaPlatformConfigurationElements.get(id);
        if (configElement == null) {
            this.log(JptCoreMessages.PLATFORM_ID_DOES_NOT_EXIST, id, project.getName());
            return null;
        }
        try {
            platformFactory = (JpaPlatformFactory)configElement.createExecutableExtension(FACTORY_CLASS_ATTRIBUTE_NAME);
        }
        catch (CoreException ex) {
            this.logFailedInstantiation(configElement, ex);
            throw new IllegalArgumentException(id);
        }
        return platformFactory.buildJpaPlatform(id);
    }

    private void logMissingAttribute(IConfigurationElement configElement, String attributeName) {
        this.log(JptCoreMessages.REGISTRY_MISSING_ATTRIBUTE, configElement.getName(), configElement.getContributor().getName(), attributeName);
    }

    private void logDuplicatePlatform(IConfigurationElement prevConfigElement, IConfigurationElement newConfigElement, String id) {
        this.log(JptCoreMessages.REGISTRY_DUPLICATE, prevConfigElement.getContributor().getName(), newConfigElement.getContributor().getName(), ID_ATTRIBUTE_NAME, PLATFORM_ELEMENT_NAME, id);
    }

    private void logFailedInstantiation(IConfigurationElement configElement, CoreException ex) {
        this.log(JptCoreMessages.REGISTRY_FAILED_INSTANTIATION, configElement.getAttribute(FACTORY_CLASS_ATTRIBUTE_NAME), configElement.getName(), configElement.getContributor().getName());
        JptCorePlugin.log(ex);
    }

    private void log(String msg, Object ... bindings) {
        JptCorePlugin.log(NLS.bind((String)msg, (Object[])bindings));
    }
}

