/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmColumnMapping;
import org.eclipse.jpt.core.context.orm.OrmConverter;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmVersionMapping;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.core.resource.orm.Attributes;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlColumn;
import org.eclipse.jpt.core.resource.orm.XmlConvertibleMapping;
import org.eclipse.jpt.core.resource.orm.XmlVersion;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmVersionMapping<T extends XmlVersion>
extends AbstractOrmAttributeMapping<T>
implements OrmVersionMapping {
    protected final OrmColumn column = this.getXmlContextNodeFactory().buildOrmColumn(this, this);
    protected OrmConverter converter;
    protected final OrmConverter nullConverter;

    protected AbstractOrmVersionMapping(OrmPersistentAttribute parent, T resourceMapping) {
        super(parent, resourceMapping);
        this.column.initialize(this.getResourceColumn());
        this.nullConverter = this.getXmlContextNodeFactory().buildOrmNullConverter(this);
        this.converter = this.buildConverter(this.getResourceConverterType());
    }

    @Override
    public int getXmlSequence() {
        return 30;
    }

    @Override
    public String getKey() {
        return "version";
    }

    @Override
    public void initializeOn(OrmAttributeMapping newMapping) {
        newMapping.initializeFromOrmVersionMapping(this);
    }

    @Override
    public void initializeFromOrmColumnMapping(OrmColumnMapping oldMapping) {
        super.initializeFromOrmColumnMapping(oldMapping);
        this.getColumn().initializeFrom(oldMapping.getColumn());
    }

    @Override
    public OrmColumn getColumn() {
        return this.column;
    }

    @Override
    public OrmConverter getConverter() {
        return this.converter;
    }

    protected String getConverterType() {
        return this.converter.getType();
    }

    @Override
    public void setConverter(String converterType) {
        if (this.valuesAreEqual(this.getConverterType(), converterType)) {
            return;
        }
        OrmConverter oldConverter = this.converter;
        OrmConverter newConverter = this.buildConverter(converterType);
        this.converter = this.nullConverter;
        if (oldConverter != null) {
            oldConverter.removeFromResourceModel();
        }
        this.converter = newConverter;
        if (newConverter != null) {
            newConverter.addToResourceModel();
        }
        this.firePropertyChanged("converter", oldConverter, newConverter);
    }

    protected void setConverter(OrmConverter newConverter) {
        OrmConverter oldConverter = this.converter;
        this.converter = newConverter;
        this.firePropertyChanged("converter", oldConverter, newConverter);
    }

    @Override
    public void addToResourceModel(Attributes resourceAttributes) {
        resourceAttributes.getVersions().add((Object)((XmlVersion)this.resourceAttributeMapping));
    }

    @Override
    public void removeFromResourceModel(Attributes resourceAttributes) {
        resourceAttributes.getVersions().remove((Object)this.resourceAttributeMapping);
    }

    @Override
    public String getDefaultColumnName() {
        return this.getName();
    }

    @Override
    public Table getDbTable(String tableName) {
        return this.getTypeMapping().getDbTable(tableName);
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getPrimaryTableName();
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return this.getTypeMapping().tableNameIsInvalid(tableName);
    }

    @Override
    public Iterator<String> candidateTableNames() {
        return this.getTypeMapping().associatedTableNamesIncludingInherited();
    }

    @Override
    public void update() {
        super.update();
        this.column.update(this.getResourceColumn());
        if (this.valuesAreEqual(this.getResourceConverterType(), this.getConverterType())) {
            this.getConverter().update();
        } else {
            this.setConverter(this.buildConverter(this.getResourceConverterType()));
        }
    }

    protected OrmConverter buildConverter(String converterType) {
        if (this.valuesAreEqual(converterType, "noConverter")) {
            return this.nullConverter;
        }
        if (this.valuesAreEqual(converterType, "temporalConverter")) {
            return this.getXmlContextNodeFactory().buildOrmTemporalConverter(this, (XmlConvertibleMapping)((Object)this.resourceAttributeMapping));
        }
        return null;
    }

    protected String getResourceConverterType() {
        if (((XmlVersion)this.resourceAttributeMapping).getTemporal() != null) {
            return "temporalConverter";
        }
        return "noConverter";
    }

    @Override
    public XmlColumn getResourceColumn() {
        return ((XmlVersion)this.resourceAttributeMapping).getColumn();
    }

    @Override
    public void addResourceColumn() {
        ((XmlVersion)this.resourceAttributeMapping).setColumn(OrmFactory.eINSTANCE.createXmlColumn());
    }

    @Override
    public void removeResourceColumn() {
        ((XmlVersion)this.resourceAttributeMapping).setColumn(null);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.getColumn().validate(messages, reporter);
    }

    @Override
    public IMessage buildUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
        if (this.isVirtual()) {
            return this.buildVirtualUnresolvedNameMessage(column, textRange);
        }
        return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
    }

    protected IMessage buildVirtualUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
        return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME", new String[]{this.getName(), column.getName(), column.getDbTable().getName()}, column, textRange);
    }

    @Override
    public IMessage buildTableNotValidMessage(BaseColumn column, TextRange textRange) {
        if (this.isVirtual()) {
            return this.buildVirtualTableNotValidMessage(column, textRange);
        }
        return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_TABLE_NOT_VALID", new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
    }

    public IMessage buildVirtualTableNotValidMessage(BaseColumn column, TextRange textRange) {
        return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_TABLE_NOT_VALID", new String[]{this.getName(), column.getTable(), column.getName(), JpaValidationDescriptionMessages.NOT_VALID_FOR_THIS_ENTITY}, column, textRange);
    }
}

