/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.facet.JpaFacetDataModelProperties;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public abstract class JpaFacetActionDelegate
implements IDelegate,
JpaFacetDataModelProperties {
    public final void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        monitor = this.nonNullMonitor(monitor);
        try {
            this.execute_(project, fv, config, monitor);
        }
        finally {
            monitor.done();
        }
    }

    protected void execute_(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 1);
        IDataModel dataModel = (IDataModel)config;
        JptCorePlugin.setJpaPlatformId(project, dataModel.getStringProperty("JpaFacetDataModelProperties.PLATFORM_ID"));
        JptCorePlugin.setConnectionProfileName(project, (String)dataModel.getProperty("JpaFacetDataModelProperties.CONNECTION"));
        if (dataModel.getBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG")) {
            JptCorePlugin.setUserOverrideDefaultCatalog(project, dataModel.getStringProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG"));
        }
        if (dataModel.getBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA")) {
            JptCorePlugin.setUserOverrideDefaultSchema(project, dataModel.getStringProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA"));
        }
        JptCorePlugin.setDiscoverAnnotatedClasses(project, dataModel.getBooleanProperty("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES"));
        JptCorePlugin.setDefaultJpaPlatformId(fv.getVersionString(), dataModel.getStringProperty("JpaFacetDataModelProperties.PLATFORM_ID"));
        ((LibraryInstallDelegate)dataModel.getProperty("JpaFacetDataModelProperties.LIBRARY_PROVIDER_DELEGATE")).execute((IProgressMonitor)new NullProgressMonitor());
        monitor.worked(1);
    }

    private IProgressMonitor nonNullMonitor(IProgressMonitor monitor) {
        return monitor != null ? monitor : new NullProgressMonitor();
    }
}

