/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.details;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.context.NamedNativeQuery;
import org.eclipse.jpt.core.context.NamedQuery;
import org.eclipse.jpt.core.context.Query;
import org.eclipse.jpt.core.context.QueryContainer;
import org.eclipse.jpt.ui.internal.details.AddQueryDialog;
import org.eclipse.jpt.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.jpt.ui.internal.details.NamedNativeQueryPropertyComposite;
import org.eclipse.jpt.ui.internal.details.NamedQueryPropertyComposite;
import org.eclipse.jpt.ui.internal.util.ControlSwitcher;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueriesComposite
extends Pane<QueryContainer> {
    private AddRemoveListPane<QueryContainer> listPane;
    private NamedNativeQueryPropertyComposite namedNativeQueryPane;
    private NamedQueryPropertyComposite<? extends NamedQuery> namedQueryPane;
    private WritablePropertyValueModel<Query> queryHolder;

    public QueriesComposite(Pane<?> parentPane, PropertyValueModel<? extends QueryContainer> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent, false);
    }

    private void addQuery() {
        this.addQueryFromDialog(this.buildAddQueryDialog());
    }

    protected AddQueryDialog buildAddQueryDialog() {
        return new AddQueryDialog(this.getShell());
    }

    protected void addQueryFromDialog(AddQueryDialog dialog) {
        NamedQuery query;
        if (dialog.open() != 0) {
            return;
        }
        String queryType = dialog.getQueryType();
        if (queryType == "namedQuery") {
            query = ((QueryContainer)this.getSubject()).addNamedQuery(((QueryContainer)this.getSubject()).namedQueriesSize());
        } else if (queryType == "namedNativeQuery") {
            query = ((QueryContainer)this.getSubject()).addNamedNativeQuery(((QueryContainer)this.getSubject()).namedNativeQueriesSize());
        } else {
            throw new IllegalArgumentException();
        }
        query.setName(dialog.getName());
        this.getQueryHolder().setValue((Object)query);
    }

    private ListValueModel<Query> buildDisplayableQueriesListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildQueriesListHolder(), new String[]{"name"});
    }

    private AddRemoveListPane<QueryContainer> addListPane(Composite container) {
        return new AddRemoveListPane<QueryContainer>(this, container, this.buildQueriesAdapter(), this.buildDisplayableQueriesListHolder(), this.getQueryHolder(), this.buildQueriesListLabelProvider(), "org.eclipse.jpt.ui.named_queries");
    }

    private ListValueModel<NamedNativeQuery> buildNamedNativeQueriesListHolder() {
        return new ListAspectAdapter<QueryContainer, NamedNativeQuery>(this.getSubjectHolder(), new String[]{"namedNativeQueries"}){

            protected ListIterator<NamedNativeQuery> listIterator_() {
                return ((QueryContainer)this.subject).namedNativeQueries();
            }

            protected int size_() {
                return ((QueryContainer)this.subject).namedNativeQueriesSize();
            }
        };
    }

    private PropertyValueModel<NamedNativeQuery> buildNamedNativeQueryHolder() {
        return new TransformationPropertyValueModel<Query, NamedNativeQuery>(this.getQueryHolder()){

            protected NamedNativeQuery transform_(Query value) {
                return value instanceof NamedNativeQuery ? (NamedNativeQuery)value : null;
            }
        };
    }

    private ListValueModel<NamedQuery> buildNamedQueriesListHolder() {
        return new ListAspectAdapter<QueryContainer, NamedQuery>(this.getSubjectHolder(), new String[]{"namedQueries"}){

            protected ListIterator<NamedQuery> listIterator_() {
                return ((QueryContainer)this.subject).namedQueries();
            }

            protected int size_() {
                return ((QueryContainer)this.subject).namedQueriesSize();
            }
        };
    }

    private PropertyValueModel<NamedQuery> buildNamedQueryHolder() {
        return new TransformationPropertyValueModel<Query, NamedQuery>(this.getQueryHolder()){

            protected NamedQuery transform_(Query value) {
                return value instanceof NamedQuery ? (NamedQuery)value : null;
            }
        };
    }

    private Transformer<Query, Control> buildPaneTransformer() {
        return new Transformer<Query, Control>(){

            public Control transform(Query query) {
                if (query == null) {
                    return null;
                }
                if (query instanceof NamedNativeQuery) {
                    return QueriesComposite.this.namedNativeQueryPane.getControl();
                }
                return QueriesComposite.this.namedQueryPane.getControl();
            }
        };
    }

    private AddRemovePane.Adapter buildQueriesAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                QueriesComposite.this.addQuery();
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof NamedQuery) {
                        ((QueryContainer)QueriesComposite.this.getSubject()).removeNamedQuery((NamedQuery)item);
                    } else {
                        ((QueryContainer)QueriesComposite.this.getSubject()).removeNamedNativeQuery((NamedNativeQuery)item);
                    }
                    ++n2;
                }
            }
        };
    }

    private ListValueModel<Query> buildQueriesListHolder() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.buildNamedQueriesListHolder());
        list.add(this.buildNamedNativeQueriesListHolder());
        return new CompositeListValueModel(list);
    }

    private ILabelProvider buildQueriesListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                Query query = (Query)element;
                String name = query.getName();
                if (name == null) {
                    int index = -1;
                    index = query instanceof NamedQuery ? CollectionTools.indexOf((Iterator)((QueryContainer)QueriesComposite.this.getSubject()).namedQueries(), (Object)query) : CollectionTools.indexOf((Iterator)((QueryContainer)QueriesComposite.this.getSubject()).namedNativeQueries(), (Object)query);
                    name = NLS.bind((String)JptUiDetailsMessages.QueriesComposite_displayString, (Object)index);
                }
                return name;
            }
        };
    }

    private WritablePropertyValueModel<Query> buildQueryHolder() {
        return new SimplePropertyValueModel();
    }

    @Override
    public void enableWidgets(boolean enabled) {
        super.enableWidgets(enabled);
        this.listPane.enableWidgets(enabled);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.queryHolder = this.buildQueryHolder();
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.listPane = this.addListPane(container);
        PageBook pageBook = new PageBook(container, 0);
        pageBook.setLayoutData((Object)new GridData(768));
        this.namedQueryPane = this.buildNamedQueryPropertyComposite(pageBook);
        this.namedNativeQueryPane = new NamedNativeQueryPropertyComposite((Pane<?>)this, (PropertyValueModel<? extends NamedNativeQuery>)this.buildNamedNativeQueryHolder(), (Composite)pageBook);
        this.installPaneSwitcher(pageBook);
    }

    protected NamedQueryPropertyComposite<? extends NamedQuery> buildNamedQueryPropertyComposite(PageBook pageBook) {
        return new NamedQueryPropertyComposite<NamedQuery>((Pane<?>)this, this.buildNamedQueryHolder(), (Composite)pageBook);
    }

    private void installPaneSwitcher(PageBook pageBook) {
        new ControlSwitcher(this.getQueryHolder(), this.buildPaneTransformer(), pageBook);
    }

    protected WritablePropertyValueModel<Query> getQueryHolder() {
        return this.queryHolder;
    }
}

