/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.utility.swt;

import java.util.HashSet;
import org.eclipse.jpt.ui.internal.utility.swt.BooleanStateController;
import org.eclipse.jpt.utility.internal.iterables.SnapshotCloneIterable;
import org.eclipse.jpt.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MultiControlBooleanStateController
extends BooleanStateController {
    private final CollectionValueModel<? extends Control> controlsModel;
    private final CollectionChangeListener controlsListener;
    private final HashSet<Control> controls = new HashSet();

    MultiControlBooleanStateController(PropertyValueModel<Boolean> booleanModel, CollectionValueModel<? extends Control> controlsModel, boolean defaultValue, BooleanStateController.Adapter adapter) {
        super(booleanModel, defaultValue, adapter);
        if (controlsModel == null) {
            throw new NullPointerException();
        }
        this.controlsModel = controlsModel;
        this.controlsListener = this.buildControlsListener();
        this.addControls((Iterable<? extends Control>)controlsModel);
    }

    private CollectionChangeListener buildControlsListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionAddEvent event) {
                MultiControlBooleanStateController.this.addControls(event.getItems());
            }

            public void itemsRemoved(CollectionRemoveEvent event) {
                MultiControlBooleanStateController.this.removeControls(event.getItems());
            }

            public void collectionCleared(CollectionClearEvent event) {
                MultiControlBooleanStateController.this.clearControls();
            }

            public void collectionChanged(CollectionChangeEvent event) {
                MultiControlBooleanStateController.this.clearControls();
                MultiControlBooleanStateController.this.addControls(event.getCollection());
            }

            public String toString() {
                return "controls listener";
            }
        };
    }

    @Override
    void setControlState(boolean b) {
        for (Control control : this.controls) {
            this.setControlState(control, b);
        }
    }

    void addControls(Iterable<? extends Control> controls_) {
        boolean b = this.getBooleanValue();
        for (Control control : controls_) {
            this.addControl(control, b);
        }
    }

    private void addControl(Control control, boolean b) {
        if (this.controls.isEmpty()) {
            this.engageBooleanModel();
            this.controlsModel.addCollectionChangeListener("values", this.controlsListener);
        }
        if (!this.controls.add(control)) {
            throw new IllegalArgumentException("duplicate control: " + control);
        }
        this.engageControl(control);
        this.setControlState(control, b);
    }

    void clearControls() {
        this.removeControls((Iterable<? extends Control>)new SnapshotCloneIterable(this.controls));
    }

    void removeControls(Iterable<? extends Control> controls_) {
        for (Control control : controls_) {
            this.disengageControl(control);
            this.removeControl(control);
        }
    }

    private void removeControl(Control control) {
        this.controls.remove(control);
        if (this.controls.isEmpty()) {
            this.controlsModel.removeCollectionChangeListener("values", this.controlsListener);
            this.disengageBooleanModel();
        }
    }

    @Override
    void controlDisposed(Control control) {
        super.controlDisposed(control);
        this.removeControl(control);
    }
}

