/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jpt.core.JpaResourceType;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.ui.JpaPlatformUi;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.details.JpaDetailsPage;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.platform.JpaPlatformUiRegistry;
import org.eclipse.jpt.ui.internal.selection.JpaSelection;
import org.eclipse.jpt.ui.internal.views.AbstractJpaView;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaDetailsView
extends AbstractJpaView {
    private JpaDetailsPage<JpaStructureNode> currentPage;
    private JpaSelection currentSelection;
    private Map<String, Map<JpaResourceType, Map<String, JpaDetailsPage<? extends JpaStructureNode>>>> detailsPages;

    public JpaDetailsView() {
        super(JptUiMessages.JpaDetailsView_viewNotAvailable);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.currentSelection = JpaSelection.NULL_SELECTION;
        this.detailsPages = new HashMap<String, Map<JpaResourceType, Map<String, JpaDetailsPage<? extends JpaStructureNode>>>>();
    }

    private JpaPlatformUi getJpaPlatformUi(JpaStructureNode structureNode) {
        String platformId = structureNode.getJpaProject().getJpaPlatform().getId();
        return JpaPlatformUiRegistry.instance().getJpaPlatformUi(platformId);
    }

    public JpaSelection getSelection() {
        return this.currentSelection;
    }

    private JpaDetailsPage<? extends JpaStructureNode> getDetailsPage(JpaStructureNode structureNode) {
        JpaDetailsPage<? extends JpaStructureNode> page;
        Map<JpaResourceType, Map<String, JpaDetailsPage<? extends JpaStructureNode>>> platformDetailsPages;
        Map<String, JpaDetailsPage<? extends JpaStructureNode>> contentTypeDetailsPages;
        String platformId = structureNode.getJpaProject().getJpaPlatform().getId();
        if (this.detailsPages.containsKey(platformId) && (contentTypeDetailsPages = (platformDetailsPages = this.detailsPages.get(platformId)).get(structureNode.getResourceType())) != null && (page = contentTypeDetailsPages.get(structureNode.getId())) != null) {
            if (page.getControl().isDisposed()) {
                platformDetailsPages.remove(structureNode.getId());
            } else {
                return page;
            }
        }
        return this.buildDetailsPage(structureNode);
    }

    private JpaDetailsPage<? extends JpaStructureNode> buildDetailsPage(JpaStructureNode structureNode) {
        JpaResourceType resourceType;
        Map<String, JpaDetailsPage<? extends JpaStructureNode>> contentTypeDetailsPages;
        JpaPlatformUi jpaPlatformUi = this.getJpaPlatformUi(structureNode);
        Composite container = this.getWidgetFactory().createComposite((Composite)this.getPageBook());
        container.setLayout((Layout)new FillLayout(256));
        JpaDetailsPage<? extends JpaStructureNode> page = jpaPlatformUi.buildJpaDetailsPage(container, structureNode, this.getWidgetFactory());
        if (page == null) {
            return null;
        }
        String platformId = structureNode.getJpaProject().getJpaPlatform().getId();
        Map<JpaResourceType, Map<String, JpaDetailsPage<? extends JpaStructureNode>>> platformDetailsPages = this.detailsPages.get(platformId);
        if (platformDetailsPages == null) {
            platformDetailsPages = new HashMap<JpaResourceType, Map<String, JpaDetailsPage<? extends JpaStructureNode>>>();
            this.detailsPages.put(platformId, platformDetailsPages);
        }
        if ((contentTypeDetailsPages = platformDetailsPages.get(resourceType = structureNode.getResourceType())) == null) {
            contentTypeDetailsPages = new HashMap<String, JpaDetailsPage<? extends JpaStructureNode>>();
            platformDetailsPages.put(resourceType, contentTypeDetailsPages);
        }
        contentTypeDetailsPages.put(structureNode.getId(), page);
        return page;
    }

    @Override
    public void select(JpaSelection jpaSelection) {
        if (jpaSelection.equals(this.currentSelection)) {
            return;
        }
        this.currentSelection = jpaSelection;
        if (jpaSelection == JpaSelection.NULL_SELECTION) {
            if (this.currentPage != null) {
                this.currentPage.setSubject(null);
                this.setCurrentPage(null);
            }
            return;
        }
        JpaStructureNode newNode = jpaSelection.getSelectedNode();
        JpaDetailsPage<JpaStructureNode> newPage = this.getDetailsPage(newNode);
        if (this.currentPage != null && this.currentPage != newPage) {
            try {
                this.currentPage.setSubject(null);
            }
            catch (Exception e) {
                JptUiPlugin.log(e);
            }
        }
        if (newPage != null) {
            try {
                newPage.setSubject(newNode);
            }
            catch (Exception e) {
                newPage = null;
                JptUiPlugin.log(e);
            }
        }
        this.setCurrentPage(newPage);
    }

    private void setCurrentPage(JpaDetailsPage<JpaStructureNode> newPage) {
        this.currentPage = newPage;
        if (newPage == null) {
            this.showDefaultPage();
        } else {
            this.showPage(newPage.getControl());
        }
    }

    public void dispose() {
        for (Map<JpaResourceType, Map<String, JpaDetailsPage<? extends JpaStructureNode>>> resourceTypeMap : this.detailsPages.values()) {
            for (Map<String, JpaDetailsPage<? extends JpaStructureNode>> detailsPageMap : resourceTypeMap.values()) {
                for (JpaDetailsPage<? extends JpaStructureNode> detailsPage : detailsPageMap.values()) {
                    detailsPage.dispose();
                }
            }
        }
        this.detailsPages.clear();
        this.currentSelection = JpaSelection.NULL_SELECTION;
        this.currentPage = null;
        super.dispose();
    }
}

