/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.jsfappconfig;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jst.jsf.core.jsfappconfig.IJSFAppConfigLocater;
import org.eclipse.jst.jsf.core.jsfappconfig.IJSFAppConfigProvider;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJSFAppConfigLocater
implements IJSFAppConfigLocater {
    protected JSFAppConfigManager manager = null;
    private IJSFAppConfigManager _manager;
    protected Set configProviders = new LinkedHashSet();

    @Override
    public void setJSFAppConfigManager(IJSFAppConfigManager manager) {
        this._manager = manager;
    }

    @Override
    public IJSFAppConfigManager getJSFAppConfigManager() {
        return this._manager;
    }

    @Override
    public abstract void startLocating();

    @Override
    public abstract void stopLocating();

    @Override
    public Set<IJSFAppConfigProvider> getJSFAppConfigProviders() {
        return this.configProviders;
    }

    protected boolean addConfigProvider(IJSFAppConfigProvider configProvider) {
        boolean added = this.configProviders.add(configProvider);
        if (added && this.getJSFAppConfigManager() != null) {
            configProvider.setJSFAppConfigLocater(this);
            this.getJSFAppConfigManager().notifyJSFAppConfigProvidersChangeListeners(configProvider, 1);
        }
        return added;
    }

    protected boolean removeConfigProvider(IJSFAppConfigProvider configProvider) {
        boolean removed;
        if (configProvider != null) {
            configProvider.releaseFacesConfigModel();
        }
        if ((removed = this.configProviders.remove(configProvider)) && this.getJSFAppConfigManager() != null) {
            this.getJSFAppConfigManager().notifyJSFAppConfigProvidersChangeListeners(configProvider, 2);
        }
        return removed;
    }

    protected void updateConfigProviders(Set newConfigProviders) {
        if (newConfigProviders != null) {
            LinkedHashSet<IJSFAppConfigProvider> oldConfigProviders = new LinkedHashSet<IJSFAppConfigProvider>();
            for (IJSFAppConfigProvider configProvider : this.configProviders) {
                if (newConfigProviders.remove(configProvider)) continue;
                oldConfigProviders.add(configProvider);
            }
            for (IJSFAppConfigProvider configProvider : oldConfigProviders) {
                this.removeConfigProvider(configProvider);
            }
            for (IJSFAppConfigProvider configProvider : newConfigProviders) {
                this.addConfigProvider(configProvider);
            }
        }
    }

    protected void removeAllConfigProviders() {
        this.updateConfigProviders(Collections.EMPTY_SET);
    }

    @Override
    public void dispose() {
        this.removeAllConfigProviders();
    }
}

