/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.jsf.facelet.core.internal.cm.addtagmd.ElementData;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.PaletteInfo;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.PaletteInfos;

public class TagMetadataLoader {
    private static final String PALETTE_INFOS = "paletteInfos";
    private static final String TRAIT_DISPLAY_NAME = "displayName";
    private static final String TRAIT_DESCRIPTION = "description";
    private static final String TRAIT_ADDITIONALELEMENTDATA = "additionalElementData";
    private final IProject _project;

    public TagMetadataLoader(IProject project) {
        this._project = project;
    }

    public String getDisplayName(String nsUri, String tagName) {
        return this.getString(nsUri, tagName, TRAIT_DISPLAY_NAME);
    }

    public String getDescription(String nsUri, String tagName) {
        return this.getString(nsUri, tagName, TRAIT_DESCRIPTION);
    }

    public ElementData getElementData(String nsUri, String tagName) {
        EObject value;
        Trait trait;
        ITaglibDomainMetaDataModelContext modelContext = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)this._project, (String)nsUri);
        Entity entity = TaglibDomainMetaDataQueryHelper.getEntity((ITaglibDomainMetaDataModelContext)modelContext, (String)tagName);
        if (entity != null && (trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)entity, (String)TRAIT_ADDITIONALELEMENTDATA)) != null && (value = trait.getValue()) instanceof ElementData) {
            return (ElementData)value;
        }
        return null;
    }

    private String getString(String nsUri, String tagName, String key) {
        String value = null;
        Model model = this.getModel(nsUri);
        if (model != null) {
            value = this.getString(key, model, tagName);
        }
        return value;
    }

    private String getString(String key, Model model, String tagName) {
        String value = null;
        Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)model, (String)PALETTE_INFOS);
        if (trait != null) {
            PaletteInfos tags = (PaletteInfos)trait.getValue();
            for (PaletteInfo tag : tags.getInfos()) {
                Object strValue;
                EStructuralFeature feature;
                if (!tag.getId().equalsIgnoreCase(tagName) || (feature = tag.eClass().getEStructuralFeature(key)) == null || !tag.eIsSet(feature) || !((strValue = tag.eGet(feature)) instanceof String)) continue;
                value = (String)strValue;
            }
        }
        return value;
    }

    private Model getModel(String nsUri) {
        ITaglibDomainMetaDataModelContext modelContext = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)this._project, (String)nsUri);
        Model model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)modelContext);
        return model;
    }
}

