/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.object;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;

public class ValidationMessageViewerWidget
extends SimpleWidgetDataContributor {
    private int DEFAULT_TABLE_HEIGHT_HINT = 100;
    private TableViewer tableViewer_;
    private Table table_;
    private String message = null;
    static final String[] columns_ = new String[]{ConsumptionUIMessages.TABLE_COLUMN_VALIDATION_SEVERITY, ConsumptionUIMessages.TABLE_COLUMN_VALIDATION_LINE, ConsumptionUIMessages.TABLE_COLUMN_VALIDATION_COLUMN, ConsumptionUIMessages.TABLE_COLUMN_VALIDATION_MESSAGE};
    static final int[] columnsWidth_ = new int[]{12, 10, 10, 60};
    static final int[] columnMins_ = new int[]{60, 50, 50, 300};

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        Text messageLabel = new Text(composite, 8);
        messageLabel.setText(ConsumptionUIMessages.LABEL_VALIDATE_MESSAGES);
        GridData gd = new GridData(256);
        messageLabel.setLayoutData((Object)gd);
        messageLabel.setToolTipText(ConsumptionUIMessages.TOOLTIP_VALIDATE_TEXT_MESSAGE);
        this.table_ = new Table(composite, 67588);
        gd = new GridData(1808);
        gd.heightHint = this.DEFAULT_TABLE_HEIGHT_HINT;
        this.table_.setLayoutData((Object)gd);
        this.table_.setHeaderVisible(true);
        this.table_.setLinesVisible(true);
        this.table_.setToolTipText(ConsumptionUIMessages.TOOLTIP_TABLE_VALIDATE_MESSAGE);
        TableLayout tableLayout = new TableLayout();
        int i = 0;
        while (i < columns_.length) {
            TableColumn tableColumn = new TableColumn(this.table_, 0);
            tableColumn.setText(columns_[i]);
            tableColumn.pack();
            ColumnWeightData columnData = new ColumnWeightData(columnsWidth_[i], columnMins_[i], true);
            tableLayout.addColumnData((ColumnLayoutData)columnData);
            ++i;
        }
        this.table_.setLayout((Layout)tableLayout);
        this.tableViewer_ = new TableViewer(this.table_);
        this.tableViewer_.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer_.setLabelProvider((IBaseLabelProvider)new ListLabelProvider());
        return this;
    }

    public void setInput(IValidationMessage[] messages) {
        this.tableViewer_.setInput((Object)messages);
        this.tableViewer_.refresh();
    }

    public void clearInput() {
        IValidationMessage[] emptyMessages = new IValidationMessage[]{};
        this.setInput(emptyMessages);
    }

    public IContentProvider getContentProvider() {
        return this.tableViewer_.getContentProvider();
    }

    public IStatus getStatus() {
        return this.message == null ? Status.OK_STATUS : StatusUtils.errorStatus((String)this.message);
    }

    public void refresh() {
        this.tableViewer_.refresh();
    }

    public TableItem[] getItems() {
        return this.table_.getItems();
    }

    public void setEnabled(boolean enabled) {
    }

    public void dispose() {
        if (this.table_ != null) {
            this.table_.dispose();
        }
    }

    protected class ListContentProvider
    implements IStructuredContentProvider {
        protected ListContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            ValidationMessageViewerWidget.this.tableViewer_.add(this.getElements(newInput));
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IValidationMessage[]) {
                Object[] valMessages = (IValidationMessage[])inputElement;
                return valMessages;
            }
            return new Object[0];
        }
    }

    protected class ListLabelProvider
    implements ITableLabelProvider {
        protected ListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof IValidationMessage) {
                IValidationMessage msg = (IValidationMessage)element;
                if (columnIndex == 0) {
                    int severity = msg.getSeverity();
                    if (severity == 0) {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                    }
                    if (severity == 1) {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                    }
                    if (severity == 2) {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = "";
            if (element instanceof IValidationMessage) {
                IValidationMessage msg = (IValidationMessage)element;
                switch (columnIndex) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        text = new Integer(msg.getLine()).toString();
                        break;
                    }
                    case 2: {
                        text = new Integer(msg.getColumn()).toString();
                        break;
                    }
                    case 3: {
                        text = msg.getMessage();
                        break;
                    }
                }
            }
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void dispose() {
        }
    }
}

