/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.object;

import java.net.MalformedURLException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsclient.internal.impl.ServiceRefImpl;
import org.eclipse.jst.j2ee.webservice.wsdd.BeanLink;
import org.eclipse.jst.j2ee.webservice.wsdd.ServiceImplBean;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.ws.internal.common.J2EEActionAdapterFactory;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.wst.command.internal.env.core.data.Transformer;
import org.eclipse.wst.ws.internal.converter.IIFile2UriConverter;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.ws.internal.ui.utils.AdapterUtils;
import org.eclipse.wst.ws.internal.wsfinder.WSDLURLStringWrapper;
import org.eclipse.wst.wsdl.internal.impl.ServiceImpl;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;

public class WSDLSelectionTransformer
implements Transformer {
    public Object transform(Object value) {
        IStructuredSelection selection;
        if (value instanceof IStructuredSelection && (selection = (IStructuredSelection)value) != null && !selection.isEmpty()) {
            Object sel = selection.getFirstElement();
            if (sel instanceof IResource) {
                try {
                    if (sel instanceof IFile) {
                        String wsdlUrl;
                        IFile file = (IFile)sel;
                        IIFile2UriConverter converter = WSPlugin.getInstance().getIFile2UriConverter();
                        if (!(converter == null || (wsdlUrl = converter.convert(file)) == null && converter.allowBaseConversionOnFailure())) {
                            return new StructuredSelection((Object)wsdlUrl);
                        }
                    }
                    return new StructuredSelection((Object)((IResource)sel).getLocation().toFile().toURL().toString());
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                if (Platform.getAdapterManager().hasAdapter(sel, WSDLURLStringWrapper.class.getName())) {
                    Object adaptedObject = Platform.getAdapterManager().loadAdapter(sel, WSDLURLStringWrapper.class.getName());
                    WSDLURLStringWrapper wrapper = (WSDLURLStringWrapper)adaptedObject;
                    return new StructuredSelection((Object)wrapper.getWSDLURLString());
                }
                if (sel instanceof ServiceImpl) {
                    return new StructuredSelection((Object)J2EEActionAdapterFactory.getWSDLURI((ServiceImpl)((ServiceImpl)sel)));
                }
                if (sel instanceof ServiceRefImpl) {
                    return new StructuredSelection((Object)J2EEActionAdapterFactory.getWSDLURI((ServiceRef)((ServiceRefImpl)sel)));
                }
                if (sel instanceof WSDLResourceImpl) {
                    return new StructuredSelection((Object)J2EEActionAdapterFactory.getWSDLURI((WSDLResourceImpl)((WSDLResourceImpl)sel)));
                }
                if (sel instanceof ServiceImplBean) {
                    return new StructuredSelection((Object)this.getWSDLURI((ServiceImplBean)sel));
                }
                if (sel instanceof BeanLink) {
                    return new StructuredSelection((Object)this.getWSDLURI((BeanLink)sel));
                }
                String wsdlURI = AdapterUtils.getAdaptedWSDL((Object)sel);
                if (wsdlURI != null) {
                    return new StructuredSelection((Object)wsdlURI);
                }
            }
        }
        return value;
    }

    private String getWSDLURI(ServiceImplBean bean) {
        EObject eObject = bean.eContainer();
        if (eObject == null) {
            return "";
        }
        if ((eObject = eObject.eContainer()) instanceof WebServiceDescription) {
            WebServiceDescription wsd = (WebServiceDescription)eObject;
            IProject project = ProjectUtilities.getProject((EObject)wsd);
            IPath path = J2EEUtils.getWebContentPath((IProject)project);
            path = path.append(wsd.getWsdlFile());
            return path.toString();
        }
        return "";
    }

    private String getWSDLURI(BeanLink link) {
        EObject eObject = link.eContainer();
        if (eObject instanceof ServiceImplBean) {
            return this.getWSDLURI((ServiceImplBean)eObject);
        }
        return "";
    }
}

