/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.JoiningStrategy;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.RelationshipReference;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.context.orm.OrmAssociationOverride;
import org.eclipse.jpt.core.context.orm.OrmAssociationOverrideContainer;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAssociationOverride;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmAssociationOverrideContainer
extends AbstractOrmXmlContextNode
implements OrmAssociationOverrideContainer {
    protected final List<OrmAssociationOverride> specifiedAssociationOverrides;
    protected final List<OrmAssociationOverride> virtualAssociationOverrides;
    protected final OrmAssociationOverrideContainer.Owner owner;

    public GenericOrmAssociationOverrideContainer(XmlContextNode parent, OrmAssociationOverrideContainer.Owner owner) {
        super(parent);
        this.owner = owner;
        this.specifiedAssociationOverrides = new ArrayList<OrmAssociationOverride>();
        this.virtualAssociationOverrides = new ArrayList<OrmAssociationOverride>();
        this.initializeSpecifiedAssociationOverrides();
        this.initializeVirtualAssociationOverrides();
    }

    protected OrmAssociationOverrideContainer.Owner getOwner() {
        return this.owner;
    }

    protected EList<XmlAssociationOverride> getResourceAssociationOverrides() {
        return this.getOwner().getResourceAssociationOverrides();
    }

    @Override
    public ListIterator<OrmAssociationOverride> associationOverrides() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAssociationOverrides(), this.virtualAssociationOverrides()});
    }

    @Override
    public int associationOverridesSize() {
        return this.specifiedAssociationOverridesSize() + this.virtualAssociationOverridesSize();
    }

    @Override
    public ListIterator<OrmAssociationOverride> virtualAssociationOverrides() {
        return new CloneListIterator(this.virtualAssociationOverrides);
    }

    @Override
    public int virtualAssociationOverridesSize() {
        return this.virtualAssociationOverrides.size();
    }

    protected void addVirtualAssociationOverride(OrmAssociationOverride associationOverride) {
        this.addItemToList(associationOverride, this.virtualAssociationOverrides, "virtualAssociationOverrides");
    }

    protected void removeVirtualAssociationOverride(OrmAssociationOverride associationOverride) {
        this.removeItemFromList(associationOverride, this.virtualAssociationOverrides, "virtualAssociationOverrides");
    }

    protected OrmAssociationOverride setAssociationOverrideVirtual(boolean virtual, OrmAssociationOverride associationOverride) {
        if (virtual) {
            return this.setAssociationOverrideVirtual(associationOverride);
        }
        return this.setAssociationOverrideSpecified(associationOverride);
    }

    protected OrmAssociationOverride setAssociationOverrideVirtual(OrmAssociationOverride associationOverride) {
        int index = this.specifiedAssociationOverrides.indexOf(associationOverride);
        this.specifiedAssociationOverrides.remove(index);
        String associationOverrideName = associationOverride.getName();
        OrmAssociationOverride virtualAssociationOverride = null;
        if (associationOverrideName != null) {
            for (String name : CollectionTools.iterable(this.allOverridableAssociationNames())) {
                if (!name.equals(associationOverrideName)) continue;
                virtualAssociationOverride = this.buildVirtualAssociationOverride(name);
                this.virtualAssociationOverrides.add(virtualAssociationOverride);
            }
        }
        this.getResourceAssociationOverrides().remove(index);
        this.fireItemRemoved("specifiedAssociationOverrides", index, associationOverride);
        if (virtualAssociationOverride != null) {
            this.fireItemAdded("virtualAssociationOverrides", this.virtualAssociationOverridesSize() - 1, virtualAssociationOverride);
        }
        return virtualAssociationOverride;
    }

    protected OrmAssociationOverride setAssociationOverrideSpecified(OrmAssociationOverride oldAssociationOverride) {
        int index = this.specifiedAssociationOverridesSize();
        XmlAssociationOverride xmlAssociationOverride = this.buildResourceAssociationOverride();
        OrmAssociationOverride newAssociationOverride = this.buildAssociationOverride(xmlAssociationOverride);
        this.specifiedAssociationOverrides.add(index, newAssociationOverride);
        this.getResourceAssociationOverrides().add((Object)xmlAssociationOverride);
        int defaultIndex = this.virtualAssociationOverrides.indexOf(oldAssociationOverride);
        this.virtualAssociationOverrides.remove(defaultIndex);
        newAssociationOverride.initializeFrom(oldAssociationOverride);
        this.fireItemRemoved("virtualAssociationOverrides", defaultIndex, oldAssociationOverride);
        this.fireItemAdded("specifiedAssociationOverrides", index, newAssociationOverride);
        return newAssociationOverride;
    }

    @Override
    public ListIterator<OrmAssociationOverride> specifiedAssociationOverrides() {
        return new CloneListIterator(this.specifiedAssociationOverrides);
    }

    @Override
    public int specifiedAssociationOverridesSize() {
        return this.specifiedAssociationOverrides.size();
    }

    protected void addSpecifiedAssociationOverride(int index, OrmAssociationOverride associationOverride) {
        this.addItemToList(index, associationOverride, this.specifiedAssociationOverrides, "specifiedAssociationOverrides");
    }

    protected void addSpecifiedAssociationOverride(OrmAssociationOverride associationOverride) {
        this.addSpecifiedAssociationOverride(this.specifiedAssociationOverrides.size(), associationOverride);
    }

    protected void removeSpecifiedAssociationOverride_(OrmAssociationOverride associationOverride) {
        this.removeItemFromList(associationOverride, this.specifiedAssociationOverrides, "specifiedAssociationOverrides");
    }

    @Override
    public void moveSpecifiedAssociationOverride(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedAssociationOverrides, (int)targetIndex, (int)sourceIndex);
        this.getResourceAssociationOverrides().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedAssociationOverrides", targetIndex, sourceIndex);
    }

    @Override
    public OrmAssociationOverride getAssociationOverrideNamed(String name) {
        return (OrmAssociationOverride)this.getOverrideNamed(name, this.associationOverrides());
    }

    public boolean containsAssociationOverride(String name) {
        return this.containsOverride(name, this.associationOverrides());
    }

    public boolean containsSpecifiedAssociationOverride(String name) {
        return this.containsOverride(name, this.specifiedAssociationOverrides());
    }

    public boolean containsDefaultAssociationOverride(String name) {
        return this.containsOverride(name, this.virtualAssociationOverrides());
    }

    private BaseOverride getOverrideNamed(String name, ListIterator<? extends BaseOverride> overrides) {
        for (BaseOverride override : CollectionTools.iterable(overrides)) {
            String overrideName = override.getName();
            if (overrideName == null && name == null) {
                return override;
            }
            if (overrideName == null || !overrideName.equals(name)) continue;
            return override;
        }
        return null;
    }

    private boolean containsOverride(String name, ListIterator<? extends BaseOverride> overrides) {
        return this.getOverrideNamed(name, overrides) != null;
    }

    protected Iterator<String> allOverridableAssociationNames() {
        return this.getOwner().allOverridableNames();
    }

    protected void initializeVirtualAssociationOverrides() {
        for (String name : CollectionTools.iterable(this.allOverridableAssociationNames())) {
            OrmAssociationOverride ormAssociationOverride = this.getAssociationOverrideNamed(name);
            if (ormAssociationOverride != null) continue;
            this.virtualAssociationOverrides.add(this.buildVirtualAssociationOverride(name));
        }
    }

    protected OrmAssociationOverride buildVirtualAssociationOverride(String name) {
        return this.buildAssociationOverride(this.buildVirtualXmlAssociationOverride(name));
    }

    protected XmlAssociationOverride buildVirtualXmlAssociationOverride(String name) {
        RelationshipReference relationshipReference = this.resolveAssociationOverrideRelationshipReference(name);
        return this.buildVirtualXmlAssociationOverride(name, relationshipReference.getPredominantJoiningStrategy());
    }

    protected XmlAssociationOverride buildVirtualXmlAssociationOverride(String name, JoiningStrategy joiningStrategy) {
        return this.getXmlContextNodeFactory().buildVirtualXmlAssociationOverride(name, (OrmTypeMapping)this.getOwner().getTypeMapping(), joiningStrategy);
    }

    private RelationshipReference resolveAssociationOverrideRelationshipReference(String associationOverrideName) {
        return this.getOwner().resolveRelationshipReference(associationOverrideName);
    }

    protected void initializeSpecifiedAssociationOverrides() {
        for (XmlAssociationOverride associationOverride : this.getResourceAssociationOverrides()) {
            this.specifiedAssociationOverrides.add(this.buildAssociationOverride(associationOverride));
        }
    }

    @Override
    public void update() {
        this.updateSpecifiedAssociationOverrides();
        this.updateVirtualAssociationOverrides();
    }

    protected void updateSpecifiedAssociationOverrides() {
        CloneIterator xmlOverrides = new CloneIterator(this.getResourceAssociationOverrides());
        ListIterator<OrmAssociationOverride> contextOverrides = this.specifiedAssociationOverrides();
        while (contextOverrides.hasNext()) {
            OrmAssociationOverride contextOverride = (OrmAssociationOverride)contextOverrides.next();
            if (xmlOverrides.hasNext()) {
                contextOverride.update((XmlAssociationOverride)xmlOverrides.next());
                continue;
            }
            this.removeSpecifiedAssociationOverride_(contextOverride);
        }
        while (xmlOverrides.hasNext()) {
            this.addSpecifiedAssociationOverride(this.buildAssociationOverride((XmlAssociationOverride)xmlOverrides.next()));
        }
    }

    protected void updateVirtualAssociationOverrides() {
        Iterator<String> overridableAssociations = this.allOverridableAssociationNames();
        ListIterator<OrmAssociationOverride> virtualAssociationOverridesCopy = this.virtualAssociationOverrides();
        for (String name : CollectionTools.iterable(overridableAssociations)) {
            OrmAssociationOverride ormAssociationOverride = this.getAssociationOverrideNamed(name);
            if (ormAssociationOverride != null && !ormAssociationOverride.isVirtual()) continue;
            if (ormAssociationOverride != null) {
                if (virtualAssociationOverridesCopy.hasNext()) {
                    OrmAssociationOverride virtualAssociationOverride = virtualAssociationOverridesCopy.next();
                    virtualAssociationOverride.update(this.buildVirtualXmlAssociationOverride(name));
                    continue;
                }
                this.addVirtualAssociationOverride(this.buildVirtualAssociationOverride(name));
                continue;
            }
            this.addVirtualAssociationOverride(this.buildVirtualAssociationOverride(name));
        }
        for (OrmAssociationOverride virtualAssociationOverride : CollectionTools.iterable(virtualAssociationOverridesCopy)) {
            this.removeVirtualAssociationOverride(virtualAssociationOverride);
        }
    }

    protected OrmAssociationOverride buildAssociationOverride(XmlAssociationOverride associationOverride) {
        return this.getXmlContextNodeFactory().buildOrmAssociationOverride(this, this.buildAssociationOverrideOwner(), associationOverride);
    }

    protected XmlAssociationOverride buildResourceAssociationOverride() {
        return OrmFactory.eINSTANCE.createXmlAssociationOverride();
    }

    protected AssociationOverride.Owner buildAssociationOverrideOwner() {
        return new AssociationOverrideOwner();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        ListIterator<OrmAssociationOverride> stream = this.associationOverrides();
        while (stream.hasNext()) {
            ((OrmAssociationOverride)stream.next()).validate(messages, reporter);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getOwner().getValidationTextRange();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AssociationOverrideOwner
    implements AssociationOverride.Owner {
        protected AssociationOverrideOwner() {
        }

        @Override
        public RelationshipMapping getRelationshipMapping(String attributeName) {
            return MappingTools.getRelationshipMapping(attributeName, GenericOrmAssociationOverrideContainer.this.getOwner().getOverridableTypeMapping());
        }

        @Override
        public boolean isVirtual(BaseOverride override) {
            return GenericOrmAssociationOverrideContainer.this.virtualAssociationOverrides.contains(override);
        }

        @Override
        public BaseOverride setVirtual(boolean virtual, BaseOverride override) {
            return GenericOrmAssociationOverrideContainer.this.setAssociationOverrideVirtual(virtual, (OrmAssociationOverride)override);
        }

        @Override
        public TypeMapping getTypeMapping() {
            return GenericOrmAssociationOverrideContainer.this.getOwner().getTypeMapping();
        }

        @Override
        public Iterator<String> allOverridableAttributeNames() {
            return GenericOrmAssociationOverrideContainer.this.allOverridableAssociationNames();
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return GenericOrmAssociationOverrideContainer.this.getOwner().tableNameIsInvalid(tableName);
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return GenericOrmAssociationOverrideContainer.this.getOwner().candidateTableNames();
        }

        @Override
        public String getDefaultTableName() {
            return GenericOrmAssociationOverrideContainer.this.getOwner().getDefaultTableName();
        }

        @Override
        public Table getDbTable(String tableName) {
            return GenericOrmAssociationOverrideContainer.this.getOwner().getDbTable(tableName);
        }

        @Override
        public IMessage buildColumnTableNotValidMessage(BaseOverride override, BaseColumn column, TextRange textRange) {
            return GenericOrmAssociationOverrideContainer.this.getOwner().buildColumnTableNotValidMessage(override, column, textRange);
        }

        @Override
        public IMessage buildColumnUnresolvedNameMessage(BaseOverride override, NamedColumn column, TextRange textRange) {
            return GenericOrmAssociationOverrideContainer.this.getOwner().buildColumnUnresolvedNameMessage(override, column, textRange);
        }

        @Override
        public IMessage buildColumnUnresolvedReferencedColumnNameMessage(AssociationOverride override, BaseJoinColumn column, TextRange textRange) {
            return GenericOrmAssociationOverrideContainer.this.getOwner().buildColumnUnresolvedReferencedColumnNameMessage(override, column, textRange);
        }

        @Override
        public IMessage buildUnspecifiedNameMultipleJoinColumnsMessage(AssociationOverride override, BaseJoinColumn column, TextRange textRange) {
            return GenericOrmAssociationOverrideContainer.this.getOwner().buildUnspecifiedNameMultipleJoinColumnsMessage(override, column, textRange);
        }

        @Override
        public IMessage buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(AssociationOverride override, BaseJoinColumn column, TextRange textRange) {
            return GenericOrmAssociationOverrideContainer.this.getOwner().buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(override, column, textRange);
        }
    }
}

