/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jpt.core.JpaAnnotationProvider;
import org.eclipse.jpt.core.JpaResourceModelListener;
import org.eclipse.jpt.core.JpaResourceType;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.resource.java.source.SourceNode;
import org.eclipse.jpt.core.internal.resource.java.source.SourcePersistentType;
import org.eclipse.jpt.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.utility.CommandExecutor;
import org.eclipse.jpt.utility.internal.ListenerList;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceCompilationUnit
extends SourceNode
implements JavaResourceCompilationUnit {
    private final ICompilationUnit compilationUnit;
    private final JpaAnnotationProvider annotationProvider;
    private final AnnotationEditFormatter annotationEditFormatter;
    private final CommandExecutor modifySharedDocumentCommandExecutor;
    private final ListenerList<JpaResourceModelListener> resourceModelListenerList;
    private JavaResourcePersistentType persistentType;

    public SourceCompilationUnit(ICompilationUnit compilationUnit, JpaAnnotationProvider annotationProvider, AnnotationEditFormatter annotationEditFormatter, CommandExecutor modifySharedDocumentCommandExecutor) {
        super(null);
        this.compilationUnit = compilationUnit;
        this.annotationProvider = annotationProvider;
        this.annotationEditFormatter = annotationEditFormatter;
        this.modifySharedDocumentCommandExecutor = modifySharedDocumentCommandExecutor;
        this.resourceModelListenerList = new ListenerList(JpaResourceModelListener.class);
        this.persistentType = this.buildPersistentType();
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
    }

    private JavaResourcePersistentType buildPersistentType() {
        this.openCompilationUnit();
        CompilationUnit astRoot = this.buildASTRoot();
        this.closeCompilationUnit();
        return this.buildPersistentType(astRoot);
    }

    private void openCompilationUnit() {
        try {
            this.compilationUnit.open(null);
        }
        catch (JavaModelException javaModelException) {}
    }

    private void closeCompilationUnit() {
        try {
            this.compilationUnit.close();
        }
        catch (JavaModelException javaModelException) {}
    }

    @Override
    protected boolean requiresParent() {
        return false;
    }

    @Override
    public JavaResourceCompilationUnit getRoot() {
        return this;
    }

    @Override
    public IFile getFile() {
        return (IFile)this.compilationUnit.getResource();
    }

    @Override
    public JpaAnnotationProvider getAnnotationProvider() {
        return this.annotationProvider;
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncPersistentType(astRoot);
    }

    @Override
    public TextRange getTextRange(CompilationUnit astRoot) {
        return null;
    }

    @Override
    public Iterator<JavaResourcePersistentType> persistentTypes() {
        return this.persistentType == null ? EmptyIterator.instance() : this.persistentType.allTypes();
    }

    @Override
    public void resourceModelChanged() {
        for (JpaResourceModelListener listener : this.resourceModelListenerList.getListeners()) {
            listener.resourceModelChanged(this);
        }
    }

    @Override
    public ICompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    @Override
    public void resolveTypes() {
        if (this.persistentType != null) {
            this.persistentType.resolveTypes(this.buildASTRoot());
        }
    }

    @Override
    public CommandExecutor getModifySharedDocumentCommandExecutor() {
        return this.modifySharedDocumentCommandExecutor;
    }

    @Override
    public AnnotationEditFormatter getAnnotationEditFormatter() {
        return this.annotationEditFormatter;
    }

    @Override
    public CompilationUnit buildASTRoot() {
        return ASTTools.buildASTRoot(this.compilationUnit);
    }

    private JavaResourcePersistentType buildPersistentType(CompilationUnit astRoot) {
        TypeDeclaration td = this.getPrimaryTypeDeclaration(astRoot);
        return td == null ? null : this.buildPersistentType(astRoot, td);
    }

    private void syncPersistentType(CompilationUnit astRoot) {
        TypeDeclaration td = this.getPrimaryTypeDeclaration(astRoot);
        if (td == null) {
            this.syncPersistentType_(null);
        } else if (this.persistentType == null) {
            this.syncPersistentType_(this.buildPersistentType(astRoot, td));
        } else {
            this.persistentType.synchronizeWith(astRoot);
        }
    }

    private void syncPersistentType_(JavaResourcePersistentType astPersistentType) {
        JavaResourcePersistentType old = this.persistentType;
        this.persistentType = astPersistentType;
        this.firePropertyChanged("persistentTypes", old, astPersistentType);
    }

    @Override
    public JpaResourceType getResourceType() {
        return JptCorePlugin.JAVA_SOURCE_RESOURCE_TYPE;
    }

    @Override
    public void addResourceModelListener(JpaResourceModelListener listener) {
        this.resourceModelListenerList.add((EventListener)listener);
    }

    @Override
    public void removeResourceModelListener(JpaResourceModelListener listener) {
        this.resourceModelListenerList.remove((EventListener)listener);
    }

    @Override
    public void synchronizeWithJavaSource() {
        this.synchronizeWith(this.buildASTRoot());
    }

    private JavaResourcePersistentType buildPersistentType(CompilationUnit astRoot, TypeDeclaration typeDeclaration) {
        return SourcePersistentType.newInstance(this, typeDeclaration, astRoot);
    }

    private TypeDeclaration getPrimaryTypeDeclaration(CompilationUnit astRoot) {
        String primaryTypeName = this.getPrimaryTypeName();
        for (AbstractTypeDeclaration atd : this.types(astRoot)) {
            if (!this.nodeIsPrimaryTypeDeclaration(atd, primaryTypeName)) continue;
            return atd.resolveBinding() == null ? null : (TypeDeclaration)atd;
        }
        return null;
    }

    private boolean nodeIsPrimaryTypeDeclaration(AbstractTypeDeclaration atd, String primaryTypeName) {
        return atd.getNodeType() == 55 && atd.getName().getFullyQualifiedName().equals(primaryTypeName);
    }

    private List<AbstractTypeDeclaration> types(CompilationUnit astRoot) {
        return astRoot.types();
    }

    private String getPrimaryTypeName() {
        return this.removeJavaExtension(this.compilationUnit.getElementName());
    }

    private String removeJavaExtension(String fileName) {
        int index = fileName.lastIndexOf(".java");
        return index == -1 ? fileName : fileName.substring(0, index);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getPrimaryTypeName());
    }
}

