/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.core.internal.resource.java.source.SourceBaseTableAnnotation;
import org.eclipse.jpt.core.internal.resource.java.source.SourceJoinColumnAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.AnnotationContainer;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JoinTableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableJoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.NestableJoinTableAnnotation;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceJoinTableAnnotation
extends SourceBaseTableAnnotation
implements NestableJoinTableAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.JoinTable");
    private final Vector<NestableJoinColumnAnnotation> joinColumns = new Vector();
    private final JoinColumnsAnnotationContainer joinColumnsContainer = new JoinColumnsAnnotationContainer();
    private final Vector<NestableJoinColumnAnnotation> inverseJoinColumns = new Vector();
    private final InverseJoinColumnsContainerAnnotation inverseJoinColumnsContainer = new InverseJoinColumnsContainerAnnotation();

    public SourceJoinTableAnnotation(JavaResourceNode parent, Member member) {
        this(parent, member, DECLARATION_ANNOTATION_ADAPTER);
    }

    public SourceJoinTableAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa) {
        super(parent, member, daa);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.JoinTable";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        AnnotationContainerTools.initialize(this.joinColumnsContainer, astRoot);
        AnnotationContainerTools.initialize(this.inverseJoinColumnsContainer, astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        AnnotationContainerTools.synchronize(this.joinColumnsContainer, astRoot);
        AnnotationContainerTools.synchronize(this.inverseJoinColumnsContainer, astRoot);
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> getNameAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(declarationAnnotationAdapter, "name");
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> getSchemaAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(declarationAnnotationAdapter, "schema");
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> getCatalogAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(declarationAnnotationAdapter, "catalog");
    }

    @Override
    protected String getUniqueConstraintsElementName() {
        return "uniqueConstraints";
    }

    @Override
    public ListIterator<JoinColumnAnnotation> joinColumns() {
        return new CloneListIterator(this.joinColumns);
    }

    Iterable<NestableJoinColumnAnnotation> getNestableJoinColumns() {
        return new LiveCloneIterable(this.joinColumns);
    }

    @Override
    public int joinColumnsSize() {
        return this.joinColumns.size();
    }

    @Override
    public NestableJoinColumnAnnotation joinColumnAt(int index) {
        return this.joinColumns.get(index);
    }

    @Override
    public int indexOfJoinColumn(JoinColumnAnnotation joinColumn) {
        return this.joinColumns.indexOf(joinColumn);
    }

    @Override
    public NestableJoinColumnAnnotation addJoinColumn(int index) {
        return (NestableJoinColumnAnnotation)AnnotationContainerTools.addNestedAnnotation(index, this.joinColumnsContainer);
    }

    NestableJoinColumnAnnotation addJoinColumn_() {
        return this.addJoinColumn_(this.joinColumns.size());
    }

    private NestableJoinColumnAnnotation addJoinColumn_(int index) {
        NestableJoinColumnAnnotation joinColumn = this.buildJoinColumn(index);
        this.joinColumns.add(index, joinColumn);
        return joinColumn;
    }

    void syncAddJoinColumn(Annotation astAnnotation) {
        int index = this.joinColumns.size();
        NestableJoinColumnAnnotation joinColumn = this.addJoinColumn_(index);
        joinColumn.initialize((CompilationUnit)astAnnotation.getRoot());
        this.fireItemAdded("joinColumns", index, joinColumn);
    }

    private NestableJoinColumnAnnotation buildJoinColumn(int index) {
        return new SourceJoinColumnAnnotation((JavaResourceNode)this, this.member, this.buildJoinColumnAnnotationAdapter(index));
    }

    private IndexedDeclarationAnnotationAdapter buildJoinColumnAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(this.daa, "joinColumns", index, "javax.persistence.JoinColumn");
    }

    @Override
    public void moveJoinColumn(int targetIndex, int sourceIndex) {
        AnnotationContainerTools.moveNestedAnnotation(targetIndex, sourceIndex, this.joinColumnsContainer);
    }

    NestableJoinColumnAnnotation moveJoinColumn_(int targetIndex, int sourceIndex) {
        return (NestableJoinColumnAnnotation)CollectionTools.move(this.joinColumns, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    @Override
    public void removeJoinColumn(int index) {
        AnnotationContainerTools.removeNestedAnnotation(index, this.joinColumnsContainer);
    }

    NestableJoinColumnAnnotation removeJoinColumn_(int index) {
        return this.joinColumns.remove(index);
    }

    void syncRemoveJoinColumns(int index) {
        this.removeItemsFromList(index, this.joinColumns, "joinColumns");
    }

    @Override
    public ListIterator<JoinColumnAnnotation> inverseJoinColumns() {
        return new CloneListIterator(this.inverseJoinColumns);
    }

    Iterable<NestableJoinColumnAnnotation> getNestableInverseJoinColumns() {
        return new LiveCloneIterable(this.inverseJoinColumns);
    }

    @Override
    public int inverseJoinColumnsSize() {
        return this.inverseJoinColumns.size();
    }

    @Override
    public NestableJoinColumnAnnotation inverseJoinColumnAt(int index) {
        return this.inverseJoinColumns.get(index);
    }

    @Override
    public int indexOfInverseJoinColumn(JoinColumnAnnotation joinColumn) {
        return this.inverseJoinColumns.indexOf(joinColumn);
    }

    @Override
    public NestableJoinColumnAnnotation addInverseJoinColumn(int index) {
        return (NestableJoinColumnAnnotation)AnnotationContainerTools.addNestedAnnotation(index, this.inverseJoinColumnsContainer);
    }

    NestableJoinColumnAnnotation addInverseJoinColumn_() {
        return this.addInverseJoinColumn_(this.inverseJoinColumns.size());
    }

    private NestableJoinColumnAnnotation addInverseJoinColumn_(int index) {
        NestableJoinColumnAnnotation joinColumn = this.buildInverseJoinColumn(index);
        this.inverseJoinColumns.add(joinColumn);
        return joinColumn;
    }

    void syncAddInverseJoinColumn(Annotation astAnnotation) {
        int index = this.inverseJoinColumns.size();
        NestableJoinColumnAnnotation joinColumn = this.addInverseJoinColumn_(index);
        joinColumn.initialize((CompilationUnit)astAnnotation.getRoot());
        this.fireItemAdded("inverseJoinColumns", index, joinColumn);
    }

    private NestableJoinColumnAnnotation buildInverseJoinColumn(int index) {
        return new SourceJoinColumnAnnotation((JavaResourceNode)this, this.member, this.buildInverseJoinColumnAnnotationAdapter(index));
    }

    private IndexedDeclarationAnnotationAdapter buildInverseJoinColumnAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(this.daa, "inverseJoinColumns", index, "javax.persistence.JoinColumn");
    }

    void inverseJoinColumnAdded(int index, NestableJoinColumnAnnotation joinColumn) {
        this.fireItemAdded("inverseJoinColumns", index, joinColumn);
    }

    @Override
    public void moveInverseJoinColumn(int targetIndex, int sourceIndex) {
        AnnotationContainerTools.moveNestedAnnotation(targetIndex, sourceIndex, this.inverseJoinColumnsContainer);
    }

    NestableJoinColumnAnnotation moveInverseJoinColumn_(int targetIndex, int sourceIndex) {
        return (NestableJoinColumnAnnotation)CollectionTools.move(this.inverseJoinColumns, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    void inverseJoinColumnMoved(int targetIndex, int sourceIndex) {
        this.fireItemMoved("inverseJoinColumns", targetIndex, sourceIndex);
    }

    @Override
    public void removeInverseJoinColumn(int index) {
        AnnotationContainerTools.removeNestedAnnotation(index, this.inverseJoinColumnsContainer);
    }

    NestableJoinColumnAnnotation removeInverseJoinColumn_(int index) {
        return this.inverseJoinColumns.remove(index);
    }

    void syncRemoveInverseJoinColumns(int index) {
        this.removeItemsFromList(index, this.inverseJoinColumns, "inverseJoinColumns");
    }

    @Override
    public void initializeFrom(NestableAnnotation oldAnnotation) {
        super.initializeFrom(oldAnnotation);
        JoinTableAnnotation oldJoinTable = (JoinTableAnnotation)((Object)oldAnnotation);
        for (JoinColumnAnnotation oldJoinColumn : CollectionTools.iterable(oldJoinTable.joinColumns())) {
            NestableJoinColumnAnnotation newJoinColumn = this.addJoinColumn(oldJoinTable.indexOfJoinColumn(oldJoinColumn));
            newJoinColumn.initializeFrom((NestableAnnotation)((Object)oldJoinColumn));
        }
        for (JoinColumnAnnotation oldInverseJoinColumn : CollectionTools.iterable(oldJoinTable.inverseJoinColumns())) {
            NestableJoinColumnAnnotation newInverseJoinColumn = this.addInverseJoinColumn(oldJoinTable.indexOfInverseJoinColumn(oldInverseJoinColumn));
            newInverseJoinColumn.initializeFrom((NestableAnnotation)((Object)oldInverseJoinColumn));
        }
    }

    @Override
    public void moveAnnotation(int newIndex) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AbstractJoinColumnAnnotationContainer
    implements AnnotationContainer<NestableJoinColumnAnnotation> {
        AbstractJoinColumnAnnotationContainer() {
        }

        @Override
        public Annotation getAstAnnotation(CompilationUnit astRoot) {
            return SourceJoinTableAnnotation.this.getAstAnnotation(astRoot);
        }

        @Override
        public String getNestedAnnotationName() {
            return "javax.persistence.JoinColumn";
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InverseJoinColumnsContainerAnnotation
    extends AbstractJoinColumnAnnotationContainer {
        InverseJoinColumnsContainerAnnotation() {
        }

        @Override
        public String getElementName() {
            return "inverseJoinColumns";
        }

        @Override
        public Iterable<NestableJoinColumnAnnotation> getNestedAnnotations() {
            return SourceJoinTableAnnotation.this.getNestableInverseJoinColumns();
        }

        @Override
        public int getNestedAnnotationsSize() {
            return SourceJoinTableAnnotation.this.inverseJoinColumnsSize();
        }

        @Override
        public NestableJoinColumnAnnotation addNestedAnnotation() {
            return SourceJoinTableAnnotation.this.addInverseJoinColumn_();
        }

        @Override
        public void syncAddNestedAnnotation(Annotation astAnnotation) {
            SourceJoinTableAnnotation.this.syncAddInverseJoinColumn(astAnnotation);
        }

        @Override
        public NestableJoinColumnAnnotation moveNestedAnnotation(int targetIndex, int sourceIndex) {
            return SourceJoinTableAnnotation.this.moveInverseJoinColumn_(targetIndex, sourceIndex);
        }

        @Override
        public NestableJoinColumnAnnotation removeNestedAnnotation(int index) {
            return SourceJoinTableAnnotation.this.removeInverseJoinColumn_(index);
        }

        @Override
        public void syncRemoveNestedAnnotations(int index) {
            SourceJoinTableAnnotation.this.syncRemoveInverseJoinColumns(index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JoinColumnsAnnotationContainer
    extends AbstractJoinColumnAnnotationContainer {
        JoinColumnsAnnotationContainer() {
        }

        @Override
        public String getElementName() {
            return "joinColumns";
        }

        @Override
        public Iterable<NestableJoinColumnAnnotation> getNestedAnnotations() {
            return SourceJoinTableAnnotation.this.getNestableJoinColumns();
        }

        @Override
        public int getNestedAnnotationsSize() {
            return SourceJoinTableAnnotation.this.joinColumnsSize();
        }

        @Override
        public NestableJoinColumnAnnotation addNestedAnnotation() {
            return SourceJoinTableAnnotation.this.addJoinColumn_();
        }

        @Override
        public void syncAddNestedAnnotation(Annotation astAnnotation) {
            SourceJoinTableAnnotation.this.syncAddJoinColumn(astAnnotation);
        }

        @Override
        public NestableJoinColumnAnnotation moveNestedAnnotation(int targetIndex, int sourceIndex) {
            return SourceJoinTableAnnotation.this.moveJoinColumn_(targetIndex, sourceIndex);
        }

        @Override
        public NestableJoinColumnAnnotation removeNestedAnnotation(int index) {
            return SourceJoinTableAnnotation.this.removeJoinColumn_(index);
        }

        @Override
        public void syncRemoveNestedAnnotations(int index) {
            SourceJoinTableAnnotation.this.syncRemoveJoinColumns(index);
        }
    }
}

