/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jpt.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.core.internal.resource.java.source.SourceNode;
import org.eclipse.jpt.core.internal.utility.jdt.ASTNodeTextRange;
import org.eclipse.jpt.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.ContainerAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourcePersistentMember<M extends Member>
extends SourceNode
implements JavaResourcePersistentMember {
    final M member;
    final Vector<Annotation> annotations = new Vector();
    boolean persistable;

    SourcePersistentMember(JavaResourceNode parent, M member) {
        super(parent);
        this.member = member;
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.member.getBodyDeclaration(astRoot).accept(this.buildInitialAnnotationVisitor(astRoot));
        this.persistable = this.buildPersistable(astRoot);
    }

    private ASTVisitor buildInitialAnnotationVisitor(CompilationUnit astRoot) {
        return new InitialAnnotationVisitor(astRoot, this.member.getBodyDeclaration(astRoot));
    }

    void addInitialAnnotation(org.eclipse.jdt.core.dom.Annotation node, CompilationUnit astRoot) {
        String jdtAnnotationName = ASTTools.resolveAnnotation(node);
        if (jdtAnnotationName != null) {
            this.addInitialAnnotation(jdtAnnotationName, astRoot);
        }
    }

    void addInitialAnnotation(String jdtAnnotationName, CompilationUnit astRoot) {
        if (this.annotationIsValid(jdtAnnotationName) && this.selectAnnotationNamed(this.annotations, jdtAnnotationName) == null) {
            Annotation annotation = this.buildAnnotation(jdtAnnotationName);
            annotation.initialize(astRoot);
            this.annotations.add(annotation);
        }
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncAnnotations(astRoot);
        this.syncPersistable(this.buildPersistable(astRoot));
    }

    @Override
    public Iterator<Annotation> annotations() {
        return this.getAnnotations().iterator();
    }

    Iterable<Annotation> getAnnotations() {
        return new LiveCloneIterable(this.annotations);
    }

    @Override
    public int annotationsSize() {
        return this.annotations.size();
    }

    @Override
    public Annotation getAnnotation(String annotationName) {
        return this.selectAnnotationNamed(this.getAnnotations(), annotationName);
    }

    @Override
    public Annotation getNonNullAnnotation(String annotationName) {
        Annotation annotation = this.getAnnotation(annotationName);
        return annotation != null ? annotation : this.buildNullAnnotation(annotationName);
    }

    @Override
    public Iterator<NestableAnnotation> annotations(String nestableAnnotationName, String containerAnnotationName) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.getContainerAnnotation(containerAnnotationName);
        if (containerAnnotation != null) {
            return containerAnnotation.getNestedAnnotations().iterator();
        }
        NestableAnnotation nestableAnnotation = this.getNestableAnnotation(nestableAnnotationName);
        if (nestableAnnotation != null) {
            return new SingleElementIterator((Object)nestableAnnotation);
        }
        return EmptyIterator.instance();
    }

    private ContainerAnnotation<NestableAnnotation> getContainerAnnotation(String annotationName) {
        return (ContainerAnnotation)this.getAnnotation(annotationName);
    }

    private NestableAnnotation getNestableAnnotation(String annotationName) {
        return (NestableAnnotation)this.getAnnotation(annotationName);
    }

    @Override
    public Annotation addAnnotation(String annotationName) {
        Annotation annotation = this.buildAnnotation(annotationName);
        this.annotations.add(annotation);
        annotation.newAnnotation();
        return annotation;
    }

    @Override
    public NestableAnnotation addAnnotation(int index, String nestableAnnotationName, String containerAnnotationName) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.getContainerAnnotation(containerAnnotationName);
        if (containerAnnotation != null) {
            return AnnotationContainerTools.addNestedAnnotation(index, containerAnnotation);
        }
        NestableAnnotation standAloneAnnotation = this.getNestableAnnotation(nestableAnnotationName);
        if (standAloneAnnotation == null) {
            return (NestableAnnotation)this.addAnnotation(nestableAnnotationName);
        }
        return this.addSecondNestedAnnotation(index, containerAnnotationName, standAloneAnnotation);
    }

    private NestableAnnotation addSecondNestedAnnotation(int index, String containerAnnotationName, NestableAnnotation standAloneAnnotation) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.buildContainerAnnotation(containerAnnotationName);
        this.annotations.add(containerAnnotation);
        containerAnnotation.newAnnotation();
        NestableAnnotation nestedAnnotation0 = containerAnnotation.addNestedAnnotation();
        nestedAnnotation0.newAnnotation();
        NestableAnnotation nestedAnnotation1 = containerAnnotation.addNestedAnnotation();
        nestedAnnotation1.newAnnotation();
        this.removeAnnotation(standAloneAnnotation);
        if (index == 0) {
            nestedAnnotation1.initializeFrom(standAloneAnnotation);
        } else {
            nestedAnnotation0.initializeFrom(standAloneAnnotation);
        }
        return index == 0 ? nestedAnnotation0 : nestedAnnotation1;
    }

    @Override
    public void moveAnnotation(int targetIndex, int sourceIndex, String containerAnnotationName) {
        this.moveAnnotation(targetIndex, sourceIndex, this.getContainerAnnotation(containerAnnotationName));
    }

    private void moveAnnotation(int targetIndex, int sourceIndex, ContainerAnnotation<NestableAnnotation> containerAnnotation) {
        AnnotationContainerTools.moveNestedAnnotation(targetIndex, sourceIndex, containerAnnotation);
    }

    @Override
    public void removeAnnotation(String annotationName) {
        Annotation annotation = this.getAnnotation(annotationName);
        if (annotation != null) {
            this.removeAnnotation(annotation);
        }
    }

    private void removeAnnotation(Annotation annotation) {
        this.annotations.remove(annotation);
        annotation.removeAnnotation();
    }

    @Override
    public void removeAnnotation(int index, String nestableAnnotationName, String containerAnnotationName) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.getContainerAnnotation(containerAnnotationName);
        if (containerAnnotation == null) {
            this.removeAnnotation(this.getAnnotation(nestableAnnotationName));
        } else {
            this.removeAnnotation(index, containerAnnotation);
        }
    }

    private void removeAnnotation(int index, ContainerAnnotation<NestableAnnotation> containerAnnotation) {
        AnnotationContainerTools.removeNestedAnnotation(index, containerAnnotation);
        switch (containerAnnotation.getNestedAnnotationsSize()) {
            case 0: {
                this.removeAnnotation(containerAnnotation);
                break;
            }
            case 1: {
                this.convertLastNestedAnnotation(containerAnnotation);
                break;
            }
        }
    }

    private void convertLastNestedAnnotation(ContainerAnnotation<NestableAnnotation> containerAnnotation) {
        NestableAnnotation lastNestedAnnotation = (NestableAnnotation)containerAnnotation.getNestedAnnotations().iterator().next();
        this.annotations.remove(containerAnnotation);
        containerAnnotation.removeAnnotation();
        NestableAnnotation standAloneAnnotation = this.buildNestableAnnotation(lastNestedAnnotation.getAnnotationName());
        this.annotations.add(standAloneAnnotation);
        standAloneAnnotation.newAnnotation();
        standAloneAnnotation.initializeFrom(lastNestedAnnotation);
    }

    @Override
    public Annotation setPrimaryAnnotation(String primaryAnnotationName, Iterable<String> supportingAnnotationNames) {
        ArrayList<String> annotationNames = new ArrayList<String>();
        CollectionTools.addAll(annotationNames, supportingAnnotationNames);
        if (primaryAnnotationName != null) {
            annotationNames.add(primaryAnnotationName);
        }
        for (Annotation annotation : this.getAnnotations()) {
            if (CollectionTools.contains(annotationNames, (Object)annotation.getAnnotationName())) continue;
            this.annotations.remove(annotation);
            annotation.removeAnnotation();
        }
        Annotation newPrimaryAnnotation = null;
        if (primaryAnnotationName != null && this.getAnnotation(primaryAnnotationName) == null) {
            newPrimaryAnnotation = this.buildAnnotation(primaryAnnotationName);
            this.annotations.add(newPrimaryAnnotation);
            newPrimaryAnnotation.newAnnotation();
        }
        this.fireCollectionChanged("annotations", this.annotations);
        return newPrimaryAnnotation;
    }

    private boolean annotationIsValid(String annotationName) {
        return CollectionTools.contains(this.validAnnotationNames(), (Object)annotationName);
    }

    abstract Iterator<String> validAnnotationNames();

    abstract Annotation buildAnnotation(String var1);

    abstract Annotation buildNullAnnotation(String var1);

    private ContainerAnnotation<NestableAnnotation> buildContainerAnnotation(String annotationName) {
        return (ContainerAnnotation)this.buildAnnotation(annotationName);
    }

    private NestableAnnotation buildNestableAnnotation(String annotationName) {
        return (NestableAnnotation)this.buildAnnotation(annotationName);
    }

    private void syncAnnotations(CompilationUnit astRoot) {
        HashSet<Annotation> annotationsToRemove = new HashSet<Annotation>(this.annotations);
        this.member.getBodyDeclaration(astRoot).accept(this.buildSynchronizeAnnotationVisitor(astRoot, annotationsToRemove));
        for (Annotation annotation : annotationsToRemove) {
            this.removeItemFromCollection(annotation, this.annotations, "annotations");
        }
    }

    private ASTVisitor buildSynchronizeAnnotationVisitor(CompilationUnit astRoot, Set<Annotation> annotationsToRemove) {
        return new SynchronizeAnnotationVisitor(astRoot, this.member.getBodyDeclaration(astRoot), annotationsToRemove);
    }

    void addOrSyncAnnotation(org.eclipse.jdt.core.dom.Annotation node, CompilationUnit astRoot, Set<Annotation> annotationsToRemove) {
        String jdtAnnotationName = ASTTools.resolveAnnotation(node);
        if (jdtAnnotationName != null) {
            this.addOrSyncAnnotation(jdtAnnotationName, astRoot, annotationsToRemove);
        }
    }

    void addOrSyncAnnotation(String jdtAnnotationName, CompilationUnit astRoot, Set<Annotation> annotationsToRemove) {
        if (this.annotationIsValid(jdtAnnotationName)) {
            this.addOrSyncAnnotation_(jdtAnnotationName, astRoot, annotationsToRemove);
        }
    }

    private void addOrSyncAnnotation_(String jdtAnnotationName, CompilationUnit astRoot, Set<Annotation> annotationsToRemove) {
        Annotation annotation = this.selectAnnotationNamed(annotationsToRemove, jdtAnnotationName);
        if (annotation != null) {
            annotation.synchronizeWith(astRoot);
            annotationsToRemove.remove(annotation);
        } else {
            annotation = this.buildAnnotation(jdtAnnotationName);
            annotation.initialize(astRoot);
            this.addItemToCollection(annotation, this.annotations, "annotations");
        }
    }

    @Override
    public boolean isPersistable() {
        return this.persistable;
    }

    private void syncPersistable(boolean astPersistable) {
        boolean old = this.persistable;
        this.persistable = astPersistable;
        this.firePropertyChanged("persistable", old, astPersistable);
    }

    private boolean buildPersistable(CompilationUnit astRoot) {
        return this.member.isPersistable(astRoot);
    }

    @Override
    public boolean isAnnotated() {
        return !this.annotations.isEmpty();
    }

    @Override
    public boolean isFor(String memberName, int occurrence) {
        return this.member.matches(memberName, occurrence);
    }

    @Override
    public TextRange getTextRange(CompilationUnit astRoot) {
        return this.fullTextRange(astRoot);
    }

    private TextRange fullTextRange(CompilationUnit astRoot) {
        return this.buildTextRange((ASTNode)this.member.getBodyDeclaration(astRoot));
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.member.getNameTextRange(astRoot);
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        this.syncPersistable(this.buildPersistable(astRoot));
    }

    private Annotation selectAnnotationNamed(Iterable<Annotation> list, String annotationName) {
        for (Annotation annotation : list) {
            if (!annotation.getAnnotationName().equals(annotationName)) continue;
            return annotation;
        }
        return null;
    }

    private TextRange buildTextRange(ASTNode astNode) {
        return astNode == null ? null : new ASTNodeTextRange(astNode);
    }

    <T extends JavaResourcePersistentMember> Iterator<T> persistableMembers(Iterator<T> members) {
        return new FilteringIterator<T>(members){

            protected boolean accept(T m) {
                return m.isPersistable();
            }
        };
    }

    protected static abstract class AnnotationVisitor
    extends ASTVisitor {
        protected final CompilationUnit astRoot;
        protected final BodyDeclaration bodyDeclaration;

        protected AnnotationVisitor(CompilationUnit astRoot, BodyDeclaration bodyDeclaration) {
            this.astRoot = astRoot;
            this.bodyDeclaration = bodyDeclaration;
        }

        public boolean visit(SingleMemberAnnotation node) {
            return this.visit_((org.eclipse.jdt.core.dom.Annotation)node);
        }

        public boolean visit(NormalAnnotation node) {
            return this.visit_((org.eclipse.jdt.core.dom.Annotation)node);
        }

        public boolean visit(MarkerAnnotation node) {
            return this.visit_((org.eclipse.jdt.core.dom.Annotation)node);
        }

        protected boolean visit_(org.eclipse.jdt.core.dom.Annotation node) {
            if (node.getParent() == this.bodyDeclaration) {
                this.visitChildAnnotation(node);
            }
            return false;
        }

        protected abstract void visitChildAnnotation(org.eclipse.jdt.core.dom.Annotation var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InitialAnnotationVisitor
    extends AnnotationVisitor {
        protected InitialAnnotationVisitor(CompilationUnit astRoot, BodyDeclaration bodyDeclaration) {
            super(astRoot, bodyDeclaration);
        }

        @Override
        protected void visitChildAnnotation(org.eclipse.jdt.core.dom.Annotation node) {
            SourcePersistentMember.this.addInitialAnnotation(node, this.astRoot);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SynchronizeAnnotationVisitor
    extends AnnotationVisitor {
        protected final Set<Annotation> annotationsToRemove;

        protected SynchronizeAnnotationVisitor(CompilationUnit astRoot, BodyDeclaration bodyDeclaration, Set<Annotation> annotationsToRemove) {
            super(astRoot, bodyDeclaration);
            this.annotationsToRemove = annotationsToRemove;
        }

        @Override
        protected void visitChildAnnotation(org.eclipse.jdt.core.dom.Annotation node) {
            SourcePersistentMember.this.addOrSyncAnnotation(node, this.astRoot, this.annotationsToRemove);
        }
    }
}

