/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.resources;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.internal.finder.VisitorMatcher;
import org.eclipse.jst.jsf.common.internal.finder.acceptor.JarEntryMatchingAcceptor;
import org.eclipse.jst.jsf.common.internal.finder.matcher.TaglibJarEntryFinder;
import org.eclipse.jst.jsf.common.internal.locator.ILocatorChangeListener;
import org.eclipse.jst.jsf.common.internal.resource.ClasspathJarFile;
import org.eclipse.jst.jsf.common.internal.resource.ContentTypeResolver;
import org.eclipse.jst.jsf.common.internal.resource.IJarLocator;
import org.eclipse.jst.jsf.common.internal.util.JarUtilities;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.internal.resources.AbstractJSFResourceLocator;
import org.eclipse.jst.jsf.designtime.internal.resources.IJSFResourceFragment;
import org.eclipse.jst.jsf.designtime.internal.resources.JSFResource;
import org.eclipse.jst.jsf.designtime.internal.resources.JarBasedJSFResource;
import org.eclipse.jst.jsf.designtime.internal.resources.ResourceIdentifier;
import org.eclipse.jst.jsf.designtime.internal.resources.ResourceIdentifierFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarBasedJSFResourceLocator
extends AbstractJSFResourceLocator {
    private final IJarLocator _provider;
    private final ContentTypeResolver _contentTypeResolver;
    private static final Pattern _resourcePathPattern = Pattern.compile("META-INF/resources/(.*)");
    private static final TaglibJarEntryFinder _resourceFinder = new TaglibJarEntryFinder(_resourcePathPattern);

    public JarBasedJSFResourceLocator(String id, String displayName, List<IJSFResourceFragment> noResultValue, CopyOnWriteArrayList<ILocatorChangeListener> mutableListenerList, IJarLocator provider, ContentTypeResolver contentTypeResolver) {
        super(id, displayName, noResultValue, mutableListenerList);
        this._provider = provider;
        this._contentTypeResolver = contentTypeResolver;
    }

    public JarBasedJSFResourceLocator(List<IJSFResourceFragment> noResultValue, CopyOnWriteArrayList<ILocatorChangeListener> mutableListenerList, IJarLocator provider, ContentTypeResolver contentTypeResolver) {
        this("", "", noResultValue, mutableListenerList, provider, contentTypeResolver);
    }

    public void start(IProject initialContext) {
        this._provider.start((Object)initialContext);
        super.start((Object)initialContext);
    }

    public void stop() {
        this._provider.stop();
        super.stop();
    }

    @Override
    protected List<IJSFResourceFragment> doLocate(IProject project) {
        ArrayList<IJSFResourceFragment> resourcesFound = new ArrayList<IJSFResourceFragment>();
        Collection jars = this._provider.getJars(project);
        for (ClasspathJarFile classpathJarFile : jars) {
            JarFile jarFile = classpathJarFile.getJarFile();
            if (jarFile == null) continue;
            resourcesFound.addAll(this.processJar(jarFile));
        }
        return resourcesFound;
    }

    private List<JSFResource> processJar(JarFile jarFile) {
        ArrayList<JSFResource> tagLibsFound;
        block17: {
            tagLibsFound = new ArrayList<JSFResource>();
            try {
                try {
                    if (jarFile != null) {
                        JarEntryMatchingAcceptor acceptor = new JarEntryMatchingAcceptor();
                        VisitorMatcher matcher = new VisitorMatcher((Object)"", "", (VisitorMatcher.MatchingAcceptor)acceptor, Collections.singletonList(_resourceFinder));
                        Collection matchingEntries = (Collection)matcher.find((Object)jarFile);
                        for (JarEntry jarEntry : matchingEntries) {
                            try {
                                String group;
                                Matcher patternMatcher = _resourcePathPattern.matcher(jarEntry.getName());
                                if (!patternMatcher.matches() || (group = patternMatcher.group(1)) == null || group.trim().length() <= 0) continue;
                                ResourceIdentifier libRes = new ResourceIdentifierFactory().createLibraryResource(group);
                                URL jarUrl = JarUtilities.INSTANCE.createJarUrl(jarFile);
                                tagLibsFound.add(new JarBasedJSFResource(libRes, jarUrl, this._contentTypeResolver));
                            }
                            catch (ResourceIdentifierFactory.InvalidIdentifierException invalidIdentifierException) {
                            }
                            catch (Exception e) {
                                JSFCorePlugin.log("Error initializing facelet registry entry", e);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    JSFCorePlugin.log(e, "While locating jar based facelet tag libraries");
                    if (jarFile == null) break block17;
                    try {
                        jarFile.close();
                    }
                    catch (IOException ioe) {
                        JSFCorePlugin.log("Error closing jar file", ioe);
                    }
                }
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException ioe) {
                        JSFCorePlugin.log("Error closing jar file", ioe);
                    }
                }
            }
        }
        return tagLibsFound;
    }
}

