/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.correction;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.ui.internal.correction.AnnotationQuery;
import org.eclipse.wst.sse.ui.internal.correction.AnnotationQueryResult;
import org.eclipse.wst.sse.ui.internal.correction.QuickFixRegistry;
import org.eclipse.wst.sse.ui.internal.extension.RegistryReader;

public class QuickFixRegistryReader
extends RegistryReader {
    private static final String QUICKFIXPROCESSOR = "quickFixProcessor";
    private static final String ATT_PROBLEMTYPE = "problemType";
    private static final String ATTRIBUTE = "attribute";
    private static final String ATT_NAME = "name";
    private static final String ATT_VALUE = "value";
    private ArrayList currentAttributeNames;
    private ArrayList currentAttributeValues;
    private QuickFixRegistry quickFixProcessorRegistry;

    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equals(QUICKFIXPROCESSOR)) {
            this.readQuickFixProcessorElement(element);
            return true;
        }
        if (element.getName().equals(ATTRIBUTE)) {
            this.readAttributeElement(element);
            return true;
        }
        return false;
    }

    private void readQuickFixProcessorElement(IConfigurationElement element) {
        String type = element.getAttribute(ATT_PROBLEMTYPE);
        this.currentAttributeNames = new ArrayList();
        this.currentAttributeValues = new ArrayList();
        this.readElementChildren(element);
        String[] attributeNames = this.currentAttributeNames.toArray(new String[this.currentAttributeNames.size()]);
        String[] attributeValues = this.currentAttributeValues.toArray(new String[this.currentAttributeValues.size()]);
        AnnotationQuery query = new AnnotationQuery(type, attributeNames);
        AnnotationQueryResult result = new AnnotationQueryResult(attributeValues);
        this.quickFixProcessorRegistry.addResolutionQuery(query, result, element);
    }

    public void addHelp(QuickFixRegistry registry) {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        this.quickFixProcessorRegistry = registry;
        this.readRegistry(extensionRegistry, "org.eclipse.wst.sse.ui", QUICKFIXPROCESSOR);
    }

    private void readAttributeElement(IConfigurationElement element) {
        String name = element.getAttribute(ATT_NAME);
        String value = element.getAttribute(ATT_VALUE);
        if (name != null && value != null) {
            this.currentAttributeNames.add(name);
            this.currentAttributeValues.add(value);
        }
    }
}

