/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.openon;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.openon.ExternalFileEditorInput;
import org.eclipse.wst.sse.ui.internal.openon.IOpenOn;
import org.eclipse.wst.sse.ui.internal.util.PlatformStatusLineUtil;

public abstract class AbstractOpenOn
implements IOpenOn {
    protected final String CANNOT_OPEN = SSEUIMessages.AbstractOpenOn_0;
    private IDocument fDocument;
    protected final String FILE_PROTOCOL = "file:/";
    private final String HTTP_PROTOCOL = "http://";

    protected abstract IRegion doGetOpenOnRegion(int var1);

    protected abstract void doOpenOn(IRegion var1);

    public IDocument getDocument() {
        return this.fDocument;
    }

    private String getEditorId(String filename) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(filename);
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IFile getFile(String fileString) {
        IFile file;
        block10: {
            IStructuredModel model = null;
            file = null;
            try {
                block9: {
                    try {
                        String filesystemLocation;
                        URIResolver resolver;
                        IFile modelFile;
                        model = StructuredModelManager.getModelManager().getExistingModelForRead(this.getDocument());
                        if (model == null || (modelFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(model.getBaseLocation()))) == null || (resolver = model.getResolver()) == null || (filesystemLocation = resolver.getLocationByURI(fileString)) == null) break block9;
                        IFile[] workspaceFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(filesystemLocation));
                        int i = 0;
                        while (true) {
                            if (i >= workspaceFiles.length || file != null) {
                                if (file == null && workspaceFiles.length > 0) {
                                    file = workspaceFiles[0];
                                }
                                break;
                            }
                            if (workspaceFiles[i].getProject().equals((Object)modelFile.getProject())) {
                                file = workspaceFiles[i];
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        Logger.log(2, e.getMessage());
                    }
                }
                Object var9_12 = null;
                if (model == null) break block10;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (model == null) throw throwable;
                model.releaseFromRead();
                throw throwable;
            }
            model.releaseFromRead();
        }
        if (file != null) return file;
        if (!fileString.startsWith("/")) return file;
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileString));
    }

    public IRegion getOpenOnRegion(IDocument doc, int offset) {
        this.setDocument(doc);
        IRegion region = this.doGetOpenOnRegion(offset);
        this.setDocument(null);
        return region;
    }

    protected IEditorPart openExternalFile(String fileString) {
        File file = new File(fileString);
        if (file.exists()) {
            ExternalFileEditorInput input = new ExternalFileEditorInput(file);
            String editorId = this.getEditorId(fileString);
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                return page.openEditor((IEditorInput)input, editorId, true);
            }
            catch (PartInitException pie) {
                Logger.log(202, pie.getMessage(), pie);
            }
        }
        return null;
    }

    protected void openFileFailed() {
        PlatformStatusLineUtil.displayErrorMessage(this.CANNOT_OPEN);
        PlatformStatusLineUtil.addOneTimeClearListener();
    }

    protected IEditorPart openFileInEditor(IFile input) {
        if (input != null && input.exists()) {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                return IDE.openEditor((IWorkbenchPage)page, (IFile)input, (boolean)true);
            }
            catch (PartInitException pie) {
                Logger.log(202, pie.getMessage(), pie);
            }
        }
        return null;
    }

    protected void openFileInEditor(String fileString) {
        IEditorPart editor = null;
        if (fileString != null) {
            IFile file;
            String temp = fileString.toLowerCase();
            if (temp.startsWith("http://")) {
                Program.launch((String)fileString);
                return;
            }
            if (temp.startsWith("file:/")) {
                fileString = fileString.substring("file:/".length());
            }
            editor = (file = this.getFile(fileString)) != null ? this.openFileInEditor(file) : this.openExternalFile(fileString);
        }
        if (editor == null) {
            this.openFileFailed();
        }
    }

    public void openOn(IDocument doc, IRegion region) {
        this.setDocument(doc);
        if (region == null) {
            this.openFileFailed();
        } else {
            this.doOpenOn(region);
        }
        this.setDocument(null);
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }
}

