/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.search.BasicSearchLabelProvider;
import org.eclipse.wst.sse.ui.internal.search.BasicSearchMatchElement;
import org.eclipse.wst.sse.ui.internal.search.OccurrencesContentProvider;

public class OccurrencesSearchViewPage
extends AbstractTextSearchViewPage {
    private OccurrencesContentProvider fContentProvider = null;

    public OccurrencesSearchViewPage() {
        super(1);
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer v, Object obj1, Object obj2) {
                BasicSearchMatchElement elem1 = (BasicSearchMatchElement)obj1;
                BasicSearchMatchElement elem2 = (BasicSearchMatchElement)obj2;
                return elem1.getLineNum() - elem2.getLineNum();
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new BasicSearchLabelProvider(this)));
        this.fContentProvider = new OccurrencesContentProvider();
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
    }

    protected void configureTreeViewer(TreeViewer viewer) {
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    public void forceRefresh() {
        this.fContentProvider.refresh();
    }

    private IWorkbenchPage getActivePage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return workbench.getActiveWorkbenchWindow().getActivePage();
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        BasicSearchMatchElement element = (BasicSearchMatchElement)match.getElement();
        IWorkbenchPage activePage = this.getActivePage();
        try {
            if (activePage != null) {
                IDE.openEditor((IWorkbenchPage)this.getActivePage(), (IFile)element.getFile());
                IEditorPart editor = activePage.getActiveEditor();
                if (activate) {
                    editor.getSite().getPage().activate((IWorkbenchPart)editor);
                }
                editor.getEditorSite().getSelectionProvider().setSelection((ISelection)new TextSelection(currentOffset, currentLength));
            }
        }
        catch (PartInitException e) {
            Logger.logException(e);
        }
    }
}

