/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.dialogs;

import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.dialogs.EditNamespaceInfoDialog;
import org.eclipse.wst.xml.ui.internal.dialogs.UpdateListener;

public class NamespaceInfoTable
extends Composite {
    protected static final String LOCATION_HINT = XMLUIMessages._UI_LABEL_LOCATION_HINT;
    protected static final String NAMESPACE_URI = XMLUIMessages._UI_LABEL_NAMESPACE_NAME;
    protected static final String PREFIX = XMLUIMessages._UI_LABEL_PREFIX;
    protected Button deleteButton;
    protected boolean dummyRowsRemoved = false;
    protected Button editButton;
    protected List namespaceInfoList = new Vector();
    protected Button newButton;
    protected NamespaceInfoTableLabelProvider provider;
    protected IPath resourceLocation;
    protected TableViewer tableViewer;
    protected UpdateListener updateListener;
    protected int visibleRows = -1;

    public NamespaceInfoTable(Composite parent) {
        this(parent, -1, -1, -1);
    }

    public NamespaceInfoTable(Composite parent, int visibleRows) {
        this(parent, -1, -1, visibleRows);
    }

    public NamespaceInfoTable(Composite parent, int widthHint, int heightHint) {
        this(parent, widthHint, heightHint, -1);
    }

    public NamespaceInfoTable(Composite parent, int widthHint, int heightHint, int visibleRows) {
        super(parent, 0);
        this.setLayout((Layout)this.createGridLayout());
        this.setLayoutData(new GridData(1808));
        Group namespaceInfoGroup = new Group((Composite)this, 0);
        namespaceInfoGroup.setText(XMLUIMessages._UI_LABEL_XML_SCHEMA_INFORMATION);
        namespaceInfoGroup.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        if (widthHint != -1) {
            gd.widthHint = widthHint;
        }
        if (heightHint != -1) {
            gd.heightHint = heightHint;
        }
        namespaceInfoGroup.setLayoutData((Object)gd);
        String[] titleArray = new String[]{NAMESPACE_URI, PREFIX, LOCATION_HINT};
        this.tableViewer = new TableViewer((Composite)namespaceInfoGroup, 65536);
        this.provider = new NamespaceInfoTableLabelProvider();
        this.tableViewer.setContentProvider((IContentProvider)this.provider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.provider);
        this.tableViewer.setColumnProperties(titleArray);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        int[] widthArray = new int[]{50, 20, 30};
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < titleArray.length) {
            TableColumn column = new TableColumn(table, i);
            column.setText(titleArray[i]);
            column.setAlignment(16384);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(widthArray[i], true));
            ++i;
        }
        this.visibleRows = visibleRows;
        i = 0;
        while (i < visibleRows) {
            TableItem item = new TableItem(table, 0);
            item.setText("#######");
            ++i;
        }
        table.setLayout((Layout)layout);
        CellEditor[] cellEditors = new CellEditor[titleArray.length];
        cellEditors[1] = new TextCellEditor((Composite)table);
        cellEditors[2] = new TextCellEditor((Composite)table);
        this.tableViewer.setCellEditors(cellEditors);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (NamespaceInfoTable.this.tableViewer.getTable().getItem(new Point(e.x, e.y)) != null) {
                    NamespaceInfoTable.this.performEdit();
                }
            }
        };
        table.addMouseListener((MouseListener)mouseAdapter);
        this.createButtons((Composite)namespaceInfoGroup);
        ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NamespaceInfoTable.this.updateButtonEnabledState();
            }
        };
        this.tableViewer.addSelectionChangedListener(selectionChangedListener);
    }

    protected void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        Button hiddenButton = new Button(composite, 0);
        hiddenButton.setLayoutData((Object)new GridData(768));
        hiddenButton.setVisible(false);
        hiddenButton.setEnabled(false);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == NamespaceInfoTable.this.newButton) {
                    NamespaceInfoTable.this.performNew();
                } else if (e.widget == NamespaceInfoTable.this.editButton) {
                    NamespaceInfoTable.this.performEdit();
                } else if (e.widget == NamespaceInfoTable.this.deleteButton) {
                    NamespaceInfoTable.this.performDelete();
                }
            }
        };
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayoutData((Object)new GridData(768));
        GridLayout buttonGridLayout = new GridLayout();
        buttonGridLayout.numColumns = 3;
        buttonGridLayout.makeColumnsEqualWidth = true;
        buttonComposite.setLayout((Layout)buttonGridLayout);
        this.newButton = new Button(buttonComposite, 0);
        this.newButton.setText(XMLUIMessages._UI_BUTTON_NEW);
        this.newButton.setLayoutData((Object)new GridData(768));
        this.newButton.addSelectionListener((SelectionListener)selectionListener);
        this.editButton = new Button(buttonComposite, 0);
        this.editButton.setText(XMLUIMessages._UI_BUTTON_EDIT);
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.addSelectionListener((SelectionListener)selectionListener);
        this.deleteButton = new Button(buttonComposite, 0);
        this.deleteButton.setText(XMLUIMessages._UI_BUTTON_DELETE);
        this.deleteButton.setLayoutData((Object)new GridData(768));
        this.deleteButton.addSelectionListener((SelectionListener)selectionListener);
    }

    public GridLayout createGridLayout() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        return gridLayout;
    }

    public List getNamespaceInfoList() {
        return this.namespaceInfoList;
    }

    protected NamespaceInfo getTargetNamespaceInfo() {
        return this.namespaceInfoList != null && this.namespaceInfoList.size() > 0 ? (NamespaceInfo)this.namespaceInfoList.get(0) : null;
    }

    protected EditNamespaceInfoDialog invokeDialog(String title, NamespaceInfo info) {
        Shell shell = XMLUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
        EditNamespaceInfoDialog dialog = new EditNamespaceInfoDialog(shell, info);
        dialog.create();
        dialog.getShell().setText(title);
        dialog.setBlockOnOpen(true);
        dialog.setResourceLocation(this.resourceLocation);
        dialog.open();
        return dialog;
    }

    protected void performDelayedUpdate() {
        Runnable delayedUpdate = new Runnable(){

            public void run() {
                NamespaceInfoTable.this.update();
            }
        };
        this.getDisplay().asyncExec(delayedUpdate);
        if (this.updateListener != null) {
            this.updateListener.updateOccured((Object)this, this.namespaceInfoList);
        }
    }

    public void performDelete() {
        Object selectedObject;
        ISelection selection = this.tableViewer.getSelection();
        Object object = selectedObject = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).getFirstElement() : null;
        if (selectedObject != null) {
            this.namespaceInfoList.remove(selectedObject);
            this.performDelayedUpdate();
        }
    }

    public void performEdit() {
        Object selectedObject;
        ISelection selection = this.tableViewer.getSelection();
        Object object = selectedObject = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).getFirstElement() : null;
        if (selectedObject instanceof NamespaceInfo) {
            this.invokeDialog(XMLUIMessages._UI_LABEL_NEW_NAMESPACE_INFORMATION, (NamespaceInfo)selectedObject);
            this.performDelayedUpdate();
        }
    }

    public void performNew() {
        NamespaceInfo info = new NamespaceInfo();
        EditNamespaceInfoDialog dialog = this.invokeDialog(XMLUIMessages._UI_LABEL_NEW_NAMESPACE_INFORMATION, info);
        if (dialog.getReturnCode() == 0) {
            this.namespaceInfoList.add(info);
            this.performDelayedUpdate();
        }
    }

    public void setNamespaceInfoList(List namespaceInfoList) {
        this.namespaceInfoList = namespaceInfoList;
        this.update();
    }

    public void setResourceLocation(IPath resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public void setUpdateListener(UpdateListener updateListener) {
        this.updateListener = updateListener;
    }

    public void update() {
        this.updateHelper(this.namespaceInfoList);
    }

    public void updateButtonEnabledState() {
        ISelection selection = this.tableViewer.getSelection();
        Object selectedObject = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).getFirstElement() : null;
        NamespaceInfo info = (NamespaceInfo)selectedObject;
        this.editButton.setEnabled(info != null);
        this.deleteButton.setEnabled(info != null && info.getProperty("unremovable") == null);
    }

    public void updateHelper(List namespaceInfoList) {
        if (this.visibleRows != -1 && !this.dummyRowsRemoved) {
            this.dummyRowsRemoved = true;
            this.tableViewer.getTable().removeAll();
        }
        ISelection selection = this.tableViewer.getSelection();
        this.tableViewer.setInput((Object)namespaceInfoList);
        if (selection.isEmpty()) {
            if (namespaceInfoList.size() > 0) {
                this.tableViewer.setSelection((ISelection)new StructuredSelection(namespaceInfoList.get(0)));
            }
        } else {
            this.tableViewer.setSelection(selection);
        }
    }

    protected class NamespaceInfoTableLabelProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        protected NamespaceInfoTableLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }

        public String getColumnText(Object object, int column) {
            NamespaceInfo info = (NamespaceInfo)object;
            String result = null;
            switch (column) {
                case 0: {
                    result = info.uri;
                    break;
                }
                case 1: {
                    result = info.prefix;
                    break;
                }
                case 2: {
                    result = info.locationHint;
                }
            }
            String string = result = result != null ? result : "";
            if (result.equals("")) {
                switch (column) {
                    case 0: {
                        result = XMLUIMessages._UI_NO_NAMESPACE_NAME;
                        break;
                    }
                    case 1: {
                        result = XMLUIMessages._UI_NO_PREFIX;
                    }
                }
            }
            return result;
        }

        String getDefaultPrefix() {
            String defaultPrefix = "p";
            if (NamespaceInfoTable.this.namespaceInfoList == null) {
                return defaultPrefix;
            }
            Vector<String> v = new Vector<String>();
            int i = 0;
            while (i < NamespaceInfoTable.this.namespaceInfoList.size()) {
                NamespaceInfo nsinfo = (NamespaceInfo)NamespaceInfoTable.this.namespaceInfoList.get(i);
                if (nsinfo.prefix != null) {
                    v.addElement(nsinfo.prefix);
                }
                ++i;
            }
            if (v.contains(defaultPrefix)) {
                String s = defaultPrefix;
                int j = 0;
                while (v.contains(s)) {
                    s = String.valueOf(defaultPrefix) + Integer.toString(j);
                    ++j;
                }
                return s;
            }
            return defaultPrefix;
        }

        public Object[] getElements(Object inputElement) {
            return NamespaceInfoTable.this.namespaceInfoList.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        public boolean isLabelProperty(Object object, Object property) {
            return false;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

