/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.jee.archive.ArchiveModelLoadException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class EJBUtilities
extends JavaEEProjectUtilities {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IVirtualComponent getEJBClientJar(IVirtualComponent ejbComponent) {
        if (!ejbComponent.isBinary()) {
            return EJBUtilities.getEJBClientJar(ejbComponent.getProject());
        }
        if (!ejbComponent.isBinary()) return null;
        JavaEEBinaryComponentHelper helper = null;
        try {
            IArchive archive;
            block17: {
                helper = new JavaEEBinaryComponentHelper(ejbComponent);
                archive = null;
                try {
                    archive = helper.accessArchive();
                    Path ddPath = new Path("META-INF/ejb-jar.xml");
                    if (!archive.containsArchiveResource((IPath)ddPath)) break block17;
                    Object jar = archive.getModelObject((IPath)ddPath);
                    String clientJAR = null;
                    if (jar != null) {
                        if (jar instanceof org.eclipse.jst.j2ee.ejb.EJBJar) {
                            clientJAR = ((org.eclipse.jst.j2ee.ejb.EJBJar)jar).getEjbClientJar();
                        } else if (jar instanceof EJBJar) {
                            clientJAR = ((EJBJar)jar).getEjbClientJar();
                        }
                    }
                    if (clientJAR == null) break block17;
                    IVirtualComponent earComponent = ComponentCore.createComponent((IProject)ejbComponent.getProject());
                    IVirtualReference[] refs = earComponent.getReferences();
                    int i = 0;
                    while (i < refs.length) {
                        if (refs[i].getArchiveName().equals(clientJAR)) {
                            IVirtualComponent iVirtualComponent = refs[i].getReferencedComponent();
                            if (archive == null) return iVirtualComponent;
                            helper.releaseArchive(archive);
                            return iVirtualComponent;
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    if (archive == null) throw throwable;
                    helper.releaseArchive(archive);
                    throw throwable;
                }
                {
                    catch (ArchiveModelLoadException e) {
                        J2EEPlugin.logError(e);
                        if (archive == null) return null;
                        helper.releaseArchive(archive);
                        return null;
                        break;
                    }
                }
            }
            if (archive == null) return null;
            helper.releaseArchive(archive);
            return null;
        }
        finally {
            if (helper != null) {
                helper.dispose();
            }
        }
    }

    public static List getAllEJBClientProjectsInWorkspace() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> result = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            if (EJBUtilities.isProjectOfType(projects[i], "jst.ejb")) {
                result.add(projects[i]);
            }
            ++i;
        }
        ArrayList<IProject> clientResult = new ArrayList<IProject>();
        for (IProject ejbProj : result) {
            IProject clientProj;
            IVirtualComponent ejbComponent = null;
            ejbComponent = ComponentCore.createComponent((IProject)ejbProj);
            if (ejbComponent == null) {
                return null;
            }
            Properties props = ejbComponent.getMetaProperties();
            String clientProjName = props.getProperty("ClientProject");
            if (clientProjName == null || (clientProj = J2EEProjectUtilities.getProject((String)clientProjName)) == null) continue;
            clientResult.add(clientProj);
        }
        return clientResult;
    }

    public static IVirtualComponent getEJBClientJar(IProject ejbProject) {
        Object jar = ModelProviderManager.getModelProvider(ejbProject).getModelObject();
        IVirtualComponent ejbClientComponent = null;
        IVirtualComponent ejbComponent = ComponentCore.createComponent((IProject)ejbProject);
        if (ejbComponent == null) {
            return null;
        }
        Properties props = ejbComponent.getMetaProperties();
        String clientCompName = props.getProperty("ClientProject");
        if (clientCompName != null && !clientCompName.equals("")) {
            IVirtualReference vRef = ejbComponent.getReference(clientCompName);
            if (vRef == null) {
                IProject[] earProjectsList = EarUtilities.getReferencingEARProjects(ejbProject);
                IVirtualComponent earComponent = null;
                int cnt = 0;
                while (cnt < earProjectsList.length && vRef == null) {
                    earComponent = ComponentCore.createComponent((IProject)earProjectsList[cnt]);
                    vRef = EarUtilities.getComponentReference(earComponent, clientCompName);
                    ++cnt;
                }
            }
            if (vRef != null) {
                ejbClientComponent = vRef.getReferencedComponent();
            }
        } else {
            String clientJAR = null;
            if (jar != null) {
                if (jar instanceof org.eclipse.jst.j2ee.ejb.EJBJar) {
                    clientJAR = ((org.eclipse.jst.j2ee.ejb.EJBJar)jar).getEjbClientJar();
                } else if (jar instanceof EJBJar) {
                    clientJAR = ((EJBJar)jar).getEjbClientJar();
                }
            }
            if (clientJAR != null) {
                clientJAR = clientJAR.substring(0, clientJAR.length() - 4);
                ejbComponent = ComponentCore.createComponent((IProject)ejbProject);
                if (ejbComponent == null) {
                    return null;
                }
                IVirtualReference ref = ejbComponent.getReference(clientJAR);
                if (ref != null) {
                    ejbClientComponent = ref.getReferencedComponent();
                }
            }
        }
        return ejbClientComponent;
    }

    public static boolean hasEJBClientJARProject(IProject ejbProject) {
        if (ejbProject == null) {
            return false;
        }
        return EJBUtilities.getEJBClientJar(ejbProject) != null;
    }

    public static boolean isEJBClientProject(IProject compProject) {
        if (compProject == null) {
            return false;
        }
        return EJBUtilities.getAllEJBClientProjectsInWorkspace().contains(compProject);
    }
}

