/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.componentcore;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.archive.JavaEEEMFZipFileLoadAdapterImpl;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.jst.jee.archive.internal.ArchiveUtil;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;

public class JavaEEBinaryComponentLoadAdapter
extends JavaEEEMFZipFileLoadAdapterImpl {
    private File file = null;
    private IPath archivePath;
    private boolean physicallyOpen = true;
    private VirtualArchiveComponent archiveComponent;

    public JavaEEBinaryComponentLoadAdapter(VirtualArchiveComponent archiveComponent) throws ArchiveOpenFailureException {
        this.archiveComponent = archiveComponent;
        IPath archivePath = this.recomputeArchivePath();
        if (archivePath != null) {
            try {
                this.resetZipFile(archivePath);
            }
            catch (ZipException e) {
                ArchiveOpenFailureException openFailureException = new ArchiveOpenFailureException(archivePath, this.file.getAbsolutePath(), (Throwable)e);
                throw openFailureException;
            }
            catch (IOException e) {
                ArchiveOpenFailureException openFailureException = new ArchiveOpenFailureException(archivePath, this.file.getAbsolutePath(), (Throwable)e);
                throw openFailureException;
            }
        } else {
            ArchiveOpenFailureException openFailureException = new ArchiveOpenFailureException(String.valueOf(new String()) + null);
            throw openFailureException;
        }
    }

    private void resetZipFile(IPath archivePath) throws ZipException, IOException {
        this.file = new File(archivePath.toOSString());
        ZipFile zipFile = ArchiveUtil.newZipFile((File)this.file);
        this.setZipFile(zipFile);
        this.setArchivePath(archivePath);
    }

    private IPath recomputeArchivePath() {
        IFile wbFile;
        File f = (File)this.archiveComponent.getAdapter(File.class);
        if (!(f != null && f.exists() || (wbFile = (IFile)this.archiveComponent.getAdapter(IFile.class)) == null)) {
            f = new File(wbFile.getLocation().toOSString());
        }
        return f == null ? null : new Path(f.getAbsolutePath());
    }

    private void setArchivePath(IPath archivePath) {
        this.archivePath = archivePath;
    }

    public IPath getArchivePath() {
        return this.archivePath;
    }

    public boolean isPhysicallyOpen() {
        return this.physicallyOpen;
    }

    public void physicallyOpen() throws ZipException, IOException {
        if (!this.isPhysicallyOpen()) {
            if (this.file != null && this.file.exists()) {
                this.setZipFile(ArchiveUtil.newZipFile((File)this.file));
            } else {
                IPath newPath = this.recomputeArchivePath();
                if (newPath == this.archivePath || newPath == null || newPath.equals((Object)this.archivePath)) {
                    String loc = this.archivePath == null ? null : this.archivePath.toOSString();
                    throw new FileNotFoundException(loc);
                }
                this.resetZipFile(newPath);
            }
            this.physicallyOpen = true;
        }
    }

    public void physicallyClose() {
        if (this.isPhysicallyOpen()) {
            this.physicallyOpen = false;
            try {
                this.zipFile.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean containsArchiveResource(IPath resourcePath) {
        boolean isPhysciallyOpen = this.isPhysicallyOpen();
        Exception caughtException = null;
        try {
            if (!isPhysciallyOpen) {
                this.physicallyOpen();
            }
            try {
                boolean bl = super.containsArchiveResource(resourcePath);
                return bl;
            }
            catch (Exception exception) {
                try {
                    J2EEPlugin.logError(caughtException);
                }
                catch (Exception e) {
                    caughtException = e;
                    J2EEPlugin.logError(caughtException);
                }
            }
        }
        finally {
            if (caughtException != null && !isPhysciallyOpen) {
                this.physicallyClose();
            }
        }
        return false;
    }

    public IArchiveResource getArchiveResource(IPath filePath) {
        boolean isPhysciallyOpen = this.isPhysicallyOpen();
        Exception caughtException = null;
        try {
            if (!isPhysciallyOpen) {
                this.physicallyOpen();
            }
            try {
                IArchiveResource iArchiveResource = super.getArchiveResource(filePath);
                return iArchiveResource;
            }
            catch (Exception exception) {
                try {
                    J2EEPlugin.logError(caughtException);
                }
                catch (Exception e) {
                    caughtException = e;
                    J2EEPlugin.logError(caughtException);
                }
            }
        }
        finally {
            if (caughtException != null && !isPhysciallyOpen) {
                this.physicallyClose();
            }
        }
        return null;
    }

    public List getArchiveResources() {
        boolean isPhysciallyOpen = this.isPhysicallyOpen();
        Exception caughtException = null;
        try {
            if (!isPhysciallyOpen) {
                this.physicallyOpen();
            }
            try {
                List list = super.getArchiveResources();
                return list;
            }
            catch (Exception exception) {
                try {
                    J2EEPlugin.logError(caughtException);
                }
                catch (Exception e) {
                    caughtException = e;
                    J2EEPlugin.logError(caughtException);
                }
            }
        }
        finally {
            if (caughtException != null && !isPhysciallyOpen) {
                this.physicallyClose();
            }
        }
        return Collections.EMPTY_LIST;
    }

    public InputStream getInputStream(IArchiveResource aFile) throws IOException, FileNotFoundException {
        final boolean isPhysciallyOpen = this.isPhysicallyOpen();
        Exception caughtException = null;
        try {
            if (!isPhysciallyOpen) {
                this.physicallyOpen();
            }
            IPath path = aFile.getPath();
            String uri = path.toString();
            ZipEntry entry = this.getZipFile().getEntry(uri);
            if (entry == null) {
                throw new FileNotFoundException(uri);
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getZipFile().getInputStream(entry)){

                public void close() throws IOException {
                    super.close();
                    if (!isPhysciallyOpen) {
                        JavaEEBinaryComponentLoadAdapter.this.physicallyClose();
                    }
                }
            };
            return bufferedInputStream;
        }
        catch (FileNotFoundException e) {
            caughtException = e;
            throw e;
        }
        catch (IllegalStateException zipClosed) {
            caughtException = zipClosed;
            throw new IOException(zipClosed.toString());
        }
        catch (Exception e) {
            caughtException = e;
            throw new IOException(e.toString());
        }
        finally {
            if (caughtException != null && !isPhysciallyOpen) {
                this.physicallyClose();
            }
        }
    }

    public VirtualArchiveComponent getArchiveComponent() {
        return this.archiveComponent;
    }
}

