/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestExtension;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestRegistry;
import org.eclipse.wst.command.internal.env.core.ICommandFactory;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceTester;
import org.eclipse.wst.ws.internal.wsrt.TestInfo;

public class WSDLTestLaunchCommand
extends AbstractDataModelOperation {
    private String testID;
    private String launchedServiceTestName;
    private TypeRuntimeServer serviceids;
    private String serverProject;
    private String serverModule;
    private String wsdlURI;
    private boolean externalBrowser;
    private List endpoints;
    private IServer serviceExistingServer = null;
    private String serviceServerTypeID = null;
    private String serviceServerInstanceId = null;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        TestInfo testInfo;
        IEnvironment env = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        WebServiceTestRegistry testRegistry = WebServiceTestRegistry.getInstance();
        WebServiceTestExtension wscte = (WebServiceTestExtension)testRegistry.getWebServiceExtensionsByName(this.testID);
        IWebServiceTester iwst = (IWebServiceTester)wscte.getWebServiceExecutableExtension();
        status = this.commandFactoryExecution(iwst.launch(testInfo = this.getTestInfo()), env, monitor);
        if (status.getSeverity() != 0) {
            IStatusHandler sHandler = env.getStatusHandler();
            IStatus infoStatus = StatusUtils.infoStatus((String)ConsumptionUIMessages.MSG_ERROR_UNABLE_TO_LAUNCH_WSDL_TEST);
            sHandler.reportInfo(infoStatus);
            return infoStatus;
        }
        return status;
    }

    private IStatus commandFactoryExecution(ICommandFactory commandFactory, IEnvironment env, IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        while (commandFactory.hasNext()) {
            AbstractDataModelOperation operation = commandFactory.getNextCommand();
            if (operation != null) {
                try {
                    operation.setEnvironment(env);
                    status = operation.execute(monitor, null);
                }
                catch (Exception exc) {
                    status = StatusUtils.errorStatus((Throwable)exc);
                }
            }
            if (status.getSeverity() != 4) continue;
            IStatusHandler sHandler = env.getStatusHandler();
            sHandler.reportError(status);
            return status;
        }
        return status;
    }

    private TestInfo getTestInfo() {
        if (this.serviceids.getServerInstanceId() != null) {
            this.serviceExistingServer = ServerCore.findServer((String)this.serviceids.getServerInstanceId());
        } else if (this.serviceServerInstanceId != null) {
            this.serviceExistingServer = ServerCore.findServer((String)this.serviceServerInstanceId);
        }
        this.serviceServerTypeID = this.serviceExistingServer != null ? this.serviceExistingServer.getServerType().getId() : this.serviceids.getServerId();
        TestInfo testInfo = new TestInfo();
        if (this.serviceExistingServer != null) {
            testInfo.setServiceExistingServer(this.serviceExistingServer);
        }
        testInfo.setServiceServerTypeID(this.serviceServerTypeID);
        testInfo.setServiceProject(this.serverProject);
        testInfo.setWsdlServiceURL(this.wsdlURI);
        testInfo.setExternalBrowser(this.externalBrowser);
        testInfo.setEndpoint(this.endpoints);
        return testInfo;
    }

    public void setTestID(String testID) {
        this.testID = testID;
    }

    public String getLaunchedServiceTestName() {
        return this.launchedServiceTestName;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public void setServerProject(String serverProject) {
        this.serverProject = serverProject;
    }

    public void setServiceTypeRuntimeServer(TypeRuntimeServer serviceids) {
        this.serviceids = serviceids;
    }

    public void setExternalBrowser(boolean externalBrowser) {
        this.externalBrowser = externalBrowser;
    }

    public void setEndpoint(List endpoints) {
        this.endpoints = endpoints;
    }

    public String getServerModule() {
        return this.serverModule;
    }

    public void setServerModule(String serverModule) {
        this.serverModule = serverModule;
    }

    public void setServiceServerInstanceId(String ssInstanceId) {
        this.serviceServerInstanceId = ssInstanceId;
    }
}

