/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.core.annotations.validation;

import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.Collection;
import javax.jws.WebService;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;

public class WebServiceNoFinalizeMethodRule
extends AbstractAnnotationProcessor {
    public void process() {
        AnnotationTypeDeclaration annotationDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(WebService.class.getName());
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(annotationDeclaration);
        for (Declaration declaration : annotatedTypes) {
            MethodDeclaration finalizeMethod = this.getFinalizeMethod(declaration);
            if (finalizeMethod == null) continue;
            this.printFixableError(finalizeMethod.getPosition(), JAXWSCoreMessages.WEBSERVICE_OVERRIDE_FINALIZE);
        }
    }

    private MethodDeclaration getFinalizeMethod(Declaration declaration) {
        if (declaration instanceof TypeDeclaration) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)declaration;
            Collection methodDeclarations = typeDeclaration.getMethods();
            for (MethodDeclaration methodDeclaration : methodDeclarations) {
                if (!methodDeclaration.getSimpleName().equals("finalize") || methodDeclaration.getParameters().size() != 0) continue;
                return methodDeclaration;
            }
        }
        return null;
    }
}

