/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.tabletree;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDescriptionBuilder;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.ui.internal.tabletree.TreeContentHelper;
import org.eclipse.wst.xml.ui.internal.tabletree.TreeExtension;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLEditorMessages;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLTableTreePropertyDescriptorFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLTreeExtension
extends TreeExtension {
    public static final String STRUCTURE_PROPERTY = XMLEditorMessages.XMLTreeExtension_0;
    public static final String VALUE_PROPERTY = XMLEditorMessages.XMLTreeExtension_1;
    protected Composite control;
    protected MyCellModifier modifier;
    protected XMLTableTreePropertyDescriptorFactory propertyDescriptorFactory;
    protected CMDescriptionBuilder decriptionBuilder = new CMDescriptionBuilder();
    protected TreeContentHelper treeContentHelper = new TreeContentHelper();
    protected Color f1;
    protected Color f2;
    protected Color b1;
    protected Color b2;
    protected boolean cachedDataIsValid = true;

    public XMLTreeExtension(Tree tree) {
        super(tree);
        this.control = tree;
        this.modifier = new MyCellModifier();
        this.setCellModifier(this.modifier);
        String[] properties = new String[]{STRUCTURE_PROPERTY, VALUE_PROPERTY};
        this.setColumnProperties(properties);
        this.f1 = tree.getDisplay().getSystemColor(24);
        Color background = tree.getDisplay().getSystemColor(25);
        int r = Math.abs(background.getRed() - 125);
        int g = Math.abs(background.getGreen() - 85);
        int b = Math.abs(background.getBlue() - 105);
        this.f2 = new Color((Device)tree.getDisplay(), r, g, b);
        this.b1 = tree.getDisplay().getSystemColor(26);
        this.b2 = background;
        this.propertyDescriptorFactory = new XMLTableTreePropertyDescriptorFactory();
    }

    public void dispose() {
        super.dispose();
        this.f2.dispose();
    }

    public void resetCachedData() {
        this.cachedDataIsValid = false;
    }

    public void paintItems(GC gc, TreeItem[] items, Rectangle treeBounds) {
        super.paintItems(gc, items, treeBounds);
        this.cachedDataIsValid = true;
    }

    protected Object[] computeTreeExtensionData(Object object) {
        Color color = this.f1;
        String string = "";
        if (string.length() == 0) {
            string = (String)this.modifier.getValue(object, VALUE_PROPERTY);
            color = this.f1;
        }
        if (string.length() == 0 && object instanceof Element) {
            string = this.getElementValueHelper((Element)object);
            color = this.f2;
        }
        Object[] data = new Object[]{string, color};
        return data;
    }

    protected void paintItem(GC gc, TreeItem item, Rectangle bounds) {
        super.paintItem(gc, item, bounds);
        Object[] data = this.computeTreeExtensionData(item.getData());
        if (data != null && data.length == 2) {
            gc.setClipping(this.columnPosition, bounds.y + 1, this.controlWidth, bounds.height);
            gc.setForeground((Color)data[1]);
            gc.drawString((String)data[0], this.columnPosition + 5, bounds.y + 1);
            gc.setClipping(null);
        }
    }

    protected void addEmptyTreeMessage(GC gc) {
        gc.setForeground(this.fTree.getDisplay().getSystemColor(2));
        gc.setBackground(this.fTree.getDisplay().getSystemColor(25));
        gc.drawString(XMLEditorMessages.XMLTreeExtension_3, 10, 10);
        gc.drawString(XMLEditorMessages.XMLTreeExtension_4, 10, 10 + gc.getFontMetrics().getHeight());
    }

    public String getElementValueHelper(Element element) {
        CMElementDeclaration ed;
        String result = null;
        ModelQuery mq = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
        if (result == null && mq != null && (ed = mq.getCMElementDeclaration(element)) != null && !Boolean.TRUE.equals(ed.getProperty("isInferred"))) {
            result = this.decriptionBuilder.buildDescription((CMNode)ed);
        }
        return result != null ? result : "";
    }

    public class MyCellModifier
    implements ICellModifier,
    TreeExtension.ICellEditorProvider {
        public boolean canModify(Object element, String property) {
            boolean result = false;
            if (element instanceof Node) {
                Node node = (Node)element;
                result = property == VALUE_PROPERTY && XMLTreeExtension.this.treeContentHelper.isEditable(node);
            }
            return result;
        }

        public Object getValue(Object object, String property) {
            String result = null;
            if (object instanceof Node) {
                result = XMLTreeExtension.this.treeContentHelper.getNodeValue((Node)object);
            }
            return result != null ? result : "";
        }

        public void modify(Object element, String property, Object value) {
            Item item = (Item)element;
            String oldValue = XMLTreeExtension.this.treeContentHelper.getNodeValue((Node)item.getData());
            String newValue = value.toString();
            if (newValue != null && !newValue.equals(oldValue)) {
                XMLTreeExtension.this.treeContentHelper.setNodeValue((Node)item.getData(), value.toString());
            }
        }

        public CellEditor getCellEditor(Object o, int col) {
            IPropertyDescriptor pd = XMLTreeExtension.this.propertyDescriptorFactory.createPropertyDescriptor(o);
            return pd != null ? pd.createPropertyEditor(XMLTreeExtension.this.control) : null;
        }
    }
}

