/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wst.sse.core.internal.util.Utilities;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.view.events.CaretEvent;
import org.eclipse.wst.sse.ui.internal.view.events.ICaretListener;

public class CaretMediator
implements Listener {
    RefreshDelayJob fDelayer = null;
    private static final int DELAY = 300;
    private long endTime;
    private long startTime;
    protected ICaretListener[] fCaretListeners;
    protected CaretMediatorListener internalListener;
    protected StyledText textWidget;

    public CaretMediator() {
    }

    public CaretMediator(StyledText styledTextWidget) {
        this();
        this.setTextWidget(styledTextWidget);
    }

    public synchronized void addCaretListener(ICaretListener listener) {
        if (!Utilities.contains((Object[])this.fCaretListeners, (Object)listener)) {
            int oldSize = 0;
            if (this.fCaretListeners != null) {
                oldSize = this.fCaretListeners.length;
            }
            int newSize = oldSize + 1;
            ICaretListener[] newListeners = new ICaretListener[newSize];
            if (this.fCaretListeners != null) {
                System.arraycopy(this.fCaretListeners, 0, newListeners, 0, oldSize);
            }
            newListeners[newSize - 1] = listener;
            this.fCaretListeners = newListeners;
        }
    }

    protected void fireCaretEvent(CaretEvent event) {
        if (this.fCaretListeners != null) {
            ICaretListener[] holdListeners = this.fCaretListeners;
            int i = 0;
            while (i < holdListeners.length) {
                holdListeners[i].caretMoved(event);
                ++i;
            }
        }
    }

    public void handleEvent(Event e) {
        Display display = null;
        if (this.textWidget != null && !this.textWidget.isDisposed() && (display = this.textWidget.getDisplay()) != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (CaretMediator.this.textWidget != null && !CaretMediator.this.textWidget.isDisposed()) {
                        CaretMediator.this.fireCaretEvent(new CaretEvent(CaretMediator.this.textWidget, CaretMediator.this.textWidget.getCaretOffset()));
                    }
                }
            });
        }
    }

    protected void internalKeyPressed(KeyEvent e) {
        this.fDelayer.cancel();
    }

    protected void internalKeyReleased(KeyEvent e) {
        switch (e.keyCode) {
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000003: 
            case 0x1000004: 
            case 0x1000005: 
            case 0x1000006: 
            case 0x1000007: 
            case 0x1000008: {
                this.fDelayer.touch();
                break;
            }
            default: {
                this.fDelayer.touch();
            }
        }
    }

    protected void internalMouseDown(MouseEvent e) {
        this.fDelayer.cancel();
    }

    protected void internalMouseUp(MouseEvent e) {
        this.fDelayer.touch();
    }

    public void release() {
        this.fDelayer.cancel();
        if (this.textWidget != null && !this.textWidget.isDisposed()) {
            this.textWidget.removeKeyListener((KeyListener)this.internalListener);
            this.textWidget.removeMouseListener((MouseListener)this.internalListener);
            this.textWidget = null;
        }
    }

    public synchronized void removeCaretListener(ICaretListener listener) {
        if (this.fCaretListeners != null && listener != null && Utilities.contains((Object[])this.fCaretListeners, (Object)listener)) {
            int oldSize = this.fCaretListeners.length;
            int newSize = oldSize - 1;
            ICaretListener[] newListeners = new ICaretListener[newSize];
            int index = 0;
            int i = 0;
            while (i < oldSize) {
                if (this.fCaretListeners[i] != listener) {
                    newListeners[index++] = this.fCaretListeners[i];
                }
                ++i;
            }
            this.fCaretListeners = newListeners;
        }
    }

    public void setTextWidget(StyledText newTextWidget) {
        if (this.fDelayer == null) {
            this.fDelayer = new RefreshDelayJob(300);
        }
        if (this.textWidget != null) {
            this.fDelayer.cancel();
            this.textWidget.removeKeyListener((KeyListener)this.internalListener);
            this.textWidget.removeMouseListener((MouseListener)this.internalListener);
        }
        this.textWidget = newTextWidget;
        if (this.internalListener == null) {
            this.internalListener = new CaretMediatorListener();
        }
        if (this.textWidget != null) {
            this.textWidget.addKeyListener((KeyListener)this.internalListener);
            this.textWidget.addMouseListener((MouseListener)this.internalListener);
        }
    }

    class CaretMediatorListener
    implements KeyListener,
    MouseListener {
        CaretMediatorListener() {
        }

        public void keyPressed(KeyEvent e) {
            CaretMediator.this.internalKeyPressed(e);
        }

        public void keyReleased(KeyEvent e) {
            CaretMediator.this.internalKeyReleased(e);
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            CaretMediator.this.internalMouseDown(e);
        }

        public void mouseUp(MouseEvent e) {
            CaretMediator.this.internalMouseUp(e);
        }
    }

    class RefreshDelayJob
    extends Job {
        private int fDelay = 0;

        RefreshDelayJob(int delay) {
            super(SSEUIMessages.caret_update);
            this.setSystem(true);
            this.fDelay = delay;
        }

        void touch() {
            this.cancel();
            this.schedule(this.fDelay);
        }

        protected IStatus run(IProgressMonitor monitor) {
            CaretMediator.this.handleEvent(null);
            return Status.OK_STATUS;
        }
    }
}

