/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.page;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TasksLayout
extends Layout {
    private int verticalSpacing;

    public TasksLayout(int verticalSpacing) {
        this.verticalSpacing = verticalSpacing;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Control[] children = composite.getChildren();
        int y = 5;
        if (children != null) {
            int size = children.length;
            int i = 0;
            while (i < size) {
                int h;
                if (i % 2 == 0) {
                    h = children[i].computeSize((int)wHint, (int)-1).y;
                    y += h + this.verticalSpacing / 2;
                } else {
                    h = Math.max(45, children[i].computeSize((int)wHint, (int)-1).y);
                    y += h + this.verticalSpacing;
                }
                ++i;
            }
        }
        return new Point(200, y);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Control[] children = composite.getChildren();
        Rectangle r = composite.getClientArea();
        int y = r.y + 5;
        if (children != null) {
            int size = children.length;
            int i = 0;
            while (i < size) {
                int h;
                if (i % 2 == 0) {
                    h = children[i].computeSize((int)(r.width - 10), (int)-1).y;
                    children[i].setBounds(r.x + 5, y, r.width - 10, h);
                    y += h + this.verticalSpacing / 2;
                } else {
                    h = Math.max(45, children[i].computeSize((int)(r.width - 25), (int)-1).y);
                    children[i].setBounds(r.x + 20, y, r.width - 25, h);
                    y += h + this.verticalSpacing;
                }
                ++i;
            }
        }
    }
}

