/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.core.utils;

import com.sun.mirror.declaration.AnnotationMirror;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jws.soap.SOAPBinding;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCorePlugin;

public final class JAXWSUtils {
    public static final String ACTION = "action";
    public static final String ARG = "arg";
    public static final String CLASS_NAME = "className";
    public static final String DOT_CHARACTER = ".";
    public static final String ENDPOINT_INTERFACE = "endpointInterface";
    public static final String EXCLUDE = "exclude";
    public static final String FAULT_BEAN = "faultBean";
    public static final String FINALIZE = "finalize";
    public static final String HEADER = "header";
    public static final String JAXWS_SUBPACKAGE = "jaxws";
    public static final String LOCAL_NAME = "localName";
    public static final String MODE = "mode";
    public static final String NAME = "name";
    public static final String OPERATION_NAME = "operationName";
    public static final String PARAMETER_STYLE = "parameterStyle";
    public static final String PART_NAME = "partName";
    public static final String PORT_NAME = "portName";
    public static final String PORT_SUFFIX = "Port";
    public static final String RESPONSE = "Response";
    public static final String RESPONSE_SUFFIX = "Response";
    public static final String RETURN = "return";
    public static final String SERVICE_NAME = "serviceName";
    public static final String SERVICE_SUFFIX = "Service";
    public static final String STYLE = "style";
    public static final String TARGET_NAMESPACE = "targetNamespace";
    public static final String TRUE = "true";
    public static final String TYPE = "type";
    public static final String USE = "use";
    public static final String WSDL_LOCATION = "wsdlLocation";
    public static final String VALUE = "value";

    private JAXWSUtils() {
    }

    public static boolean isDocumentBare(AnnotationMirror mirror) {
        String style = AnnotationUtils.getStringValue((AnnotationMirror)mirror, (String)STYLE);
        String use = AnnotationUtils.getStringValue((AnnotationMirror)mirror, (String)USE);
        String parameterStyle = AnnotationUtils.getStringValue((AnnotationMirror)mirror, (String)PARAMETER_STYLE);
        return JAXWSUtils.isDocumentBare(style, use, parameterStyle);
    }

    public static boolean isDocumentBare(IAnnotation annotation) {
        try {
            String style = AnnotationUtils.getEnumValue((IAnnotation)annotation, (String)STYLE);
            String use = AnnotationUtils.getEnumValue((IAnnotation)annotation, (String)USE);
            String parameterStyle = AnnotationUtils.getEnumValue((IAnnotation)annotation, (String)PARAMETER_STYLE);
            return JAXWSUtils.isDocumentBare(style, use, parameterStyle);
        }
        catch (JavaModelException jme) {
            JAXWSCorePlugin.log(jme.getStatus());
            return false;
        }
    }

    public static boolean isDocumentBare(Annotation annotation) {
        String style = AnnotationUtils.getEnumValue((Annotation)annotation, (String)STYLE);
        String use = AnnotationUtils.getEnumValue((Annotation)annotation, (String)USE);
        String parameterStyle = AnnotationUtils.getEnumValue((Annotation)annotation, (String)PARAMETER_STYLE);
        return JAXWSUtils.isDocumentBare(style, use, parameterStyle);
    }

    public static boolean isDocumentBare(String style, String use, String parameterStyle) {
        return !(style != null && !style.equals(SOAPBinding.Style.DOCUMENT.name()) || use != null && !use.equals(SOAPBinding.Use.LITERAL.name()) || parameterStyle == null || !parameterStyle.equals(SOAPBinding.ParameterStyle.BARE.name()));
    }

    public static boolean isDocumentWrapped(AnnotationMirror mirror) {
        String style = AnnotationUtils.getStringValue((AnnotationMirror)mirror, (String)STYLE);
        String use = AnnotationUtils.getStringValue((AnnotationMirror)mirror, (String)USE);
        String parameterStyle = AnnotationUtils.getStringValue((AnnotationMirror)mirror, (String)PARAMETER_STYLE);
        return JAXWSUtils.isDocumentWrapped(style, use, parameterStyle);
    }

    public static boolean isDocumentWrapped(IAnnotation annotation) {
        try {
            String style = AnnotationUtils.getEnumValue((IAnnotation)annotation, (String)STYLE);
            String use = AnnotationUtils.getEnumValue((IAnnotation)annotation, (String)USE);
            String parameterStyle = AnnotationUtils.getEnumValue((IAnnotation)annotation, (String)PARAMETER_STYLE);
            return JAXWSUtils.isDocumentWrapped(style, use, parameterStyle);
        }
        catch (JavaModelException jme) {
            JAXWSCorePlugin.log(jme.getStatus());
            return true;
        }
    }

    public static boolean isDocumentWrapped(Annotation annotation) {
        String style = AnnotationUtils.getEnumValue((Annotation)annotation, (String)STYLE);
        String use = AnnotationUtils.getEnumValue((Annotation)annotation, (String)USE);
        String parameterStyle = AnnotationUtils.getEnumValue((Annotation)annotation, (String)PARAMETER_STYLE);
        return JAXWSUtils.isDocumentWrapped(style, use, parameterStyle);
    }

    public static boolean isDocumentWrapped(String style, String use, String parameterStyle) {
        return !(style != null && !style.equals(SOAPBinding.Style.DOCUMENT.name()) || use != null && !use.equals(SOAPBinding.Use.LITERAL.name()) || parameterStyle != null && !parameterStyle.equals(SOAPBinding.ParameterStyle.WRAPPED.name()));
    }

    public static String accountForOverloadedMethods(IMethod method) throws JavaModelException {
        IType type = method.getDeclaringType();
        if (type == null) {
            return "";
        }
        List<IMethod> methods = Arrays.asList(type.getMethods());
        ArrayList<IMethod> similarMethods = new ArrayList<IMethod>();
        for (IMethod methodToTest : methods) {
            if (method.equals(methodToTest) || !method.getElementName().equalsIgnoreCase(methodToTest.getElementName()) || methodToTest.getSourceRange().getOffset() >= method.getSourceRange().getOffset()) continue;
            similarMethods.add(methodToTest);
        }
        return similarMethods.size() > 0 ? Integer.toString(similarMethods.size()) : "";
    }
}

