/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDescriptionBuilder;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMContentBuilder;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMContentBuilderImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceHelper;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.actions.BaseNodeActionManager;
import org.eclipse.wst.xml.ui.internal.actions.EditAttributeAction;
import org.eclipse.wst.xml.ui.internal.actions.EditDoctypeAction;
import org.eclipse.wst.xml.ui.internal.actions.EditElementAction;
import org.eclipse.wst.xml.ui.internal.actions.EditProcessingInstructionAction;
import org.eclipse.wst.xml.ui.internal.actions.EditSchemaInfoAction;
import org.eclipse.wst.xml.ui.internal.actions.NodeAction;
import org.eclipse.wst.xml.ui.internal.editor.CMImageUtil;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public abstract class AbstractNodeActionManager
extends BaseNodeActionManager {
    protected ImageDescriptorCache imageDescriptorCache = new ImageDescriptorCache();
    protected Viewer fViewer;

    public AbstractNodeActionManager(IStructuredModel model, ModelQuery modelQuery, Viewer viewer) {
        super(model, modelQuery);
        this.fViewer = viewer;
    }

    public void beginNodeAction(NodeAction action) {
        this.fModel.beginRecording((Object)action, action.getUndoDescription());
    }

    protected Action createAddAttributeAction(Element parent, CMAttributeDeclaration ad) {
        NodeAction action = null;
        action = ad == null ? new EditAttributeAction(this, parent, null, XMLUIMessages._UI_MENU_NEW_ATTRIBUTE, XMLUIMessages._UI_MENU_NEW_ATTRIBUTE_TITLE) : new AddNodeAction((CMNode)ad, (Node)parent, -1);
        return action;
    }

    protected Action createAddCDataSectionAction(Node parent, int index) {
        return new AddNodeAction(4, parent, index);
    }

    protected Action createAddCommentAction(Node parent, int index) {
        return new AddNodeAction(8, parent, index);
    }

    protected Action createAddDoctypeAction(Document document, int index) {
        return new EditDoctypeAction(this.fModel, document, this.fModel.getBaseLocation(), XMLUIMessages._UI_MENU_ADD_DTD_INFORMATION);
    }

    protected Action createAddElementAction(Node parent, CMElementDeclaration ed, int index) {
        NodeAction action = null;
        action = ed == null ? new EditElementAction(this, parent, index, XMLUIMessages._UI_MENU_NEW_ELEMENT, XMLUIMessages._UI_MENU_NEW_ELEMENT_TITLE) : new AddNodeAction((CMNode)ed, parent, index);
        return action;
    }

    protected Action createAddPCDataAction(Node parent, CMDataType dataType, int index) {
        AddNodeAction action = null;
        action = dataType == null ? new AddNodeAction(3, parent, index) : new AddNodeAction((CMNode)dataType, parent, index);
        return action;
    }

    protected Action createAddProcessingInstructionAction(Node parent, int index) {
        Node refChild = this.getRefChildNodeAtIndex(parent, index);
        EditProcessingInstructionAction action = new EditProcessingInstructionAction(this, parent, refChild, XMLUIMessages._UI_MENU_ADD_PROCESSING_INSTRUCTION, XMLUIMessages.ADD_PROCESSING_INSTRUCTION);
        action.setImageDescriptor(this.imageDescriptorCache.getImageDescriptor(new Integer(7)));
        return action;
    }

    protected Action createAddSchemaInfoAction(Element element) {
        return new EditSchemaInfoAction(this, element.getOwnerDocument(), this.fModel.getBaseLocation(), XMLUIMessages._UI_MENU_ADD_SCHEMA_INFORMATION);
    }

    protected Action createDeleteAction(List selection) {
        DeleteAction deleteAction = new DeleteAction(selection);
        deleteAction.setEnabled(selection.size() > 0);
        return deleteAction;
    }

    public DOMContentBuilder createDOMContentBuilder(Document document) {
        DOMContentBuilderImpl builder = new DOMContentBuilderImpl(document);
        return builder;
    }

    protected Action createEditAttributeAction(Attr attr, CMAttributeDeclaration ad) {
        return new EditAttributeAction(this, attr.getOwnerElement(), attr, XMLUIMessages._UI_MENU_EDIT_ATTRIBUTE, XMLUIMessages._UI_MENU_EDIT_ATTRIBUTE_TITLE);
    }

    protected Action createEditDoctypeAction(DocumentType doctype) {
        return new EditDoctypeAction(this.fModel, doctype, this.fModel.getBaseLocation(), XMLUIMessages._UI_MENU_EDIT_DOCTYPE);
    }

    protected Action createEditProcessingInstructionAction(ProcessingInstruction pi) {
        return new EditProcessingInstructionAction(this, pi, XMLUIMessages._UI_MENU_EDIT_PROCESSING_INSTRUCTION, XMLUIMessages._UI_MENU_EDIT_PROCESSING_INSTRUCTION_TITLE);
    }

    protected Action createEditSchemaInfoAction(Element element) {
        return new EditSchemaInfoAction(this, element.getOwnerDocument(), this.fModel.getBaseLocation(), XMLUIMessages._UI_MENU_EDIT_NAMESPACES);
    }

    protected Action createRenameAction(Node node) {
        EditElementAction result = null;
        if (node instanceof Element) {
            result = new EditElementAction(this, (Element)node, XMLUIMessages._UI_MENU_RENAME, XMLUIMessages._UI_MENU_RENAME_TITLE);
        }
        return result;
    }

    protected Action createReplaceAction(Node parent, CMNode cmnode, int startIndex, int endIndex) {
        return new ReplaceNodeAction(parent, cmnode, startIndex, endIndex);
    }

    public void endNodeAction(NodeAction action) {
        this.fModel.endRecording((Object)action);
    }

    public void fillContextMenu(IMenuManager menuManager, ISelection selection) {
        try {
            ArrayList selectionList = new ArrayList();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection es = (IStructuredSelection)selection;
                selectionList.addAll(es.toList());
            }
            this.contributeActions(menuManager, selectionList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getLabel(Node parent, CMNode cmnode) {
        String result = "?" + cmnode + "?";
        if (cmnode != null) {
            result = cmnode.getNodeName();
            if (result == null) {
                result = (String)cmnode.getProperty("description");
            }
            if (result == null || result.length() == 0) {
                if (cmnode.getNodeType() == 7) {
                    CMDescriptionBuilder descriptionBuilder = new CMDescriptionBuilder();
                    result = descriptionBuilder.buildDescription(cmnode);
                } else {
                    result = DOMNamespaceHelper.computeName((CMNode)cmnode, (Node)parent, null);
                }
            }
        }
        return result;
    }

    public IStructuredModel getModel() {
        return this.fModel;
    }

    public Shell getWorkbenchWindowShell() {
        return XMLUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public void insert(Node parent, CMNode cmnode, int index) {
        Document document = parent.getNodeType() == 9 ? (Document)parent : parent.getOwnerDocument();
        DOMContentBuilder builder = this.createDOMContentBuilder(document);
        builder.setBuildPolicy(12);
        builder.build(parent, cmnode);
        this.insertNodesAtIndex(parent, builder.getResult(), index);
    }

    public void insertNodesAtIndex(Node parent, List list, int index) {
        this.insertNodesAtIndex(parent, list, index, true);
    }

    public void insertNodesAtIndex(Node parent, List list, int index, boolean format) {
        Node prevChild;
        NodeList nodeList = parent.getChildNodes();
        if (index == -1) {
            index = nodeList.getLength();
        }
        Node refChild = index < nodeList.getLength() ? nodeList.item(index) : null;
        int prevIndex = index - 1;
        Node node = prevChild = prevIndex < nodeList.getLength() ? nodeList.item(prevIndex) : null;
        if (this.isWhitespaceTextNode(prevChild)) {
            refChild = prevChild;
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Node newNode = (Node)i.next();
            if (newNode.getNodeType() == 2) {
                Element parentElement = (Element)parent;
                parentElement.setAttributeNode((Attr)newNode);
                continue;
            }
            parent.insertBefore(newNode, refChild);
        }
        boolean formatDeep = false;
        Iterator i2 = list.iterator();
        while (i2.hasNext()) {
            Node newNode = (Node)i2.next();
            if (newNode.getNodeType() == 1) {
                formatDeep = true;
            }
            if (!format) continue;
            this.reformat(newNode, formatDeep);
        }
        this.setViewerSelection(list);
    }

    public abstract void reformat(Node var1, boolean var2);

    public void remove(Node parent, int startIndex, int endIndex) {
        NodeList nodeList = parent.getChildNodes();
        int i = endIndex;
        while (i >= startIndex) {
            Node node = nodeList.item(i);
            if (node != null) {
                parent.removeChild(node);
            }
            --i;
        }
    }

    public void setViewerSelection(List list) {
        if (this.fViewer != null) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(list), true);
        }
    }

    public void setViewerSelection(Node node) {
        if (this.fViewer != null) {
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
        }
    }

    public class AddNodeAction
    extends NodeAction {
        protected CMNode cmnode;
        protected String description;
        protected int index;
        protected int nodeType;
        protected Node parent;
        protected String undoDescription;

        public AddNodeAction(CMNode cmnode, Node parent, int index) {
            this.cmnode = cmnode;
            this.parent = parent;
            this.index = index;
            String text = AbstractNodeActionManager.this.getLabel(parent, cmnode);
            this.setText(text);
            this.description = text;
            this.undoDescription = String.valueOf(XMLUIMessages._UI_MENU_ADD) + " " + text;
            ImageDescriptor descriptor = CMImageUtil.getImageDescriptor(cmnode);
            if (descriptor == null) {
                descriptor = AbstractNodeActionManager.this.imageDescriptorCache.getImageDescriptor(cmnode);
            }
            this.setImageDescriptor(descriptor);
        }

        public AddNodeAction(int nodeType, Node parent, int index) {
            this.nodeType = nodeType;
            this.index = index;
            this.parent = parent;
            switch (nodeType) {
                case 8: {
                    this.description = XMLUIMessages._UI_MENU_COMMENT;
                    this.undoDescription = XMLUIMessages._UI_MENU_ADD_COMMENT;
                    break;
                }
                case 7: {
                    this.description = XMLUIMessages._UI_MENU_PROCESSING_INSTRUCTION;
                    this.undoDescription = XMLUIMessages._UI_MENU_ADD_PROCESSING_INSTRUCTION;
                    break;
                }
                case 4: {
                    this.description = XMLUIMessages._UI_MENU_CDATA_SECTION;
                    this.undoDescription = XMLUIMessages._UI_MENU_ADD_CDATA_SECTION;
                    break;
                }
                case 3: {
                    this.description = XMLUIMessages._UI_MENU_PCDATA;
                    this.undoDescription = XMLUIMessages._UI_MENU_ADD_PCDATA;
                }
            }
            this.setText(this.description);
            this.setImageDescriptor(AbstractNodeActionManager.this.imageDescriptorCache.getImageDescriptor(new Integer(nodeType)));
        }

        protected void addNodeForCMNode() {
            if (this.parent != null) {
                AbstractNodeActionManager.this.insert(this.parent, this.cmnode, this.index);
            }
        }

        protected void addNodeForNodeType() {
            Document document = this.parent.getNodeType() == 9 ? (Document)this.parent : this.parent.getOwnerDocument();
            Node newChildNode = null;
            boolean format = true;
            switch (this.nodeType) {
                case 8: {
                    newChildNode = document.createComment(XMLUIMessages._UI_COMMENT_VALUE);
                    break;
                }
                case 7: {
                    newChildNode = document.createProcessingInstruction(XMLUIMessages._UI_PI_TARGET_VALUE, XMLUIMessages._UI_PI_DATA_VALUE);
                    break;
                }
                case 4: {
                    newChildNode = document.createCDATASection("");
                    break;
                }
                case 3: {
                    format = false;
                    newChildNode = document.createTextNode(this.parent.getNodeName());
                }
            }
            if (newChildNode != null) {
                Vector<Comment> list = new Vector<Comment>(1);
                list.add((Comment)newChildNode);
                AbstractNodeActionManager.this.insertNodesAtIndex(this.parent, list, this.index, format);
            }
        }

        public String getUndoDescription() {
            return this.undoDescription;
        }

        public void run() {
            if (this.validateEdit(AbstractNodeActionManager.this.getModel(), AbstractNodeActionManager.this.getWorkbenchWindowShell())) {
                AbstractNodeActionManager.this.beginNodeAction(this);
                if (this.cmnode != null) {
                    this.addNodeForCMNode();
                } else {
                    this.addNodeForNodeType();
                }
                AbstractNodeActionManager.this.endNodeAction(this);
            }
        }
    }

    public class DeleteAction
    extends NodeAction {
        protected List list;

        public DeleteAction(List list) {
            this.setText(XMLUIMessages._UI_MENU_REMOVE);
            this.list = list;
        }

        public DeleteAction(Node node) {
            this.setText(XMLUIMessages._UI_MENU_REMOVE);
            this.list = new Vector();
            this.list.add(node);
        }

        public String getUndoDescription() {
            return XMLUIMessages.DELETE;
        }

        public void run() {
            if (this.validateEdit(AbstractNodeActionManager.this.getModel(), AbstractNodeActionManager.this.getWorkbenchWindowShell())) {
                AbstractNodeActionManager.this.beginNodeAction(this);
                Iterator i = this.list.iterator();
                while (i.hasNext()) {
                    Node node = (Node)i.next();
                    if (node.getNodeType() == 2) {
                        Attr attr = (Attr)node;
                        attr.getOwnerElement().removeAttributeNode(attr);
                        continue;
                    }
                    Node parent = node.getParentNode();
                    if (parent == null) continue;
                    Node previousSibling = node.getPreviousSibling();
                    if (previousSibling != null && AbstractNodeActionManager.this.isWhitespaceTextNode(previousSibling)) {
                        parent.removeChild(previousSibling);
                    }
                    parent.removeChild(node);
                }
                AbstractNodeActionManager.this.endNodeAction(this);
            }
        }
    }

    class ImageDescriptorCache {
        protected ImageDescriptor attributeImage = XMLEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/attribute_obj.gif");
        protected ImageDescriptor attributeReqImage = XMLEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/att_req_obj.gif");
        protected ImageDescriptor cdataSectionImage = XMLEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/cdatasection.gif");
        protected ImageDescriptor commentImage = XMLEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/comment_obj.gif");
        protected ImageDescriptor elementImage = XMLEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/element_obj.gif");
        protected ImageDescriptor piImage = XMLEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/proinst_obj.gif");
        protected ImageDescriptor textImage = XMLEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/text.gif");

        ImageDescriptorCache() {
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            ImageDescriptor result;
            block17: {
                block16: {
                    result = null;
                    if (!(object instanceof CMNode)) break block16;
                    CMNode cmnode = (CMNode)object;
                    switch (cmnode.getNodeType()) {
                        case 2: {
                            result = CMImageUtil.getImageDescriptor(cmnode);
                            if (result == null) {
                                if (((CMAttributeDeclaration)cmnode).getUsage() == 2) {
                                    result = this.attributeReqImage;
                                    break;
                                }
                                result = this.attributeImage;
                                break;
                            }
                            break block17;
                        }
                        case 3: {
                            result = this.textImage;
                            break;
                        }
                        case 5: {
                            result = CMImageUtil.getImageDescriptor(cmnode);
                            if (result == null) {
                                result = this.elementImage;
                                break;
                            }
                            break block17;
                        }
                        case 7: {
                            result = this.elementImage;
                        }
                    }
                    break block17;
                }
                if (object instanceof Integer) {
                    Integer integer = (Integer)object;
                    switch (integer) {
                        case 8: {
                            result = this.commentImage;
                            break;
                        }
                        case 7: {
                            result = this.piImage;
                            break;
                        }
                        case 4: {
                            result = this.cdataSectionImage;
                            break;
                        }
                        case 3: {
                            result = this.textImage;
                        }
                    }
                }
            }
            return result;
        }
    }

    public class InsertAction
    extends NodeAction {
        protected String description;
        protected int index;
        protected int nodeType;
        protected Node parent;

        public InsertAction(int nodeType, Node parent, int index) {
            this.nodeType = nodeType;
            this.index = index;
            this.parent = parent;
            switch (nodeType) {
                case 8: {
                    this.description = XMLUIMessages._UI_MENU_COMMENT;
                    break;
                }
                case 7: {
                    this.description = XMLUIMessages._UI_MENU_PROCESSING_INSTRUCTION;
                    break;
                }
                case 4: {
                    this.description = XMLUIMessages._UI_MENU_CDATA_SECTION;
                    break;
                }
                case 3: {
                    this.description = XMLUIMessages._UI_MENU_PCDATA;
                }
            }
            this.setText(this.description);
            this.setImageDescriptor(AbstractNodeActionManager.this.imageDescriptorCache.getImageDescriptor(new Integer(nodeType)));
        }

        public InsertAction(int nodeType, Node parent, int index, String title) {
            this.nodeType = nodeType;
            this.index = index;
            this.parent = parent;
            this.description = title;
            this.setText(this.description);
            this.setImageDescriptor(AbstractNodeActionManager.this.imageDescriptorCache.getImageDescriptor(new Integer(nodeType)));
        }

        public String getUndoDescription() {
            return String.valueOf(XMLUIMessages._UI_MENU_ADD) + " " + this.description;
        }

        public void run() {
            if (this.validateEdit(AbstractNodeActionManager.this.getModel(), AbstractNodeActionManager.this.getWorkbenchWindowShell())) {
                AbstractNodeActionManager.this.beginNodeAction(this);
                Document document = this.parent.getNodeType() == 9 ? (Document)this.parent : this.parent.getOwnerDocument();
                Node newChildNode = null;
                boolean format = true;
                switch (this.nodeType) {
                    case 8: {
                        newChildNode = document.createComment(XMLUIMessages._UI_COMMENT_VALUE);
                        break;
                    }
                    case 7: {
                        newChildNode = document.createProcessingInstruction(XMLUIMessages._UI_PI_TARGET_VALUE, XMLUIMessages._UI_PI_DATA_VALUE);
                        break;
                    }
                    case 4: {
                        newChildNode = document.createCDATASection("");
                        break;
                    }
                    case 3: {
                        format = false;
                        newChildNode = document.createTextNode(this.parent.getNodeName());
                    }
                }
                if (newChildNode != null) {
                    Vector<Comment> list = new Vector<Comment>(1);
                    list.add((Comment)newChildNode);
                    AbstractNodeActionManager.this.insertNodesAtIndex(this.parent, list, this.index, format);
                }
                AbstractNodeActionManager.this.endNodeAction(this);
            }
        }
    }

    public class ReplaceNodeAction
    extends NodeAction {
        protected CMNode cmnode;
        protected String description;
        protected int endIndex;
        protected Node parent;
        protected int startIndex;

        public ReplaceNodeAction(Node parent, CMNode cmnode, int startIndex, int endIndex) {
            this.parent = parent;
            this.cmnode = cmnode;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.setText(AbstractNodeActionManager.this.getLabel(parent, cmnode));
            this.setImageDescriptor(AbstractNodeActionManager.this.imageDescriptorCache.getImageDescriptor(cmnode));
        }

        public String getUndoDescription() {
            String result = XMLUIMessages._UI_LABEL_UNDO_REPLACE_DESCRIPTION;
            result = String.valueOf(result) + " " + AbstractNodeActionManager.this.getLabel(this.parent, this.cmnode);
            return result;
        }

        public void run() {
            if (this.validateEdit(AbstractNodeActionManager.this.getModel(), AbstractNodeActionManager.this.getWorkbenchWindowShell())) {
                AbstractNodeActionManager.this.beginNodeAction(this);
                if (this.parent != null && this.cmnode != null) {
                    AbstractNodeActionManager.this.remove(this.parent, this.startIndex, this.endIndex);
                    AbstractNodeActionManager.this.insert(this.parent, this.cmnode, this.startIndex);
                }
                AbstractNodeActionManager.this.endNodeAction(this);
            }
        }
    }
}

